/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.AdminCertDO;
import com.xdja.pki.ra.manager.dto.AdminCertDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class AdminCertDao
extends BaseJdbcDao {
    public PageInfo<AdminCertDTO> listPageAdminCert(String certDN, int pageNo, int pageSize) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT a.`id` AS id, a.`cert_dn` AS certDN, a.`cert_sn` AS signCertSn,b.`cert_sn` AS encCertSn , a.`sign_alg` AS signAlg, a.`role_info` AS roleInfo,a.`cert_status` AS certStatus, a.`private_key_length` AS privateKeyLength,a.`cert_validity` AS certValidity ,a.`admin_type` AS adminType,a.`effective_time` AS effectiveTime ,a.`failure_time` AS failureTime");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM admin_cert a ,admin_cert b WHERE a.pair_cert_index= b.`pair_cert_index` AND a.`cert_type` = 2 AND b.`cert_type`=3  AND a.`admin_type` = 3 AND a.cert_status !=0 AND b.cert_status !=0 ");
        if (StringUtils.isNotBlank((CharSequence)certDN)) {
            fromSql.append(" AND a.`cert_dn` LIKE :certDN ");
            params.addValue("certDN", (Object)("%" + certDN + "%"));
        }
        fromSql.append(" ORDER BY a.gmt_create DESC");
        countSql.append((CharSequence)fromSql);
        PageInfo<AdminCertDTO> page = new PageInfo<AdminCertDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(AdminCertDTO.class)));
        return page;
    }

    public AdminCertDO getAdminCertInfo(String certSn, int certType) {
        return (AdminCertDO)this.daoTemplate.fetch(AdminCertDO.class, (Condition)Cnd.where((String)"certSn", (String)"=", (Object)certSn).and("certType", "=", (Object)certType).and("certStatus", "!=", (Object)0));
    }

    public AdminCertDO getAdminCertInfoByType(String certSn, int certType, int adminType) {
        return (AdminCertDO)this.daoTemplate.fetch(AdminCertDO.class, (Condition)Cnd.where((String)"certSn", (String)"=", (Object)certSn).and("certType", "=", (Object)certType).and("certStatus", "!=", (Object)0).and("adminType", "==", (Object)adminType));
    }

    public List<AdminCertDO> queryAdminCertByCertDn(String certDn, String cardNo) {
        String sql = "SELECT * FROM admin_cert WHERE cert_dn = :certDn and card_no != :cardNo";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certDn", (Object)certDn);
        params.addValue("cardNo", (Object)cardNo);
        List adminCertDOList = this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(AdminCertDO.class));
        return adminCertDOList;
    }

    public Map<String, Object> getAdminCertBase64Info(String signSn) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.`cert_info` AS signCert, b.`cert_info` AS encCert FROM admin_cert a ,admin_cert b WHERE a.pair_cert_index = b.`pair_cert_index` AND a.`cert_type` = 2 AND b.`cert_type`=3 AND a.`cert_sn`= :signSn AND a.cert_status !=0 AND b.cert_status !=0 ; ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        return this.queryForMap(sql.toString(), (SqlParameterSource)params);
    }

    public AdminCertDO insertAdminCert(AdminCertDO adminCertDO) {
        return (AdminCertDO)this.daoTemplate.insert((Object)adminCertDO);
    }

    public int updateAdminCert(AdminCertDO adminCertDO) {
        return this.daoTemplate.update((Object)adminCertDO);
    }

    public int updateAdminCertStatus(int certStatus, String signSn) {
        String sql = "UPDATE admin_cert a ,admin_cert b SET a.`cert_status` = :certStatus , b.`cert_status` = :certStatus  WHERE a.pair_cert_index= b.`pair_cert_index` AND a.`cert_type` = 2 AND b.`cert_type`=3 AND a.`cert_sn`= :signSn ;";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        params.addValue("certStatus", (Object)certStatus);
        return this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
    }

    public int updateAdminEncCertInfoBySignSn(String signSn, String encSn, String certInfo) {
        String sql = "  UPDATE  admin_cert  SET `cert_sn`=:encSn ,`cert_info`=:certInfo WHERE cert_type =3 AND  pair_cert_index = (SELECT b.pair_cert_index FROM (SELECT * FROM admin_cert) AS b WHERE b.`cert_type`= 2 AND b.`cert_sn`=:signSn)";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        params.addValue("encSn", (Object)encSn);
        params.addValue("certInfo", (Object)certInfo);
        return this.daoTemplate.executeSql(sql, (SqlParameterSource)params);
    }

    public String getEncPubKeyBySignSn(String signSn) {
        String sql = " SELECT a.`enc_pub_key` FROM admin_cert a WHERE a.`cert_type` = 3 AND a.`pair_cert_index` = (SELECT b.`pair_cert_index` FROM admin_cert b WHERE  b.`cert_type` = 2 AND b.`admin_type` =3 AND b.`cert_sn` = :signSn )";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }
}

