/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CertTempDao
extends BaseJdbcDao {
    public PageInfo<CertTempDO> listPageAppUserCert(String tempName, int tempStatus, int pageNo, int pageSize) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT  id , temp_no AS tempNo, temp_name AS tempName, temp_type AS tempType, check_strategy AS checkStrategy, sign_alg AS signAlg,cert_patterm AS certPatterm, temp_status AS tempStatus ,temp_bound AS tempBound");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM cert_template WHERE 1=1");
        if (StringUtils.isNotBlank((CharSequence)tempName)) {
            fromSql.append(" AND temp_name like :tempName");
            params.addValue("tempName", (Object)("%" + tempName + "%"));
        }
        if (tempStatus != 0) {
            fromSql.append(" AND temp_status = :tempStatus");
            params.addValue("tempStatus", (Object)tempStatus);
        }
        fromSql.append(" AND is_newest_temp = 1");
        fromSql.append(" ORDER BY temp_no DESC");
        countSql.append((CharSequence)fromSql);
        PageInfo<CertTempDO> page = new PageInfo<CertTempDO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class)));
        return page;
    }

    public int updateCertTempCheckStrategy(String tempNo, int checkStrategy) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE cert_template SET check_strategy = :checkStrategy where temp_no = :tempNo AND is_newest_temp =1");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("checkStrategy", (Object)checkStrategy);
        params.addValue("tempNo", (Object)tempNo);
        return this.executeSql(sql.toString(), (SqlParameterSource)params);
    }

    public CertTempDO getCertTempInfoByTempNo(String tempNo) {
        return (CertTempDO)this.daoTemplate.fetch(CertTempDO.class, (Condition)Cnd.where((String)"temp_no", (String)"=", (Object)tempNo).and("is_newest_temp", "=", (Object)1));
    }

    public List<CertTempDO> listCertTemplateDropDownList() {
        String sql = "SELECT id,temp_no,temp_name,temp_paras,max_validity,private_key_length,sign_alg,cert_patterm,baseDn FROM cert_template WHERE  temp_status = 2 AND is_newest_temp =1 AND temp_bound = 1";
        List certTempDOList = this.daoTemplate.queryForList(sql, null, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
        return certTempDOList;
    }

    public List<CertTempDO> getAllNewCertTemplateList() {
        String sql = "SELECT * FROM cert_template WHERE is_newest_temp = 1 order by temp_no desc";
        List certTempDOList = this.daoTemplate.queryForList(sql, null, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
        return certTempDOList;
    }

    public String getTempNoBySn(String sn) {
        String sql = "SELECT temp_no FROM user_cert WHERE cert_sn = :Sn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("Sn", (Object)sn);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }

    public void updateCertTempNewStatus() {
        String sql = " UPDATE cert_template SET is_newest_temp = 0 WHERE is_newest_temp =1 ";
        this.daoTemplate.update(sql, null);
    }

    public CertTempDO insertCertTemp(CertTempDO certTempDO) {
        return (CertTempDO)this.daoTemplate.insert((Object)certTempDO);
    }

    public CertTempDO getCertTempInfoByTempId(long tempId) {
        return (CertTempDO)this.daoTemplate.fetch(CertTempDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)tempId));
    }
}

