/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.manager.dao.BaseUserDao;
import com.xdja.pki.ra.manager.dao.model.OrganUserDO;
import com.xdja.pki.ra.manager.dto.OrganUserDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class OrganUserDao
extends BaseJdbcDao {
    @Autowired
    private BaseUserDao baseUserDao;

    public PageInfo<OrganUserDTO> listPageOrganUser(String organName, String licenseNumber, int status, int pageNo, int pageSize) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT organuser.id, organuser.organ_no AS organNo,organuser.user_id AS userId, organuser.organ_name AS organName, organuser.person_id  AS personId, organuser.license_type AS licenseType, organuser.license_number AS licenseNumber, baseUser.status AS status,baseUser.system_flag AS systemFlag, organuser.gmt_create AS gmtCreate, person.person_name AS personName, person.tel_number AS telNumber,a.customer_sys_name AS systemName");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM organ_user organuser , contact_user AS person ,base_user AS baseUser ,customer_sys a ");
        fromSql.append(" WHERE baseUser.id = organuser.user_id AND person.id = organuser.person_id AND a.customer_sys_number = baseUser.system_flag ");
        if (StringUtils.isNotBlank((CharSequence)organName)) {
            fromSql.append(" AND organuser.organ_name like :organName");
            params.addValue("organName", (Object)("%" + organName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)licenseNumber)) {
            fromSql.append(" AND organuser.license_number = :licenseNumber");
            params.addValue("licenseNumber", (Object)licenseNumber);
        }
        if (status != -1) {
            fromSql.append(" AND baseUser.status = :status");
            params.addValue("status", (Object)status);
        }
        fromSql.append(" ORDER BY baseUser.gmt_create DESC");
        countSql.append((CharSequence)fromSql);
        PageInfo<OrganUserDTO> page = new PageInfo<OrganUserDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(OrganUserDTO.class)));
        return page;
    }

    public OrganUserDO saveOrganUserInfo(OrganUserDO organUser) {
        return (OrganUserDO)this.daoTemplate.insert((Object)organUser);
    }

    public OrganUserDO getOrganUser(Long OrganId) {
        try {
            return (OrganUserDO)this.daoTemplate.fetch(OrganUserDO.class, (Condition)Cnd.where((String)"user_id", (String)"=", (Object)OrganId));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public OrganUserDO getOrganUser(Integer identType, String licenseNumber, String systemFlag) {
        try {
            return (OrganUserDO)this.daoTemplate.fetch(OrganUserDO.class, (Condition)Cnd.where((String)"user_id", (String)"=", (Object)this.baseUserDao.getUserId(UserTypeEnum.ORGAN_USER.id, systemFlag, identType, licenseNumber)));
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public OrganUserDTO getOrganUserInfo(Integer identType, String licenseNumber, String systemFlag) {
        try {
            String sql = "SELECT c.user_type AS userType, c.STATUS AS status, a.organ_name AS organName, a.license_type AS licenseType, a.legal_person AS legalPerson, a.license_number AS licenseNumber, a.postal_code AS postalCode, a.email AS email, a.address AS address, b.sex AS sex, a.person_id AS personId, b.person_name AS personName, b.tel_number AS telNumber, b.license_type AS personLicenseType,b.email AS personEmail, b.license_number AS personLicenseNumber, c.system_flag AS systemFlag,b.address AS personAddress, b.postal_code AS personPostalCode, b.remark AS remark, b.gmt_create AS gmtCreate FROM organ_user AS a LEFT JOIN contact_user AS b ON b.id = a.person_id LEFT JOIN base_user AS c ON c.id = a.user_id WHERE a.license_type = :identType and a.license_number=:licenseNumber and c.system_flag = :systemFlag ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("identType", (Object)identType);
            params.addValue("licenseNumber", (Object)licenseNumber);
            params.addValue("systemFlag", (Object)systemFlag);
            OrganUserDTO organUserDTO = (OrganUserDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(OrganUserDTO.class));
            return organUserDTO;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public OrganUserDTO getOrganUserInfo(long organId) {
        try {
            String sql = "SELECT c.user_type AS userType, c.STATUS AS STATUS, a.organ_name AS organName, a.license_type AS licenseType, a.legal_person AS legalPerson, a.license_number AS licenseNumber, a.postal_code AS postalCode, a.email AS email, a.address AS address, b.sex AS sex, b.person_name AS personName, b.tel_number AS telNumber, b.license_type AS personLicenseType,b.email AS personEmail, b.license_number AS personLicenseNumber, c.system_flag AS systemFlag,b.address AS personAddress, b.postal_code AS personPostalCode, b.remark AS remark, b.gmt_create AS gmtCreate FROM organ_user AS a LEFT JOIN contact_user AS b ON b.id = a.person_id LEFT JOIN base_user AS c ON c.id = a.user_id WHERE a.id = :organId";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("organId", (Object)organId);
            OrganUserDTO organUserDTO = (OrganUserDTO)this.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(OrganUserDTO.class));
            return organUserDTO;
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }

    public int updateOrganUserInfo(OrganUserDO organUserDO) {
        return this.daoTemplate.updateIgnoreNull((Object)organUserDO);
    }

    public Long getId(Integer identType, String licenseNumber) {
        try {
            String sql = "SELECT id FROM organ_user WHERE license_type = :licenseType AND license_number = :licenseNumber";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("licenseType", (Object)identType);
            params.addValue("licenseNumber", (Object)licenseNumber);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (EmptyResultDataAccessException e) {
            return null;
        }
    }
}

