/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.manager.dao.model.BaseUserDO;
import com.xdja.pki.ra.manager.dao.model.CertTempDO;
import com.xdja.pki.ra.manager.dto.StatisticsCertDTO;
import com.xdja.pki.ra.manager.dto.StatisticsCustomerDTO;
import com.xdja.pki.ra.manager.dto.StatisticsUserDTO;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class StatisticsDao
extends BaseJdbcDao {
    public List<StatisticsCustomerDTO> getCustomerCertCount(String customerSysName, String startTime, String endTime) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String nameSelectSql = "";
        String nameSelectSql2 = "";
        String timeSelectSql = "";
        if (StringUtils.isNotBlank((CharSequence)customerSysName)) {
            nameSelectSql = " AND a.customer_sys_name like :customerSysName ";
            nameSelectSql2 = " AND c.customer_sys_name like :customerSysName ";
            params.addValue("customerSysName", (Object)("%" + customerSysName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeSelectSql = "AND a.gmt_create >= :startTime AND a.gmt_create <= :endTime ";
            params.addValue("startTime", (Object)(startTime + " 00:00:00"));
            params.addValue("endTime", (Object)(endTime + " 23:59:59"));
        }
        String selectSql = "SELECT  t.system_flag AS customerSysNumber , c.customer_sys_name AS customerSysName, t.normal, t.outdate, t.revoked, t.freeze, t.total\n                FROM\n                (SELECT \n                coalesce(system_flag,'\u5408\u8ba1') AS system_flag, \n                SUM(normal) normal, SUM(outdate) outdate, SUM(revoked) revoked, SUM(freeze) freeze, SUM(total) total\n                FROM\n                (SELECT a.customer_sys_number AS system_flag, 0 normal, 0 outdate, 0 revoked, 0 freeze, 0 total\n                FROM customer_sys a \n                WHERE a.is_inner != 1 " + nameSelectSql + " UNION ALL\n   SELECT  system_flag AS systemflag, \n                COUNT(IF(cert_status = 1 AND failure_time > NOW() , 1, NULL)) normal,\n                COUNT(IF(failure_time <= NOW() AND cert_status != 0, 1, NULL)) outdate,\n                COUNT(IF(cert_status = 3 AND failure_time > NOW(), 1, NULL)) revoked,\n                COUNT(IF(cert_status = 4 AND failure_time > NOW() , 1, NULL)) freeze,\n                COUNT(IF(cert_status != 0 , 1, NULL)) total     FROM\n (SELECT b.system_flag ,a.cert_status, c.customer_sys_name AS customerSysName,a.failure_time\n FROM user_cert a, base_user b, customer_sys c \n WHERE b.id = a.user_id AND c.is_inner != 1  \n" + timeSelectSql + "  AND c.customer_sys_number = b.system_flag\n" + nameSelectSql2 + "  ) AS d\n  GROUP BY system_flag\n )AS e\n            GROUP BY system_flag WITH ROLLUP ) AS t\nLEFT JOIN customer_sys AS c  ON c.customer_sys_number = t.system_flag \n";
        return this.daoTemplate.queryForList(selectSql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCustomerDTO.class));
    }

    public List<StatisticsCertDTO> getCertCount(String certTemplateName, String startTime, String endTime) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String templateWhereReqSql = "";
        String templateAndReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)certTemplateName)) {
            templateWhereReqSql = "Where cert_template.temp_name = :certTemplateName ";
            templateAndReqSql = "AND cert_template.temp_name = :certTemplateName ";
            params.addValue("certTemplateName", (Object)certTemplateName);
        }
        String timeReqSql = "";
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            timeReqSql = "AND user_cert.gmt_create >= :startTime AND user_cert.gmt_create <= :endTime ";
            params.addValue("startTime", (Object)(startTime + " 00:00:00"));
            params.addValue("endTime", (Object)(endTime + " 23:59:59"));
        }
        String sql = "SELECT \nCASE WHEN temp_name IS NOT NULL THEN temp_name ELSE \"\u5408\u8ba1\" END AS temp_name,\nSUM(normal) normal, SUM(outdate) outdate, SUM(revoked) revoked, SUM(freeze) freeze,SUM(total) total FROM (\n\t\n\tSELECT\n\ttemp_name,\n\t0 normal,\n\t0 outdate,\n\t0 revoked,\n  0 freeze,\t0 total\n\tFROM cert_template \n" + templateWhereReqSql + "\t\n\tUNION ALL\n\t\n\tSELECT temp_name , \n\tCOUNT(IF(user_cert.cert_status = 1 AND user_cert.failure_time > NOW() , 1, NULL)) normal,\n\tCOUNT(IF(user_cert.failure_time <= NOW() AND user_cert.cert_status != 0, 1, NULL)) outdate,\n\tCOUNT(IF(user_cert.cert_status = 3 AND user_cert.failure_time > NOW(), 1, NULL)) revoked,\n  COUNT(IF(user_cert.cert_status = 4 AND user_cert.failure_time > NOW(), 1, NULL)) freeze,\tCOUNT(IF(user_cert.cert_status != 0 , 1, NULL)) total\n\tFROM cert_template \n\tLEFT JOIN user_cert ON user_cert.temp_no = cert_template.temp_no\n\tWHERE cert_template.is_newest_temp = 1 \n" + templateAndReqSql + timeReqSql + "\tGROUP BY temp_name\n\n) AS t GROUP BY temp_name WITH ROLLUP";
        this.logger.info("selectSql========" + sql);
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(StatisticsCertDTO.class));
    }

    public List<StatisticsUserDTO> getUserCount(String startTime, String endTime) {
        ArrayList<StatisticsUserDTO> list = new ArrayList<StatisticsUserDTO>();
        StatisticsUserDTO person = new StatisticsUserDTO();
        int personNormal = this.countUser(UserTypeEnum.PERSON_USER.id, UserStatusEnum.NORMAL.id, startTime, endTime);
        int personDisabled = this.countUser(UserTypeEnum.PERSON_USER.id, UserStatusEnum.DISABLED.id, startTime, endTime);
        person.setType(UserTypeEnum.PERSON_USER.id);
        person.setTypeString(UserTypeEnum.PERSON_USER.value);
        person.setNormal(personNormal);
        person.setDisabled(personDisabled);
        person.setTotal(personNormal + personDisabled);
        list.add(person);
        StatisticsUserDTO organ = new StatisticsUserDTO();
        int organNormal = this.countUser(UserTypeEnum.ORGAN_USER.id, UserStatusEnum.NORMAL.id, startTime, endTime);
        int organDisabled = this.countUser(UserTypeEnum.ORGAN_USER.id, UserStatusEnum.DISABLED.id, startTime, endTime);
        organ.setType(UserTypeEnum.ORGAN_USER.id);
        organ.setTypeString(UserTypeEnum.ORGAN_USER.value);
        organ.setNormal(organNormal);
        organ.setDisabled(organDisabled);
        organ.setTotal(organNormal + organDisabled);
        list.add(organ);
        StatisticsUserDTO device = new StatisticsUserDTO();
        int deviceNormal = this.countUser(UserTypeEnum.DEVICE_USER.id, UserStatusEnum.NORMAL.id, startTime, endTime);
        int deviceDisabled = this.countUser(UserTypeEnum.DEVICE_USER.id, UserStatusEnum.DISABLED.id, startTime, endTime);
        device.setType(UserTypeEnum.DEVICE_USER.id);
        device.setTypeString(UserTypeEnum.DEVICE_USER.value);
        device.setNormal(deviceNormal);
        device.setDisabled(deviceDisabled);
        device.setTotal(deviceNormal + deviceDisabled);
        list.add(device);
        return list;
    }

    private int countUser(int type, int status, String startTime, String endTime) {
        Cnd cnd = Cnd.NEW();
        cnd.and("user_type", "=", (Object)type);
        cnd.and("status", "=", (Object)status);
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            cnd.and("gmt_create", ">=", (Object)(startTime + " 00:00:00"));
            cnd.and("gmt_create", "<=", (Object)(endTime + " 23:59:59"));
        }
        return this.daoTemplate.count(BaseUserDO.class, (Condition)cnd);
    }

    public List<CertTempDO> getTemplate() {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT temp_no,temp_name FROM cert_template GROUP BY temp_no ORDER BY temp_name";
        return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertTempDO.class));
    }
}

