/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.manager.dao.model.BksIndexDO;
import com.xdja.pki.ra.manager.dao.model.CertApplyDO;
import com.xdja.pki.ra.manager.dto.CertApplyDTO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.sql.Timestamp;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class CertApplyDao
extends BaseJdbcDao {
    public Integer getCertPatterm(String applyNo) {
        String sql = "SELECT cert_patterm FROM cert_template ,cert_apply WHERE cert_template.id = cert_apply.temp_id AND cert_apply.apply_no = :applyNo";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public PageInfo<CertApplyDTO> listPageUserCert(String userCA, String userName, int userType, int applyStatus, int pageNo, int pageSize, String startTime, String endTime) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT a.user_name AS userName, a.user_type AS userType, a.system_flag AS systemFlag, ");
        selectSql.append("b.id, b.apply_no AS applyNo, b.apply_type AS applyType, b.cert_dn AS certDn, b.admin_cert_dn AS adminCertDn,");
        selectSql.append("b.apply_status AS applyStatus, b.gmt_create AS gmtCreate, b.`temp_id` AS tempId ");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM base_user a, cert_apply b, cert_template c WHERE a.`id` = b.`user_id` AND  c.`id` = b.temp_id");
        if (StringUtils.isNotBlank((CharSequence)userName)) {
            fromSql.append(" AND a.user_name like :userName");
            params.addValue("userName", (Object)("%" + userName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)userCA)) {
            fromSql.append(" AND c.user_ca like :userCA");
            params.addValue("userCA", (Object)("%" + userCA + "%"));
        }
        if (userType != 0) {
            fromSql.append(" AND a.user_type = :userType");
            params.addValue("userType", (Object)userType);
        }
        if (applyStatus != 0) {
            fromSql.append(" AND b.apply_status = :applyStatus");
            params.addValue("applyStatus", (Object)applyStatus);
        }
        if (StringUtils.isNotBlank((CharSequence)startTime) && StringUtils.isNotBlank((CharSequence)endTime)) {
            fromSql.append(" AND b.gmt_create >= :startTime");
            fromSql.append(" AND b.gmt_create <= :endTime");
            params.addValue("startTime", (Object)startTime);
            params.addValue("endTime", (Object)endTime);
        }
        fromSql.append(" ORDER BY b.gmt_update DESC");
        countSql.append((CharSequence)fromSql);
        PageInfo<CertApplyDTO> page = new PageInfo<CertApplyDTO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
        fromSql.append(" LIMIT :offset, :pageSize");
        params.addValue("offset", (Object)page.getOffset());
        params.addValue("pageSize", (Object)page.getPageSize());
        selectSql.append((CharSequence)fromSql);
        page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertApplyDTO.class)));
        return page;
    }

    public String getCertApplyNo(long id) {
        CertApplyDO certApplyDO = (CertApplyDO)this.daoTemplate.fetch(CertApplyDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        return certApplyDO.getApplyNo();
    }

    public CertApplyDO getCertApplyInfo(String applyNo) {
        return (CertApplyDO)this.daoTemplate.fetch(CertApplyDO.class, (Condition)Cnd.where((String)"applyNo", (String)"=", (Object)applyNo));
    }

    public CertApplyDO getCertApplyInfo(String applyNo, Integer applyType) {
        return (CertApplyDO)this.daoTemplate.fetch(CertApplyDO.class, (Condition)Cnd.where((String)"applyNo", (String)"=", (Object)applyNo).and("applyType", "=", (Object)applyType));
    }

    public CertApplyDO insertCertApply(CertApplyDO certApplyDO) {
        return (CertApplyDO)this.daoTemplate.insert((Object)certApplyDO);
    }

    public int updateCertApply(CertApplyDO certApplyDO) {
        return this.daoTemplate.update((Object)certApplyDO);
    }

    public int updateCertApplyInfo(String applyNo, String certDn, int applyStatus, long adminId, String adminCertDn, long tempId) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE cert_apply SET cert_dn =:certDn, apply_status =:applyStatus ,admin_id =:adminId,admin_cert_dn=:adminCertDn,gmt_update=:gmtUpdate ,temp_id =:tempId WHERE apply_no = :applyNo");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        params.addValue("certDn", (Object)certDn);
        params.addValue("applyStatus", (Object)applyStatus);
        params.addValue("adminId", (Object)adminId);
        params.addValue("adminCertDn", (Object)adminCertDn);
        params.addValue("tempId", (Object)tempId);
        params.addValue("gmtUpdate", (Object)new Timestamp(System.currentTimeMillis()));
        return this.executeSql(sql.toString(), (SqlParameterSource)params);
    }

    public int getCertApplyCountByCertDn(String certDn, long userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT COUNT(*)  FROM cert_apply a, base_user b WHERE b.`id` = a.`user_id` AND a.apply_status != 4 AND a.cert_dn = :certDn AND a.user_id!=:userId ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("certDn", (Object)certDn);
        params.addValue("userId", (Object)userId);
        int count = this.daoTemplate.queryForInt(sql.toString(), (SqlParameterSource)params);
        return count;
    }

    public List<String> getCertSnByApplyNo(String applyNo) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT a.`cert_sn` FROM user_cert a,cert_apply b WHERE a.`apply_id` = b.`id` AND b.`apply_no` =:applyNo AND  a.cert_type IN (1,2) ORDER BY a.`gmt_create` DESC");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        List list = this.daoTemplate.queryColumnForList(sql.toString(), (SqlParameterSource)params, "cert_sn");
        return list;
    }

    public String getCertDnByApplyNo(String applyNo) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT `cert_dn` FROM cert_apply  WHERE `apply_no` =:applyNo ;");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        String certSn = this.daoTemplate.queryForString(sql.toString(), (SqlParameterSource)params);
        return certSn;
    }

    public Long getUserIdByApplyNo(String applyNo) {
        try {
            String sql = "SELECT user_id FROM cert_apply WHERE apply_no = :applyNo";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("applyNo", (Object)applyNo);
            return this.daoTemplate.queryForLong(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u6839\u636e\u7533\u8bf7\u7f16\u53f7\uff0c\u83b7\u53d6userId\u5931\u8d25", (Throwable)e);
        }
    }

    public int updateCertStatusByUserId(long userId, int applyStatus) {
        StringBuilder sql = new StringBuilder();
        sql.append("UPDATE cert_apply SET apply_status = :applyStatus WHERE user_id = :userId AND apply_type IN (1,2) AND apply_status IN (1,2,3) ;");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("userId", (Object)userId);
        params.addValue("applyStatus", (Object)applyStatus);
        return this.executeSql(sql.toString(), (SqlParameterSource)params);
    }

    public List<CertApplyDO> getUnEndCertApplyByUserId(long userId) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT * FROM cert_apply WHERE user_id = :userId AND apply_type IN (1,2) AND apply_status IN (1,2,3);");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("userId", (Object)userId);
        return this.queryForList(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(CertApplyDO.class));
    }

    public CertApplyDO getCertApply(String signSn, Integer applyType) {
        return (CertApplyDO)this.daoTemplate.fetch(CertApplyDO.class, (Condition)Cnd.where((String)"cert_sn", (String)"=", (Object)signSn).and("apply_type", "=", (Object)applyType));
    }

    public String getSystemCertDn(String systemFlag) {
        MapSqlParameterSource params = new MapSqlParameterSource();
        String sql = "SELECT c.cert_dn FROM customer_sys_cert c WHERE customer_sys_number = :systemFlag AND c.cert_type != 3 order by c.gmt_create DESC LIMIT 0,1;";
        params.addValue("systemFlag", (Object)systemFlag);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }

    public String getBaseDnByTempNo(String tempNo) {
        String sql = "SELECT base_dn AS baseDn FROM cert_template  WHERE is_newest_temp =1 AND temp_no = :tempNo";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("tempNo", (Object)tempNo);
        return this.daoTemplate.queryForString(sql, (SqlParameterSource)params);
    }

    public BksIndexDO insertBksIndex(BksIndexDO bksIndexDO) {
        return (BksIndexDO)this.daoTemplate.insert((Object)bksIndexDO);
    }

    public BksIndexDO getBksIndex(String signSn) {
        return (BksIndexDO)this.daoTemplate.fetch(BksIndexDO.class, (Condition)Cnd.where((String)"sign_sn", (String)"=", (Object)signSn));
    }
}

