/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.FreezeApplyDO;
import com.xdja.pki.ra.manager.dto.FreezeApplyDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class FreezeApplyDao
extends BaseJdbcDao {
    private static final Logger log = LoggerFactory.getLogger(FreezeApplyDao.class);

    public int getUnClosedFreezeApplyNum(String signSn) {
        String sql = "SELECT COUNT(*) FROM `apply_freeze` a,`cert_apply` b WHERE a.`apply_id` = b.`id` AND b.`apply_status` IN (1,3) AND a.`sign_sn` =:signSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        return this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
    }

    public FreezeApplyDTO getFreezeApplyInfoByApplyNo(String applyNo) {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("SELECT a.`user_id` userId,a.`temp_id` tempId,a.`cert_dn` certDn,a.`apply_type` applyType, a.`apply_status` applyStatus,a.`gmt_create` gmtCreate,").append("b.`temp_no` tempNo ,b.`temp_name` tempName, b.`temp_paras` tempParas, b.user_ca AS userCA,").append("c.`user_name` userName,c.`user_type` userType,c.system_flag  systemFlag,c.`status` userStatus,c.`license_type` licenseType, c.`license_number` licenseNumber,").append("d.`sign_alg` signAlg , d.`private_key_length` privateKeyLength ,d.`cert_validity` certValidity ,").append("d.`apply_reason` applyReason  , d.`sign_sn` signSn ,d.`enc_sn` encSn,e.customer_sys_name AS systemName ").append("FROM cert_apply a,cert_template b, base_user c ,apply_freeze d, customer_sys e ").append("WHERE  a.`temp_id` = b.`id` AND a.`user_id` = c.`id` AND a.`id` = d.`apply_id` ").append("AND c.system_flag = e.customer_sys_number AND a.`apply_no`=:applyNo");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        FreezeApplyDTO freezeApplyDTO = (FreezeApplyDTO)this.queryForObject(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(FreezeApplyDTO.class));
        return freezeApplyDTO;
    }

    public FreezeApplyDO insertFreezeApply(FreezeApplyDO freezeApplyDO) {
        return (FreezeApplyDO)this.daoTemplate.insert((Object)freezeApplyDO);
    }
}

