/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.manager.dao.model.RevokeApplyDO;
import com.xdja.pki.ra.manager.dto.RevokeApplyDTO;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class RevokeApplyDao
extends BaseJdbcDao {
    public RevokeApplyDO getRevokeApplyInfoByApplyId(long applyId) {
        return (RevokeApplyDO)this.daoTemplate.fetch(RevokeApplyDO.class, (Condition)Cnd.where((String)"applyId", (String)"=", (Object)applyId));
    }

    public RevokeApplyDTO getRevokeApplyInfoByApplyNo(String applyNo) {
        StringBuilder sql = new StringBuilder(1024);
        sql.append("SELECT a.`user_id` AS userId, a.`temp_id` AS tempId, a.`cert_dn` AS certDn,a.`apply_type` AS applyType, a.`apply_status` AS applyStatus, a.`gmt_create` AS gmtCreate,");
        sql.append("b.`temp_no` AS tempNo ,b.`temp_name` AS tempName, b.user_ca AS userCA, d.`apply_reason` AS applyReason, ");
        sql.append("c.`user_name` AS userName ,c.`user_type` AS userType,c.system_flag AS systemFlag,c.`status` AS userStatus,c.`license_type` AS licenseType, c.`license_number` AS licenseNumber,  ");
        sql.append("d.`sign_alg` AS signAlg , d.`private_key_length` AS privateKeyLength ,d.`cert_validity` AS certValidity, d.`revoke_reason` AS revokeReason , d.`sign_sn` AS signSn ,d.`enc_sn` AS encSn,");
        sql.append("e.customer_sys_name AS systemName ");
        sql.append("FROM cert_apply a,cert_template b, base_user c ,apply_revoke d, customer_sys e ");
        sql.append("WHERE c.system_flag = e.customer_sys_number AND a.`temp_id` = b.`id` AND a.`user_id` = c.`id` AND a.`id` = d.`apply_id` AND a.`apply_no`=:applyNo ");
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("applyNo", (Object)applyNo);
        RevokeApplyDTO revokeApplyDTO = null;
        try {
            revokeApplyDTO = (RevokeApplyDTO)this.queryForObject(sql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(RevokeApplyDTO.class));
        }
        catch (EmptyResultDataAccessException e) {
            this.logger.info("RevokeApplyDao#.getRevokeApplyInfoByApplyNo applyNo:{} \u67e5\u8be2\u51bb\u7ed3\u89e3\u51bb\u8bc1\u4e66\u7533\u8bf7\u5b9e\u4f53\u4e3a\u7a7a", (Object)applyNo);
            return null;
        }
        return revokeApplyDTO;
    }

    public RevokeApplyDO insertRevokeApply(RevokeApplyDO revokeApplyDO) {
        return (RevokeApplyDO)this.daoTemplate.insert((Object)revokeApplyDO);
    }

    public int updateRevokeApply(RevokeApplyDO revokeApplyDO) {
        return this.daoTemplate.updateIgnoreNull((Object)revokeApplyDO);
    }

    public int getUnClosedRevokeApplyNum(String signSn) {
        String sql = "SELECT COUNT(*) FROM apply_revoke a,cert_apply b WHERE a.apply_id = b.`id` AND b.`apply_status` IN (1,3) AND a.`sign_sn` =:signSn";
        MapSqlParameterSource params = new MapSqlParameterSource();
        params.addValue("signSn", (Object)signSn);
        int num = this.daoTemplate.queryForInt(sql, (SqlParameterSource)params);
        return num;
    }
}

