/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.dao;

import com.xdja.pki.dao.BaseJdbcDao;
import com.xdja.pki.ra.core.exception.DAOException;
import com.xdja.pki.ra.manager.dao.model.ScepDeviceDO;
import com.xdja.pki.ra.manager.page.PageInfo;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.nutz.dao.Cnd;
import org.nutz.dao.Condition;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.BeanPropertyRowMapper;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;
import org.springframework.jdbc.core.namedparam.SqlParameterSource;
import org.springframework.stereotype.Repository;

@Repository
public class ScepDeviceDAO
extends BaseJdbcDao {
    public ScepDeviceDO insertScepDevice(ScepDeviceDO scepDeviceDO) {
        try {
            return (ScepDeviceDO)this.daoTemplate.insert((Object)scepDeviceDO);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58SCEP\u8bbe\u5907\u6ce8\u518c\u65f6\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int verifyScepName(String scepName) {
        try {
            StringBuilder sql = new StringBuilder("SELECT COUNT(0) FROM scep_device WHERE scep_name =:scepName");
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("scepName", (Object)scepName);
            return this.daoTemplate.queryForInt(sql.toString(), (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("SCEP\u8bbe\u5907\u540d\u79f0\u662f\u5426\u5b58\u5728\u6821\u9a8c\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public PageInfo<ScepDeviceDO> getScepDeviceList(String scepName, String scepChallenge, Integer pageSize, Integer pageNo) {
        StringBuilder countSql = new StringBuilder("SELECT COUNT(0)");
        StringBuilder selectSql = new StringBuilder();
        selectSql.append("SELECT id , scep_name AS scepName, scep_challenge AS scepChallenge, scep_ip AS scepIp, temp_no AS tempNo, scep_contact AS scepContact, gmt_create AS gmtCreate");
        StringBuilder fromSql = new StringBuilder();
        MapSqlParameterSource params = new MapSqlParameterSource();
        fromSql.append(" FROM scep_device ");
        fromSql.append(" WHERE 1 = 1 ");
        if (StringUtils.isNotBlank((CharSequence)scepName)) {
            fromSql.append(" AND scep_name like :scepName");
            params.addValue("scepName", (Object)("%" + scepName + "%"));
        }
        if (StringUtils.isNotBlank((CharSequence)scepChallenge)) {
            fromSql.append(" AND scep_challenge like :scepChallenge");
            params.addValue("scepChallenge", (Object)("%" + scepChallenge + "%"));
        }
        fromSql.append(" ORDER BY gmt_create DESC ");
        countSql.append((CharSequence)fromSql);
        try {
            PageInfo<ScepDeviceDO> page = new PageInfo<ScepDeviceDO>(pageNo, pageSize, this.queryForInt(countSql.toString(), (SqlParameterSource)params));
            fromSql.append(" LIMIT :offset, :pageSize");
            params.addValue("offset", (Object)page.getOffset());
            params.addValue("pageSize", (Object)page.getPageSize());
            selectSql.append((CharSequence)fromSql);
            page.setList(this.queryForList(selectSql.toString(), (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(ScepDeviceDO.class)));
            return page;
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6SCEP\u8bbe\u5907\u5217\u8868\u4fe1\u606f\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ScepDeviceDO getScepDeviceById(Long id) {
        try {
            return (ScepDeviceDO)this.daoTemplate.fetch(ScepDeviceDO.class, (Condition)Cnd.where((String)"id", (String)"=", (Object)id));
        }
        catch (Exception e) {
            throw new DAOException("\u83b7\u53d6SCEP\u8bbe\u5907\u8be6\u60c5\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public int updateScepTempById(Long id, String tempNo, Date data) {
        try {
            String sql = " UPDATE scep_device SET temp_no = :tempNo, gmt_update = :data WHERE id = :id ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("id", (Object)id);
            params.addValue("tempNo", (Object)tempNo);
            params.addValue("data", (Object)data);
            return this.daoTemplate.update(sql, (SqlParameterSource)params);
        }
        catch (Exception e) {
            throw new DAOException("\u4fdd\u5b58/\u66f4\u65b0\u5173\u8054\u6a21\u677f\u7f16\u53f7\u6570\u636e\u5e93\u5f02\u5e38", (Throwable)e);
        }
    }

    public ScepDeviceDO getScepByChallenge(String challenge) {
        try {
            String sql = "SELECT id, scep_name AS scepName, scep_challenge AS scepChallenge, temp_no AS tempNo FROM scep_device WHERE scep_challenge = :challenge";
            MapSqlParameterSource params = new MapSqlParameterSource();
            params.addValue("challenge", (Object)challenge);
            return (ScepDeviceDO)this.daoTemplate.queryForObject(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(ScepDeviceDO.class));
        }
        catch (DataAccessException e) {
            return null;
        }
    }

    public List<ScepDeviceDO> listScepDevices() {
        try {
            String sql = "SELECT id, scep_name AS scepName, scep_challenge AS scepChallenge, temp_no AS tempNo FROM scep_device ";
            MapSqlParameterSource params = new MapSqlParameterSource();
            return this.daoTemplate.queryForList(sql, (SqlParameterSource)params, (RowMapper)BeanPropertyRowMapper.newInstance(ScepDeviceDO.class));
        }
        catch (DataAccessException e) {
            return null;
        }
    }
}

