/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.sdk.business;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.ca.cache.RedisClient;
import com.xdja.ca.sdk.CmpApi;
import com.xdja.ca.sdk.SdkResult;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.ErrorBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.PathConstants;
import com.xdja.pki.ra.core.pkcs7.SignedDataUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.cert.VerifyCert;
import com.xdja.pki.ra.core.util.file.FileUtils;
import com.xdja.pki.ra.manager.sdk.business.CaBusinessManager;
import com.xdja.pki.ra.manager.sdk.business.SynTempInfo;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

@Service
public class CaBusinessManagerImpl
implements CaBusinessManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${ca.open.api.https}")
    private boolean isHttps;
    private CmpApi cmpApi;
    @Autowired
    private Pool<Jedis> jedisPool;
    private RedisClient redisClient;
    private int transIdExpireTime;

    @Value(value="${transId.cache.expireTime}")
    private void init(int transIdExpireTime) {
        this.transIdExpireTime = transIdExpireTime;
        this.redisClient = new RedisClient(this.jedisPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initCmpApi() {
        CaBusinessManagerImpl caBusinessManagerImpl = this;
        synchronized (caBusinessManagerImpl) {
            if (this.cmpApi == null) {
                this.cmpApi = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? new CmpApi(CommonVariable.getKeyIndex(), CommonVariable.getKeyPwd(), CommonVariable.getSuperCaCerts(), CommonVariable.getCaServiceCert(), CommonVariable.getCaServiceIp(), CommonVariable.getCaServicePort(), CommonVariable.getRaSingSn(), CommonVariable.getSigAlgName(), this.isHttps, true, this.redisClient, this.transIdExpireTime) : new CmpApi(CommonVariable.getRaSignPriKey(), CommonVariable.getSuperCaCerts(), CommonVariable.getCaServiceCert(), CommonVariable.getCaServiceIp(), CommonVariable.getCaServicePort(), CommonVariable.getRaSingSn(), CommonVariable.getSigAlgName(), this.isHttps, false, this.redisClient, this.transIdExpireTime);
            }
        }
    }

    public Result getUserCACertFileTime(Long caId) {
        this.initCmpApi();
        SdkResult userCAResult = this.cmpApi.getUserCACertFileTime(caId);
        Result result = CaBusinessManagerImpl.getResult(userCAResult);
        if (null == result.getErrorBean()) {
            result.setInfo(userCAResult.getInfo());
        }
        return result;
    }

    public Result getUserCA() {
        this.initCmpApi();
        SdkResult userCAResult = this.cmpApi.getUserCA();
        Result result = CaBusinessManagerImpl.getResult(userCAResult);
        if (null == result.getErrorBean()) {
            result.setInfo(userCAResult.getInfo());
        }
        return result;
    }

    public Result testCaServerConnect(MultipartFile file, String caServerIp, int caServerPort) {
        String sigAlgName;
        Result result = new Result();
        int length = 0;
        X509Certificate[] superCaCerts = null;
        try {
            superCaCerts = CommonVariable.getSuperCaCerts();
            if (superCaCerts == null) {
                length = 0;
                superCaCerts = new X509Certificate[length];
            } else {
                length = superCaCerts.length;
            }
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6CA\u5386\u53f2\u8bc1\u4e66\u5f02\u5e38");
            result.setError(ErrorEnum.GET_HISTORY_CA_CERT_ERROR);
        }
        X509Certificate[] caCerts = null;
        X509Certificate caCert = null;
        byte[] p7bContent = new byte[]{};
        if (file != null) {
            int i;
            try {
                p7bContent = file.getBytes();
            }
            catch (Exception e) {
                this.logger.info("\u6587\u4ef6\u8f6c\u6362bytes\u5f02\u5e38");
                result.setError(ErrorEnum.FILE_TO_BYTES_ERROR);
                return result;
            }
            Result verifyResult = VerifyCert.verifyP7bCertList((byte[])p7bContent);
            if (!verifyResult.isSuccess()) {
                result.setError(verifyResult.getError());
                return result;
            }
            List certs = null;
            try {
                certs = SignedDataUtils.resolveCertChain((byte[])p7bContent);
            }
            catch (Exception e) {
                this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.CONVERT_CERT_ERROR);
                return result;
            }
            caCerts = new X509Certificate[length += certs.size()];
            for (i = 0; i < superCaCerts.length; ++i) {
                caCerts[i] = superCaCerts[i];
            }
            caCert = (X509Certificate)certs.get(0);
            sigAlgName = caCert.getSigAlgName();
            for (i = 0; i < certs.size(); ++i) {
                caCerts[length - i - 1] = caCert = (X509Certificate)certs.get(i);
            }
        } else {
            caCerts = new X509Certificate[length];
            for (int i = 0; i < superCaCerts.length; ++i) {
                caCerts[i] = superCaCerts[i];
            }
            try {
                p7bContent = FileUtils.readByBinary((String)PathConstants.CA_TRUST_SERVICE_CERT_FILE_PATH);
            }
            catch (Exception e) {
                this.logger.info("\u8bfb\u53d6\u670d\u52a1\u5668\u5df2\u5b58\u8bc1\u4e66\u94fe\u5f02\u5e38");
                result.setError(ErrorEnum.CERT_P7B_INFO_READ_ERROR);
                return result;
            }
            List certs = null;
            try {
                certs = SignedDataUtils.resolveCertChain((byte[])p7bContent);
            }
            catch (Exception e) {
                this.logger.error("\u914d\u7f6eCA\u670d\u52a1\u89e3\u6790\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.CONVERT_CERT_ERROR);
                return result;
            }
            caCert = (X509Certificate)certs.get(0);
            sigAlgName = caCert.getSigAlgName();
        }
        try {
            String keyAlg = CertUtils.getKeyAlg((X509Certificate)caCert);
            if (2 == CommonVariable.getIsHsm() && "NISTP256".equalsIgnoreCase(keyAlg)) {
                this.logger.error("\u4e09\u672a\u4fe1\u5b89\u5bc6\u7801\u673a\u4e0d\u652f\u6301NIST256\u7b97\u6cd5");
                result.setError(ErrorEnum.SWXA_HSM_NOT_SUPPORT_NIST);
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u8bc1\u4e66\u79d8\u94a5\u7b97\u6cd5\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.GET_CERT_ALG_NAME_LENGTH_EXCEPTION);
            return result;
        }
        String p7bHashCode = null;
        try {
            p7bHashCode = 0 != CommonVariable.getIsHsm() ? HsmUtils.digestByYunHsm((String)sigAlgName, (String)Base64.toBase64String((byte[])p7bContent)) : HsmUtils.digestByBC((String)sigAlgName, (String)Base64.toBase64String((byte[])p7bContent));
            this.logger.info("p7bHashCode==========={}", (Object)p7bHashCode);
        }
        catch (Exception e) {
            this.logger.error("\u6d4b\u8bd5CA\u670d\u52a1\u8fde\u901a\u6027\u8bfb\u53d6\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CERT_P7B_INFO_READ_ERROR);
            return result;
        }
        CmpApi initCmpApi = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? new CmpApi(0, null, caCerts, null, caServerIp, caServerPort, null, sigAlgName, this.isHttps, true, this.redisClient, this.transIdExpireTime) : new CmpApi(null, caCerts, null, caServerIp, caServerPort, null, sigAlgName, this.isHttps, false, this.redisClient, this.transIdExpireTime);
        SdkResult caServerResult = initCmpApi.sendCaServerMessages(caServerIp, caServerPort, p7bHashCode, caCerts);
        result = CaBusinessManagerImpl.getResult(caServerResult);
        return result;
    }

    private static Result getResult(SdkResult sdkResult) {
        Result result = new Result();
        if (!sdkResult.isSuccess()) {
            String code = String.valueOf(sdkResult.getErrorBean().getErrCode()).substring(0, 3);
            if ("300".equals(code) || "310".equals(code)) {
                result.setError(ErrorEnum.CA_SDK_INNER_EXCEPTION);
            } else {
                ErrorBean errorBean = new ErrorBean(sdkResult.getErrorBean().getErrCode(), sdkResult.getErrorBean().getErrMsg());
                result.setErrorBean(errorBean);
            }
        }
        return result;
    }

    public Result getRaBaseDN() {
        this.initCmpApi();
        SdkResult raBaseDNResult = this.cmpApi.getRaBaseDN();
        Result result = CaBusinessManagerImpl.getResult(raBaseDNResult);
        if (null == result.getErrorBean()) {
            String raBaseDN = String.valueOf(raBaseDNResult.getInfo());
            JSONObject jsonObject = JSONObject.parseObject((String)raBaseDN);
            String baseDn = (String)jsonObject.get((Object)"baseDn");
            result.setInfo((Object)baseDn);
        }
        return result;
    }

    public Result getCertStatus(String signSn) {
        this.initCmpApi();
        SdkResult certStatusResult = this.cmpApi.getCertStatus(signSn);
        Result result = CaBusinessManagerImpl.getResult(certStatusResult);
        if (null == result.getErrorBean()) {
            String certStatus = (String)certStatusResult.getInfo();
            JSONObject jsonObject = JSONObject.parseObject((String)certStatus);
            int status = (Integer)jsonObject.get((Object)"status");
            result.setInfo((Object)status);
        }
        return result;
    }

    public Result downloadCertDataInfo(String signSn, boolean isBase64) {
        this.initCmpApi();
        SdkResult certByteResult = this.cmpApi.downloadCertByteInfo(signSn);
        Result result = CaBusinessManagerImpl.getResult(certByteResult);
        if (null == result.getErrorBean()) {
            String certByte = (String)certByteResult.getInfo();
            HashMap<String, String> map1 = new HashMap<String, String>();
            HashMap<String, String> map2 = new HashMap<String, String>();
            JSONObject jsonObject = JSONObject.parseObject((String)certByte);
            String signCertStr = (String)jsonObject.get((Object)"signCert");
            String signCertStrP7b = (String)jsonObject.get((Object)"signCertP7b");
            if (StringUtils.isBlank((CharSequence)signCertStr)) {
                this.logger.info("sdk\u63a5\u53e3-\u83b7\u53d6\u7684\u7b7e\u540d\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a{}", (Object)certByte);
                result.setError(ErrorEnum.GET_USER_CERT_INFO_IS_EMPTY);
                return result;
            }
            map1.put("signCert", signCertStrP7b);
            map2.put("signCert", signCertStr);
            String encCertStr = (String)jsonObject.get((Object)"encCert");
            String encCertStrP7b = (String)jsonObject.get((Object)"encCertP7b");
            if (StringUtils.isNotBlank((CharSequence)encCertStr)) {
                map1.put("encCert", encCertStrP7b);
                map2.put("encCert", encCertStr);
            }
            String userCACert = (String)jsonObject.get((Object)"userCACert");
            map1.put("CACert", userCACert);
            map2.put("CACert", userCACert);
            if (isBase64) {
                result.setInfo(map2);
            } else {
                result.setInfo(map1);
            }
        }
        return result;
    }

    public Result getCertDetailInfoBySingSn(String signSn) {
        this.initCmpApi();
        SdkResult certDetailResult = this.cmpApi.getCertDetailInfo(signSn);
        Result result = CaBusinessManagerImpl.getResult(certDetailResult);
        if (null == result.getErrorBean()) {
            String certDetail = (String)certDetailResult.getInfo();
            result.setInfo((Object)certDetail);
        }
        return result;
    }

    public Result synCertTemplateList() {
        this.initCmpApi();
        SdkResult certTempListResult = this.cmpApi.getCertTemplateList();
        Result result = CaBusinessManagerImpl.getResult(certTempListResult);
        if (null == result.getErrorBean()) {
            List synTempInfoList;
            String certTempList = (String)certTempListResult.getInfo();
            try {
                synTempInfoList = JSON.parseArray((String)certTempList, SynTempInfo.class);
            }
            catch (Exception e) {
                this.logger.info("\u89e3\u6790json\u9519\u8bef", (Throwable)e);
                result.setError(ErrorEnum.SYN_CERT_TEMP_INFO_FORMAT_ERROR);
                return result;
            }
            result.setInfo((Object)synTempInfoList);
        }
        return result;
    }

    public Result getCertTemplateDetailInfoByTempNo(String tempNo) {
        this.initCmpApi();
        SdkResult certTempDetailResult = this.cmpApi.getCertTemplateDetailInfo(tempNo);
        Result result = CaBusinessManagerImpl.getResult(certTempDetailResult);
        if (null == result.getErrorBean()) {
            String certTempDetail = (String)certTempDetailResult.getInfo();
            result.setInfo((Object)certTempDetail);
        }
        return result;
    }

    public Result getRaOperatorCertTemp() {
        this.initCmpApi();
        SdkResult raOperatorCertTemp = this.cmpApi.getRaOperatorCertTemp();
        Result result = CaBusinessManagerImpl.getResult(raOperatorCertTemp);
        if (null == result.getErrorBean()) {
            String raOperatorCertTempInfo = (String)raOperatorCertTemp.getInfo();
            JSONObject jsonObject = JSONObject.parseObject((String)raOperatorCertTempInfo);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("tempCode", jsonObject.get((Object)"code"));
            map.put("signAlg", jsonObject.get((Object)"signAlgStr"));
            map.put("privateKeyLength", jsonObject.get((Object)"keySize"));
            map.put("maxDate", jsonObject.get((Object)"maxValidity"));
            String keyAlgName = null;
            Integer keyAlg = (Integer)jsonObject.get((Object)"keyAlg");
            keyAlgName = 1 == keyAlg ? "RSA" : (2 == keyAlg ? "SM2" : "NISTP256");
            map.put("keyAlg", keyAlgName);
            result.setInfo(map);
        }
        return result;
    }

    public Result raAdminLoginAuthen(String signSn) {
        this.initCmpApi();
        SdkResult raOperatorCertTemp = this.cmpApi.raAdminLoginAuthen(signSn);
        Result result = CaBusinessManagerImpl.getResult(raOperatorCertTemp);
        if (null == result.getErrorBean()) {
            String raOperatorCertTempInfo = (String)raOperatorCertTemp.getInfo();
            if (StringUtils.isBlank((CharSequence)raOperatorCertTempInfo)) {
                result.setError(ErrorEnum.CA_RETURN_ADMIN_AUTHEN_INFO_IS_EMPTY);
                return result;
            }
            JSONObject jsonObject = JSONObject.parseObject((String)raOperatorCertTempInfo);
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("adminType", jsonObject.get((Object)"adminType"));
            map.put("signCertStatus", jsonObject.get((Object)"signCertStatus"));
            map.put("signCertData", jsonObject.get((Object)"signCertData"));
            map.put("encCertData", jsonObject.get((Object)"encCertData"));
            result.setInfo(map);
        }
        return result;
    }
}

