/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.manager.sdk.cmp;

import com.xdja.ca.constant.SdkConstants;
import com.xdja.ca.sdk.CmpApi;
import com.xdja.ca.sdk.SdkResult;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.ca.utils.SdkRandomUtils;
import com.xdja.ca.vo.ManagerCertInfo;
import com.xdja.ca.vo.TempInfo;
import com.xdja.ca.vo.UpdateCertInfo;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.ErrorBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.manager.sdk.cmp.CertLifeCycleManager;
import com.xdja.pki.ra.manager.sdk.cmp.bean.CertLifeInfo;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CertLifeCycleLifeCycleManagerImpl
implements CertLifeCycleManager {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Value(value="${ca.open.api.https}")
    private boolean isHttps;
    private volatile CmpApi cmpApi;

    public Result issueUserCert(String applyNo, String cardNo, byte[] publicKeyByte, String raDN, String caDN, String transId, String tempNo, String tempParas, String signAlg, int certValidity, String userCertDN, Integer keyFormat) {
        TempInfo tempInfo = new TempInfo(tempNo, tempParas);
        this.logger.debug("\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66===========applyNo:" + applyNo);
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendIssuerCertReqMessages(Constants.APPLY_USER_TYPE_NORMAL_USER_1, transId, raDN, caDN, certValidity, tempInfo, Base64.toBase64String((byte[])publicKeyByte), null, signAlg, userCertDN, keyFormat);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        if (result.getErrorBean() != null) {
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)sdkResult.getInfo();
        if (userCertInfo == null) {
            this.logger.debug("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)userCertInfo);
        this.logger.debug("\u7b7e\u53d1\u7528\u6237\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result updateUserCert(String applyNo, String cardNo, byte[] publicKeyByte, String raDN, String caDN, String transId, String tempNo, String tempParas, String signAlg, int certValidity, String userCertDN, String signSn, boolean isUpdateKey, Integer keyFormat) {
        UpdateCertInfo updateCertInfo = new UpdateCertInfo();
        if (isUpdateKey) {
            updateCertInfo.setSignPublicKey(Base64.toBase64String((byte[])publicKeyByte));
        }
        updateCertInfo.setSignAlg(signAlg);
        TempInfo tempInfo = new TempInfo(tempNo, tempParas);
        this.logger.info("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66===========applyNo:" + applyNo);
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendUpdateCertReqMessages(Constants.APPLY_USER_TYPE_NORMAL_USER_1, transId, raDN, caDN, certValidity, tempInfo, updateCertInfo, signSn, userCertDN, keyFormat);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        if (result.getErrorBean() != null) {
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)sdkResult.getInfo();
        if (userCertInfo == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)userCertInfo);
        this.logger.info("\u66f4\u65b0\u7528\u6237\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result revokeUserCert(String applyNo, String raDN, String caDN, String signSn, String userCertDn, int revokeType, String revokeReason) {
        this.logger.info("\u64a4\u9500\u7528\u6237\u8bc1\u4e66===========start\uff01");
        String transId = SdkRandomUtils.getUUID();
        this.logger.info("\u64a4\u9500\u7528\u6237\u8bc1\u4e66===========applyNo:" + applyNo);
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendRevokeCertReqMessages(Constants.APPLY_USER_TYPE_NORMAL_USER_1, transId, raDN, caDN, signSn, userCertDn, revokeType, revokeReason);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        this.logger.info("\u64a4\u9500\u7528\u6237\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result freezeUserCert(CertLifeInfo certLifeInfo, int applyType, String freezeReason) {
        this.logger.info("\u51bb\u7ed3/\u89e3\u51bb\u7528\u6237\u8bc1\u4e66===========start\uff01");
        String transId = SdkRandomUtils.getUUID();
        this.logger.info("\u51bb\u7ed3/\u89e3\u51bb\u7528\u6237\u8bc1\u4e66===========applyNo:{}", (Object)certLifeInfo.getApplyNo());
        CmpApi cmpApi = this.getCmpApi();
        int revokeType = SdkConstants.CERT_APPLY_TYPE_FREEZE_5 == applyType ? SdkConstants.REV_REASON_CERTIFICATE_HOLD_6 : SdkConstants.REV_REASON_REMOVE_FROM_CRL_8;
        SdkResult sdkResult = cmpApi.sendRevokeCertReqMessages(Constants.APPLY_USER_TYPE_NORMAL_USER_1, transId, certLifeInfo.getRaDN(), certLifeInfo.getCaDN(), certLifeInfo.getSignSn(), certLifeInfo.getUserCertDN(), revokeType, freezeReason);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        this.logger.info("\u51bb\u7ed3/\u89e3\u51bb\u7528\u6237\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result recoveryUserCert(String applyNo, String raDN, String caDN, byte[] publicKeyByte, String signSn, String transId, String signAlg, String userCertDn, Integer keyFormat) {
        this.logger.info("\u6062\u590d\u7528\u6237\u8bc1\u4e66===========start\uff01");
        this.logger.info("\u6062\u590d\u7528\u6237\u8bc1\u4e66===========applyNo:" + applyNo);
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendRecoveryCertReqMessages(transId, raDN, caDN, Base64.toBase64String((byte[])publicKeyByte), signAlg, userCertDn, signSn, keyFormat);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        if (result.getErrorBean() != null) {
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)sdkResult.getInfo();
        if (userCertInfo == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7528\u6237\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)userCertInfo);
        this.logger.info("\u6062\u590d\u7528\u6237\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result issueCertResp(String raDN, String caDN, int applyUserType, String transId) {
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendCertConfirmContent(applyUserType, transId, raDN, caDN, CommonVariable.getCaServiceCert());
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        return result;
    }

    public Result sendErrorCMPMessage(String raDN, String caDN, int applyUserType, String transId, int errorCode, String errorMsg) {
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendErrorMsgContent(applyUserType, transId, raDN, caDN, errorCode, errorMsg);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        return result;
    }

    public Result issueManageCert(String cardNo, String base64P10, String encPubKey, String raDN, String caDN, String transId, String tempNo, String signAlg, int certValidity, String certDN) {
        byte[] publicKey;
        this.logger.info("\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66===========start\uff01");
        Result result = new Result();
        try {
            publicKey = SdkP10Utils.p10ToPublicKey((String)base64P10).getEncoded();
        }
        catch (Exception e) {
            this.logger.info("sdk\u63a5\u53e3-\u4eceP10\u4e2d\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Throwable)e);
            result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
            return result;
        }
        TempInfo tempInfo = new TempInfo(tempNo);
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendIssuerCertReqMessages(Constants.APPLY_USER_TYPE_ADMIN_2, transId, raDN, caDN, certValidity, tempInfo, Base64.toBase64String((byte[])publicKey), encPubKey, signAlg, certDN, null);
        result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        if (result.getErrorBean() != null) {
            return result;
        }
        ManagerCertInfo managerCertInfo = (ManagerCertInfo)sdkResult.getInfo();
        if (managerCertInfo == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)managerCertInfo);
        this.logger.info("\u7b7e\u53d1\u7ba1\u7406\u5458\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result updateManageCert(String cardNo, String base64P10, String encPubKey, String raDN, String caDN, String transId, String tempNo, String signAlg, int certValidity, String certDN, String signSn, boolean isUpdateKey) {
        this.logger.info("\u66f4\u65b0\u7ba1\u7406\u5458\u8bc1\u4e66===========start\uff01");
        Result result = new Result();
        UpdateCertInfo updateCertInfo = new UpdateCertInfo();
        if (isUpdateKey) {
            byte[] publicKey;
            try {
                publicKey = SdkP10Utils.p10ToPublicKey((String)base64P10).getEncoded();
            }
            catch (Exception e) {
                this.logger.info("sdk\u63a5\u53e3-\u4eceP10\u4e2d\u83b7\u53d6\u516c\u94a5\u4fe1\u606f\u5f02\u5e38\uff1a{}", (Throwable)e);
                result.setError(ErrorEnum.GET_PUBLIC_KEY_FROM_P10_EXCEPTION);
                return result;
            }
            updateCertInfo.setSignPublicKey(Base64.toBase64String((byte[])publicKey));
            updateCertInfo.setEncPublicKey(encPubKey);
            updateCertInfo.setUpdateKey(true);
            String signValue = SdkP10Utils.p10ToSignValue((String)base64P10);
            updateCertInfo.setSignValue(signValue);
        }
        updateCertInfo.setSignAlg(signAlg);
        TempInfo tempInfo = new TempInfo(tempNo);
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendUpdateCertReqMessages(Constants.APPLY_USER_TYPE_ADMIN_2, transId, raDN, caDN, certValidity, tempInfo, updateCertInfo, signSn, certDN, null);
        result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        if (result.getErrorBean() != null) {
            return result;
        }
        ManagerCertInfo managerCertInfo = (ManagerCertInfo)sdkResult.getInfo();
        if (managerCertInfo == null) {
            this.logger.info("CA\u8fd4\u56de\u7684\u7ba1\u7406\u5458\u8bc1\u4e66\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.CA_RESPONSE_USER_CERT_INFO_IS_EMPTY);
            return result;
        }
        result.setInfo((Object)managerCertInfo);
        this.logger.info("\u66f4\u65b0\u7ba1\u7406\u5458\u8bc1\u4e66===========end\uff01");
        return result;
    }

    public Result revokeManageCert(String raDN, String caDN, String signSn, String userCertDn, int revokeType, String revokeReason) {
        this.logger.info("\u64a4\u9500\u7ba1\u7406\u5458\u8bc1\u4e66===========start\uff01");
        String transId = SdkRandomUtils.getUUID();
        CmpApi cmpApi = this.getCmpApi();
        SdkResult sdkResult = cmpApi.sendRevokeCertReqMessages(Constants.APPLY_USER_TYPE_ADMIN_2, transId, raDN, caDN, signSn, userCertDn, revokeType, revokeReason);
        Result result = CertLifeCycleLifeCycleManagerImpl.getResult(sdkResult);
        this.logger.info("\u64a4\u9500\u7ba1\u7406\u5458\u8bc1\u4e66===========end\uff01");
        return result;
    }

    private CmpApi getCmpApi() {
        if (this.cmpApi == null) {
            this.cmpApi = Constants.HSM_SERVER_XDJA_1 == CommonVariable.getIsHsm() && Constants.KEY_ALG_NAME_SM2.equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? new CmpApi(CommonVariable.getKeyIndex(), CommonVariable.getKeyPwd(), CommonVariable.getSuperCaCerts(), CommonVariable.getCaServiceCert(), CommonVariable.getCaServiceIp(), CommonVariable.getCaServicePort(), CommonVariable.getRaSingSn(), CommonVariable.getSigAlgName(), this.isHttps, true) : new CmpApi(CommonVariable.getRaSignPriKey(), CommonVariable.getSuperCaCerts(), CommonVariable.getCaServiceCert(), CommonVariable.getCaServiceIp(), CommonVariable.getCaServicePort(), CommonVariable.getRaSingSn(), CommonVariable.getSigAlgName(), this.isHttps, false);
        }
        return this.cmpApi;
    }

    private static Result getResult(SdkResult sdkResult) {
        Result result = new Result();
        if (!sdkResult.isSuccess()) {
            String code = String.valueOf(sdkResult.getErrorBean().getErrCode()).substring(0, 3);
            if ("300".equals(code) || "310".equals(code)) {
                result.setError(ErrorEnum.CA_SDK_INNER_EXCEPTION);
            } else {
                ErrorBean errorBean = new ErrorBean(sdkResult.getErrorBean().getErrCode(), sdkResult.getErrorBean().getErrMsg());
                result.setErrorBean(errorBean);
            }
        }
        return result;
    }
}

