package com.xdja.pki.ra.openapi.controller;

import com.xdja.pki.ra.service.manager.ak.AkService;
import com.xdja.pki.ra.service.manager.ak.xml.request.*;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;

/**
 * @Author:ggp
 * @Date:2020-08-19 09:45
 * @Description:
 */
@RestController
@RequestMapping("/v1/ra-openapi/ak/")
public class CertManagerController {

    @Autowired
    private AkService akService;
    @PostMapping("userRegister")
    public Object userRegister(@RequestBody UserRegisterReq request, HttpServletResponse resp) {
        buildResp(resp);
        return akService.userRegister(request).getInfo();
    }

    @PostMapping("certRequest")
    public Object certRequest(@RequestBody CertApplyReq request,HttpServletResponse resp) {
        buildResp(resp);
        return  akService.certApply(request).getInfo();
    }

    @PostMapping("certDown")
    public Object certDown(@RequestBody CertDownReq request,HttpServletResponse resp) {
        buildResp(resp);
        return akService.certDown(request).getInfo();
    }

    /**
     * 证书请求和证书返回的结构体一样，故共用一个响应结构体
     *
     * @param request
     * @return
     */
    @PostMapping("certUpdate")
    public Object certUpdate(@RequestBody CertUpdateReq request,HttpServletResponse resp) {
        buildResp(resp);
        return akService.certUpdate(request).getInfo();
    }

    @PostMapping("certRevoke")
    public Object certRevoke(@RequestBody CertRevokeReq request,HttpServletResponse resp) {
        buildResp(resp);
        return akService.certRevoke(request);
    }

    @PostMapping("keyRestore")
    public Object keyRestore(@RequestBody KeyRestoreReq request,HttpServletResponse resp) {
        buildResp(resp);
        return akService.keyRestore(request).getInfo();
    }

    private void buildResp(HttpServletResponse resp) {
        resp.setStatus(200);
        resp.setContentType("text/xml,application/xml; charset=utf-8");
    }


}
