/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.openapi.aop.SignIntercep;
import com.xdja.pki.ra.openapi.bean.SystemFlagBean;
import com.xdja.pki.ra.openapi.normal.Utils.CheckParam;
import com.xdja.pki.ra.service.manager.certapply.CertApplyManagerService;
import com.xdja.pki.ra.service.manager.certapply.bean.CheckApply;
import com.xdja.pki.ra.service.manager.certapply.bean.EditCertApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.ErrorMsg;
import com.xdja.pki.ra.service.manager.certapply.bean.FreezeApply;
import com.xdja.pki.ra.service.manager.certapply.bean.IssueApply;
import com.xdja.pki.ra.service.manager.certapply.bean.RecoveryApply;
import com.xdja.pki.ra.service.manager.certapply.bean.RevokeApply;
import com.xdja.pki.ra.service.manager.certapply.bean.UpdateApply;
import com.xdja.pki.ra.service.manager.certapply.bean.UserCertReq;
import javax.servlet.http.HttpServletResponse;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CertApplyManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CertApplyManagerService certApplyManagerService;

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/baseDn"}, method={RequestMethod.GET})
    public Object getRaBaseDn(HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u83b7\u53d6RA\u7cfb\u7edfBaseDn");
        Result result = this.certApplyManagerService.getRABaseDn();
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/template/{systemName}"}, method={RequestMethod.GET})
    public Object getOtherSystemTemplates(@PathVariable String systemName, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u83b7\u53d6\u7b2c\u4e09\u65b9\u6a21\u677f\u5217\u8868");
        Result result = CheckParam.checkAuthority((String)systemName, (String)systemFlagBean.getSystemFlag());
        if (!result.isSuccess()) {
            return CheckParam.resultDeal((Result)Result.success(null), (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.getTemplateInfoList(systemName);
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/issue"}, method={RequestMethod.POST})
    public Object issueApplyLaunch(@RequestBody IssueApply issueApply, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7b7e\u53d1\u7533\u8bf7-\u53d1\u8d77");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570issueApply:[{}]", (Object)issueApply);
        Result result = CheckParam.checkParam((IssueApply)issueApply);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.issueApplyLaunch(issueApply, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/update"}, method={RequestMethod.POST})
    public Object updateApplyLaunch(@RequestBody UpdateApply updateApply, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u66f4\u65b0\u7533\u8bf7-\u53d1\u8d77");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570updateApply:[{}]", (Object)updateApply);
        Result result = CheckParam.checkParam((UpdateApply)updateApply);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.updateApplyLaunch(updateApply, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/revoke"}, method={RequestMethod.POST})
    public Object revokeApplyLaunch(@RequestBody RevokeApply revokeApply, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u64a4\u9500\u7533\u8bf7-\u53d1\u8d77");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570revokeApply:[{}]", (Object)revokeApply);
        Result result = CheckParam.checkParam((RevokeApply)revokeApply);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.revokeApplyLaunch(revokeApply, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/recovery"}, method={RequestMethod.POST})
    public Object recoveryApplyLaunch(@RequestBody RecoveryApply revokeApply, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u6062\u590d\u7533\u8bf7-\u53d1\u8d77revokeApply:[{}]", (Object)revokeApply);
        Result result = CheckParam.checkParam((RecoveryApply)revokeApply);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.recoveryApplyLaunch(revokeApply, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @PostMapping(value={"/v1/ra-openapi/apply/freeze"})
    public Object freezeApplyLaunch(@RequestBody FreezeApply freezeApply, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u51bb\u7ed3/\u89e3\u51bb\u7533\u8bf7-\u53d1\u8d77 freezeApply:[{}]", (Object)freezeApply);
        Result result = CheckParam.checkParam((FreezeApply)freezeApply);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.freezeApplyLaunch(freezeApply, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/check/{applyType}/{applyNo}"}, method={RequestMethod.PUT})
    public Object applyCheck(@PathVariable Integer applyType, @PathVariable String applyNo, @RequestBody CheckApply checkApply, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7533\u8bf7\u5ba1\u6838");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyType:[{}]", (Object)applyType);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570checkApply:[{}]", (Object)checkApply);
        Result result = CheckParam.checkParam((Integer)applyType, (Object)checkApply);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.applyCheck(applyType, applyNo, checkApply, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @RequestMapping(value={"/v1/ra-openapi/apply/{applyType}/{applyNo}"}, method={RequestMethod.POST})
    public Object applyCertCarry(@PathVariable Integer applyType, @PathVariable String applyNo, @RequestBody UserCertReq userCertReq, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7533\u8bf7\u5236\u8bc1\u6267\u884c");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyType:[{}]", (Object)applyType);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570userCertReq:[{}]", (Object)userCertReq);
        return null;
    }

    @RequestMapping(value={"/v1/ra-openapi/apply/confirm/{applyNo}"}, method={RequestMethod.POST})
    public Object certIssueConfirmMsg(@PathVariable String applyNo, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u8bc1\u4e66\u7b7e\u53d1\u786e\u8ba4\u6d88\u606f");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        Result result = this.certApplyManagerService.certIssueConfirmMsg(applyNo);
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @RequestMapping(value={"/v1/ra-openapi/apply/error/{applyNo}"}, method={RequestMethod.POST})
    public Object certIssueErrorMsg(@PathVariable String applyNo, @Valid @RequestBody ErrorMsg errorMsg, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u8bc1\u4e66\u7b7e\u53d1\u786e\u8ba4\u6d88\u606f");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        Result result = this.certApplyManagerService.certApplyErrorMsg(applyNo, errorMsg);
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/{applyType}/{applyNo}"}, method={RequestMethod.GET})
    public Object getCertApplyInfo(@PathVariable Integer applyType, @PathVariable String applyNo, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u67e5\u8be2\u8bc1\u4e66\u7533\u8bf7\u4fe1\u606f");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyType:[{}]", (Object)applyType);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        Result result = CheckParam.checkApplyType((Integer)applyType);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.certApplyQuery(applyType, applyNo, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/{applyNo}"}, method={RequestMethod.GET})
    public Object certApplyQuery(@PathVariable String applyNo, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u67e5\u8be2\u8bc1\u4e66\u7533\u8bf7\u4fe1\u606f");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        Result result = this.certApplyManagerService.certApplyQuery(applyNo, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/apply/{applyType}/{applyNo}"}, method={RequestMethod.PUT})
    public Object updateCertApplyInfo(@PathVariable Integer applyType, @PathVariable String applyNo, @RequestBody EditCertApplyInfo editCertApplyInfo, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u4fee\u6539\u8bc1\u4e66\u7533\u8bf7\u4fe1\u606f");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyType:[{}]", (Object)applyType);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570applyNo:[{}]", (Object)applyNo);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570editCertApplyInfo:[{}]", (Object)editCertApplyInfo);
        Result result = CheckParam.checkParam((Integer)applyType, (EditCertApplyInfo)editCertApplyInfo);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.certApplyManagerService.certApplyUpdate(applyType, applyNo, editCertApplyInfo, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }
}

