/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal.Utils;

import com.xdja.pki.ra.core.common.ErrorBean;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ApplyTypeEnum;
import com.xdja.pki.ra.core.commonenum.DeviceTypeEnum;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.KeyLengthEnum;
import com.xdja.pki.ra.core.commonenum.OrganTypeEnum;
import com.xdja.pki.ra.core.commonenum.PersonUserTypeEnum;
import com.xdja.pki.ra.core.commonenum.RevokeReasonEnum;
import com.xdja.pki.ra.core.commonenum.SignAlgEnum;
import com.xdja.pki.ra.core.commonenum.UserStatusEnum;
import com.xdja.pki.ra.core.commonenum.UserTypeEnum;
import com.xdja.pki.ra.core.util.params.CheckUtils;
import com.xdja.pki.ra.core.util.params.PatternCheckUtils;
import com.xdja.pki.ra.service.manager.baseuser.bean.DeviceUser;
import com.xdja.pki.ra.service.manager.baseuser.bean.OrganUser;
import com.xdja.pki.ra.service.manager.baseuser.bean.PersonUser;
import com.xdja.pki.ra.service.manager.baseuser.bean.UserInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.EditCertApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.EditIssueApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.EditRevokeApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.EditUpdateApplyInfo;
import com.xdja.pki.ra.service.manager.certapply.bean.ErrorMsg;
import com.xdja.pki.ra.service.manager.certapply.bean.FreezeApply;
import com.xdja.pki.ra.service.manager.certapply.bean.IssueApply;
import com.xdja.pki.ra.service.manager.certapply.bean.RecoveryApply;
import com.xdja.pki.ra.service.manager.certapply.bean.RevokeApply;
import com.xdja.pki.ra.service.manager.certapply.bean.UpdateApply;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class CheckParam {
    private static final Logger logger = LoggerFactory.getLogger(CheckParam.class);

    public static Result requestParamCheck(Integer userType, UserInfo userInfo, boolean isUpdate) {
        Result result = new Result();
        if (userType == UserTypeEnum.PERSON_USER.id) {
            PersonUser personUser = userInfo.getPersonUser();
            if (null == personUser) {
                logger.error("\u7528\u6237\u7c7b\u578b\u548c\u4f20\u5165\u53c2\u6570\u4e0d\u5339\u914d");
                return Result.failure((ErrorEnum)ErrorEnum.USER_TYPE_IS_NOT_MATCH_ARGS);
            }
            if (!isUpdate && !CheckUtils.checkParamsNotNull((Object)personUser)) {
                logger.error("\u4e2a\u4eba\u7528\u6237\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
            result = CheckParam.checkPerson((PersonUser)personUser);
            if (!result.isSuccess()) {
                return result;
            }
        } else if (userType == UserTypeEnum.ORGAN_USER.id) {
            OrganUser organUser = userInfo.getOrganUser();
            if (null == organUser) {
                logger.error("\u7528\u6237\u7c7b\u578b\u548c\u4f20\u5165\u53c2\u6570\u4e0d\u5339\u914d");
                return Result.failure((ErrorEnum)ErrorEnum.USER_TYPE_IS_NOT_MATCH_ARGS);
            }
            if (!isUpdate && !CheckUtils.checkParamsNotNull((Object)organUser)) {
                logger.error("\u673a\u6784\u7528\u6237\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
            result = CheckParam.checkOrganUser((OrganUser)organUser);
            if (!result.isSuccess()) {
                return result;
            }
        } else if (userType == UserTypeEnum.DEVICE_USER.id) {
            DeviceUser deviceUser = userInfo.getDeviceUser();
            if (null == deviceUser) {
                logger.error("\u7528\u6237\u7c7b\u578b\u548c\u4f20\u5165\u53c2\u6570\u4e0d\u5339\u914d");
                return Result.failure((ErrorEnum)ErrorEnum.USER_TYPE_IS_NOT_MATCH_ARGS);
            }
            if (!isUpdate && !CheckUtils.checkParamsNotNull((Object)deviceUser)) {
                logger.error("\u8bbe\u5907\u7528\u6237\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
            result = CheckParam.checkDeviceUser((DeviceUser)deviceUser);
            if (!result.isSuccess()) {
                return result;
            }
        } else {
            logger.error("\u4e0d\u652f\u6301\u7684\u7528\u6237\u7c7b\u578b:[{}]", (Object)userType);
            return Result.failure((ErrorEnum)ErrorEnum.USER_TYPE_IS_NOT_SUPPORT);
        }
        return result;
    }

    public static Result checkParameter(PersonUser personUser) {
        return CheckParam.checkParameter((String)personUser.getEmail(), (String)personUser.getPostalCode(), (Integer)personUser.getSex(), (String)personUser.getTelNumber(), (Integer)personUser.getLicenseType(), (String)personUser.getLicenseNumber());
    }

    public static Result checkParameter(String email, String postalCode, Integer sex, String telNumber, Integer licenseType, String licenseNumber) {
        Result result;
        if (null != email && !PatternCheckUtils.checkEmail((String)email)) {
            return Result.failure((ErrorEnum)ErrorEnum.EMAIL_FORMAT_IS_ERROR);
        }
        if (null != postalCode && !PatternCheckUtils.checkPostalCode((String)postalCode)) {
            return Result.failure((ErrorEnum)ErrorEnum.POSTCODE_FORMAT_IS_ERROR);
        }
        if (null != sex && !PatternCheckUtils.checkSex((Integer)sex)) {
            return Result.failure((ErrorEnum)ErrorEnum.SEX_FORMAT_IS_ERROR);
        }
        if (null != telNumber && !PatternCheckUtils.checkTelNumber((String)telNumber)) {
            return Result.failure((ErrorEnum)ErrorEnum.TEL_NUMBER_IS_ERROR);
        }
        if (null != licenseType && !PersonUserTypeEnum.contain((int)licenseType).booleanValue()) {
            logger.error("\u4e0d\u652f\u6301\u7684\u4e2a\u4eba\u7528\u6237\u7c7b\u578b:[{}]", (Object)licenseType);
            return Result.failure((ErrorEnum)ErrorEnum.PERSON_USER_TYPE_IS_NOT_SUPPORT);
        }
        if (null != licenseType && null != licenseNumber && !(result = CheckParam.checkPersonLicenseNumber((Integer)licenseType, (String)licenseNumber)).isSuccess()) {
            return result;
        }
        return Result.success(null);
    }

    public static Result checkPerson(PersonUser personUser) {
        Result result = CheckParam.checkParameter((String)personUser.getEmail(), (String)personUser.getPostalCode(), (Integer)personUser.getSex(), (String)personUser.getTelNumber(), (Integer)personUser.getLicenseType(), (String)personUser.getLicenseNumber());
        if (!result.isSuccess()) {
            return result;
        }
        return result;
    }

    public static Result checkPersonLicenseNumber(Integer licenseType, String licenseNumber) {
        if (licenseType == PersonUserTypeEnum.IDENTITY_CARD.id) {
            if (!PatternCheckUtils.checkIdCard((String)licenseNumber)) {
                return Result.failure((ErrorEnum)ErrorEnum.ID_CARD_FORMAT_IS_ERROR);
            }
        } else if (licenseType == PersonUserTypeEnum.OFFICIAL_CARD.id) {
            if (!PatternCheckUtils.checkMilitaryOfficer((String)licenseNumber)) {
                return Result.failure((ErrorEnum)ErrorEnum.MILITARY_OFFICER_FORMAT_IS_ERROR);
            }
        } else if (licenseType == PersonUserTypeEnum.PASSPORT.id) {
            if (!PatternCheckUtils.checkPassPort((String)licenseNumber)) {
                return Result.failure((ErrorEnum)ErrorEnum.PASSPORT_FORMAT_IS_ERROR);
            }
        } else {
            if (licenseType == PersonUserTypeEnum.OTHER.id) {
                return Result.success(null);
            }
            logger.error("\u4e0d\u652f\u6301\u7684\u4e2a\u4eba\u7528\u6237\u7c7b\u578b:[{}]", (Object)licenseType);
            return Result.failure((ErrorEnum)ErrorEnum.PERSON_USER_TYPE_IS_NOT_SUPPORT);
        }
        return Result.success(null);
    }

    public static Result checkOrganUser(OrganUser organUser) {
        Result result = CheckParam.checkParameter((String)organUser.getEmail(), (String)organUser.getPostalCode(), null, null, null, null);
        if (!result.isSuccess()) {
            return result;
        }
        if (null != organUser.getLicenseType() && !(result = CheckParam.checkOrganType((Integer)organUser.getLicenseType())).isSuccess()) {
            return result;
        }
        if (null != organUser.getLicenseType() && null != organUser.getLicenseNumber() && !(result = CheckParam.checkOrganUserLicenseNumber((Integer)organUser.getLicenseType(), (String)organUser.getLicenseNumber())).isSuccess()) {
            return result;
        }
        if (null != organUser.getUserInfo()) {
            return CheckParam.checkParameter((PersonUser)organUser.getUserInfo());
        }
        return Result.success(null);
    }

    public static Result checkOrganUserLicenseNumber(Integer licenseType, String licenseNumber) {
        Result result = CheckParam.checkOrganType((Integer)licenseType);
        if (!result.isSuccess()) {
            return result;
        }
        if (!PatternCheckUtils.checkEnterprise((String)licenseNumber)) {
            logger.error("\u673a\u6784\u7528\u6237\u8bc1\u4ef6\u53f7\u4e0d\u80fd\u8d85\u8fc730\u4e2a\u5b57\u7b26");
            return Result.failure((ErrorEnum)ErrorEnum.ORGAN_LICENSE_NUMBER_IS_ERROR);
        }
        return Result.success(null);
    }

    public static Result checkDeviceUser(DeviceUser deviceUser) {
        Result result = null;
        if (null != deviceUser.getLicenseType() && !(result = CheckParam.checkDeviceType((Integer)deviceUser.getLicenseType())).isSuccess()) {
            return result;
        }
        if (null != deviceUser.getLicenseType() && null != deviceUser.getLicenseNumber() && !(result = CheckParam.checkDeviceUserLicenseNumber((Integer)deviceUser.getLicenseType(), (String)deviceUser.getLicenseNumber())).isSuccess()) {
            return result;
        }
        if (null != deviceUser.getUserInfo()) {
            return CheckParam.checkParameter((PersonUser)deviceUser.getUserInfo());
        }
        return result;
    }

    public static Result checkDeviceUserLicenseNumber(Integer licenseType, String licenseNumber) {
        Result result = CheckParam.checkDeviceType((Integer)licenseType);
        if (!result.isSuccess()) {
            return result;
        }
        if (!PatternCheckUtils.checkDeviceNumber((String)licenseNumber)) {
            logger.error("\u8bbe\u5907\u552f\u4e00\u6807\u8bc6\u7b26\u4e0d\u80fd\u8d85\u8fc760\u4e2a\u5b57\u7b26");
            return Result.failure((ErrorEnum)ErrorEnum.DEVICE_USER_LICENSE_NUMBER_LENGTH_IS_TOO_LONG);
        }
        return result;
    }

    public static Result CheckParameter(Integer userType, Integer licenseType, String licenseNumber, Integer status) {
        if (!UserStatusEnum.contain((int)status).booleanValue()) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7528\u6237\u72b6\u6001\u7c7b\u578b:[{}]", (Object)status);
            return Result.failure((ErrorEnum)ErrorEnum.USER_STATUS_TYPE_IS_NOT_SUPPORT);
        }
        return CheckParam.checkParameter((Integer)userType, (Integer)licenseType, (String)licenseNumber);
    }

    public static Result checkParameter(Integer userType, Integer licenseType, String licenseNumber) {
        Result result = CheckParam.checkUserType((Integer)userType);
        if (!result.isSuccess()) {
            return result;
        }
        if (userType == UserTypeEnum.PERSON_USER.id) {
            result = CheckParam.checkPersonLicenseNumber((Integer)licenseType, (String)licenseNumber);
            if (!result.isSuccess()) {
                return result;
            }
        } else if (userType == UserTypeEnum.ORGAN_USER.id) {
            result = CheckParam.checkOrganUserLicenseNumber((Integer)licenseType, (String)licenseNumber);
            if (!result.isSuccess()) {
                return result;
            }
        } else if (userType == UserTypeEnum.DEVICE_USER.id) {
            result = CheckParam.checkDeviceUserLicenseNumber((Integer)licenseType, (String)licenseNumber);
            if (!result.isSuccess()) {
                return result;
            }
        } else {
            return Result.failure((ErrorEnum)ErrorEnum.USER_TYPE_IS_NOT_SUPPORT);
        }
        return result;
    }

    public static Result checkUserType(Integer userType) {
        Result result = new Result();
        if (!UserTypeEnum.contain((int)userType).booleanValue()) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7528\u6237\u7c7b\u578b:[{}]", (Object)userType);
            return Result.failure((ErrorEnum)ErrorEnum.USER_TYPE_IS_NOT_SUPPORT);
        }
        return result;
    }

    public static Result checkPersonType(Integer identType) {
        Result result = new Result();
        if (!PersonUserTypeEnum.contain((int)identType).booleanValue()) {
            logger.error("\u4e0d\u652f\u6301\u7684\u4e2a\u4eba\u7528\u6237\u7c7b\u578b:[{}]", (Object)identType);
            return Result.failure((ErrorEnum)ErrorEnum.PERSON_USER_TYPE_IS_NOT_SUPPORT);
        }
        return result;
    }

    public static Result checkOrganType(Integer identType) {
        if (!OrganTypeEnum.contain((int)identType).booleanValue()) {
            logger.error("\u4e0d\u652f\u6301\u7684\u7528\u6237\u673a\u6784\u7c7b\u578b:[{}]", (Object)identType);
            return Result.failure((ErrorEnum)ErrorEnum.ORGAN_USER_TYPE_IS_NOT_SUPPORT);
        }
        return Result.success(null);
    }

    public static Result checkDeviceType(Integer identType) {
        if (!DeviceTypeEnum.contain((int)identType).booleanValue()) {
            logger.error("\u4e0d\u652f\u6301\u7684\u8bbe\u5907\u7528\u6237\u7c7b\u578b:[{}]", (Object)identType);
            return Result.failure((ErrorEnum)ErrorEnum.DEVICE_USER_TYPE_IS_NOT_SUPPORT);
        }
        return Result.success(null);
    }

    public static Result checkAuthority(String systemName, String systemFlag) {
        if (!systemFlag.equals(systemName)) {
            logger.error("\u4e0d\u652f\u6301\u8de8\u7cfb\u7edf\u8bbf\u95ee:[{}],[{}]", (Object)systemName, (Object)systemFlag);
            return Result.failure((ErrorEnum)ErrorEnum.THE_CROSS_SYSTEM_ACCESS_IS_NOT_SUPPORT);
        }
        return Result.success(null);
    }

    public static Result checkParam(IssueApply issueApply) {
        if (!CheckUtils.checkParamsNotNull((Object)issueApply)) {
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        if (null != issueApply.getPrivateKeyLength() && !KeyLengthEnum.contain((int)issueApply.getPrivateKeyLength())) {
            return Result.failure((ErrorEnum)ErrorEnum.KEY_LENGTH_IS_NOT_SUPPORT);
        }
        if (null != issueApply.getSignAlg() && !SignAlgEnum.contain((String)issueApply.getSignAlg())) {
            return Result.failure((ErrorEnum)ErrorEnum.SIGN_ALG_IS_NOT_SUPPORT);
        }
        return CheckParam.checkParameter((Integer)issueApply.getUserType(), (Integer)issueApply.getLicenseType(), (String)issueApply.getLicenseNumber());
    }

    public static Result checkParam(UpdateApply updateApply) {
        if (!CheckUtils.checkParamsNotNull((Object)updateApply)) {
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        return Result.success(null);
    }

    public static Result checkParam(RevokeApply revokeApply) {
        if (!CheckUtils.checkParamsNotNull((Object)revokeApply)) {
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        if (!RevokeReasonEnum.contain((int)revokeApply.getRevokeReason())) {
            return Result.failure((ErrorEnum)ErrorEnum.REVOKE_REASON_IS_NOT_SUPPORT);
        }
        return Result.success(null);
    }

    public static Result checkParam(RecoveryApply recoveryApply) {
        if (!CheckUtils.checkParamsNotNull((Object)recoveryApply)) {
            logger.warn("RecoveryApply missing req param [signSn]");
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        return Result.success(null);
    }

    public static Result checkParam(FreezeApply freezeApply) {
        if (!CheckUtils.checkParamsNotNull((Object)freezeApply)) {
            logger.warn("FreezeApply missing req param [signSn&isFreeze]");
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        return Result.success(null);
    }

    public static Result checkParam(Integer applyType, Object object) {
        if (!CheckUtils.checkParamsNotNull((Object)object)) {
            return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        return CheckParam.checkApplyType((Integer)applyType);
    }

    public static Result checkApplyType(Integer applyType) {
        if (!ApplyTypeEnum.contain((int)applyType)) {
            logger.error("\u4e0d\u5b58\u5728\u7684\u7533\u8bf7\u7c7b\u578b");
            return Result.failure((ErrorEnum)ErrorEnum.THE_APPLY_TYPE_IS_NOT_EXIT);
        }
        return Result.success(null);
    }

    public static Result checkParam(Integer applyType, EditCertApplyInfo editCertApplyInfo) {
        if (applyType == ApplyTypeEnum.ISSUE_APPLY.id) {
            EditIssueApplyInfo editIssueApplyInfo = editCertApplyInfo.getEditIssueApplyInfo();
            if (null == editIssueApplyInfo || !CheckUtils.checkParamsNotNull((Object)editIssueApplyInfo)) {
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
        } else if (applyType == ApplyTypeEnum.UPDATE_APPLY.id) {
            EditUpdateApplyInfo editUpdateApplyInfo = editCertApplyInfo.getEditUpdateApplyInfo();
            if (null == editUpdateApplyInfo || !CheckUtils.checkParamsNotNull((Object)editUpdateApplyInfo)) {
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
        } else if (applyType == ApplyTypeEnum.REVOKE_APPLY.id) {
            EditRevokeApplyInfo editRevokeApplyInfo = editCertApplyInfo.getEditRevokeApplyInfo();
            if (null == editRevokeApplyInfo || !CheckUtils.checkParamsNotNull((Object)editRevokeApplyInfo)) {
                return Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            }
        } else {
            logger.error("\u4e0d\u5b58\u5728\u7684\u7533\u8bf7\u7c7b\u578b");
            return Result.failure((ErrorEnum)ErrorEnum.THE_APPLY_TYPE_IS_NOT_EXIT);
        }
        return Result.success(null);
    }

    private static boolean checkEditApplyParam(boolean b, boolean b2) {
        if (b) {
            return true;
        }
        return !b2;
    }

    public static Object resultDeal(Result result, HttpServletResponse resp) {
        logger.debug("\u5904\u7406\u7ed3\u679c\uff1a[{}]", (Object)result);
        if (result.isSuccess()) {
            return result.getInfo();
        }
        ErrorMsg errorMsg = new ErrorMsg();
        if (null != result.getError()) {
            errorMsg.setErrorCode(Integer.valueOf(result.getError().code));
            errorMsg.setErrorMsg(result.getError().desc);
        } else {
            ErrorBean errorBean = result.getErrorBean();
            errorMsg.setErrorCode(Integer.valueOf(errorBean.getErrCode()));
            errorMsg.setErrorMsg(errorBean.getErrMsg());
        }
        resp.setStatus(400);
        return errorMsg;
    }

    public static Object resultSort(Result result, HttpServletResponse resp) {
        ErrorEnum errorEnum = result.getError();
        if (errorEnum.code != ErrorEnum.MISSING_REQUIRED_PARAMETERS.code) {
            return CheckParam.resultDeal((Result)Result.failure((ErrorEnum)ErrorEnum.ILLEGAL_REQUEST_PARAMETER), (HttpServletResponse)resp);
        }
        return CheckParam.resultDeal((Result)Result.failure((ErrorEnum)ErrorEnum.MISSING_REQUIRED_PARAMETERS), (HttpServletResponse)resp);
    }
}

