package com.xdja.pki.ra.openapi.bean;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.service.manager.certapply.bean.ErrorMsg;

/**
 * @author: ggp
 * @Date: 2019/11/1 13:59
 * @Description:
 */
public class Result {
    private static final long serialVersionUID = 1L;
    /**
     * 错误信息
     */
    private ErrorMsg errorMsg;
    /**
     * 成功时返回数据对象
     */
    private Object info;
    /**
     * true 成功  false失败
     */
    private Boolean isSuccess;

    /**
     * 兼容
     */
    private ErrorEnum errorEnum;

    public Boolean getSuccess() {
        return isSuccess;
    }

    public ErrorEnum getErrorEnum() {
        return errorEnum;
    }

    public void setErrorEnum(ErrorEnum errorEnum) {
        this.errorEnum = errorEnum;
    }

    public ErrorMsg getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(ErrorMsg errorMsg) {
        this.errorMsg = errorMsg;
    }

    public Object getInfo() {
        return info;
    }

    public void setInfo(Object info) {
        this.info = info;
        this.isSuccess = true;
    }

    /**
     * 兼容
     * @return
     */
    public Boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    /**
     * 失败返回
     * @param errorEnum
     * @return
     */
    public static Result failure(ErrorEnum errorEnum){
        Result result = new Result();
        result.setError(errorEnum);
        return result;
    }

    /**
     * 成功返回
     * @param info
     * @return
     */
    public static Result success(Object info){
        Result result = new Result();
        result.setSuccess(true);
        result.setInfo(info);
        return result;
    }

    /**
     * 兼容sdkResult 和ra的result
     * @param errorEnum
     */
    public void setError(ErrorEnum errorEnum){
        this.setSuccess(false);
        this.setErrorEnum(errorEnum);
        ErrorMsg errorMsg = new ErrorMsg();
        errorMsg.setErrorCode(errorEnum.code);
        errorMsg.setErrorMsg(errorEnum.errMsg);
        this.setErrorMsg(errorMsg);
    }

    @Override
    public String toString() {
        return "CoreResult{" +
                "errorMsg=" + errorMsg +
                ", info=" + info +
                ", isSuccess=" + isSuccess +
                ", errorEnum=" + errorEnum +
                '}';
    }
}
