package com.xdja.pki.ra.openapi.normal;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.openapi.aop.SignIntercep;
import com.xdja.pki.ra.openapi.bean.SystemFlagBean;
import com.xdja.pki.ra.openapi.normal.Utils.CheckParam;
import com.xdja.pki.ra.service.manager.usercertmanager.UserCertManagerService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;

/**
 * @author: ggp
 * @Date: 2019/10/30 16:33
 * @Description:
 */
@RestController
public class UserCertManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private UserCertManagerService userCertManagerService;

    /**
     * 查询用户证书
     *
     * @param userType
     * @param identType
     * @param identNumber
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/cert/{userType}/{identType}/{identNumber}", method = RequestMethod.GET)
    public Object userCertQuery(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始调用查询用户证书");
        logger.debug("请求参数userType:[{}]", userType);
        logger.debug("请求参数identType:[{}]", identType);
        logger.debug("请求参数identNumber:[{}]", identNumber);

        Result result = CheckParam.checkParameter(userType,identType,identNumber);
        if (!result.isSuccess()) {
            return CheckParam.resultSort(result,resp);
        }
        result = userCertManagerService.getUserCertInfoList(userType, identType, identNumber,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }

    /**
     * 查询用户证书详情
     *
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/cert/{certSn}", method = RequestMethod.GET)
    public Object userCertDetailQuery(@PathVariable String certSn, SystemFlagBean systemFlagBean,HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始调用查询用户证书详情");
        logger.debug("请求参数certSn:[{}]", certSn);

        Result result = userCertManagerService.getUserCertBaseInfo(certSn,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }

    /**
     * 用户双证书下载
     *
     * @param certSn
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/cert/file/{certSn}", method = RequestMethod.GET)
    public Object userCertDownload(@PathVariable String certSn,SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始调用查询用户双证书下载");
        logger.debug("请求参数certSn:[{}]", certSn);

        Result result = userCertManagerService.downLoadUserCertFile(certSn,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }

    /**
     * 根据签名证书sn获取base64格式证书
     * @param certSn
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "v1/ra-openapi/cert/base64/{certSn}")
    public Object getUserCert(@PathVariable String certSn,SystemFlagBean systemFlagBean,HttpServletResponse resp){
        logger.info("ra-openapi-normal---------------------开始调用获取base64格式证书接口");
        logger.debug("请求参数certSn:[{}]", certSn);

        Result result = userCertManagerService.getUserCert(certSn,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }


}
