package com.xdja.pki.ra.openapi.normal;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.openapi.aop.SignIntercep;
import com.xdja.pki.ra.openapi.bean.SystemFlagBean;
import com.xdja.pki.ra.openapi.normal.Utils.CheckParam;
import com.xdja.pki.ra.service.manager.baseuser.bean.UserInfo;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * @author: ggp
 * @Date: 2019/10/18 08:49
 * @Description:用户管理
 */
@RestController
public class UserManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private BaseUserService baseUserService;

    /**
     * 测试信任证书链的有效性（测试安全通道的连通性）
     *
     * @return
     */
    @RequestMapping(value = "v1/ra-openapi/trustCertChain", method = RequestMethod.GET)
    public Object testConnect() {
        logger.info("ra-openapi-normal---------------------开始验证信任证书链");

        return Result.success("success");
    }

    /**
     * 用户注册
     *
     * @param userType
     * @param userInfo
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/user/{userType}", method = RequestMethod.POST)
    public Object userRegister(@PathVariable Integer userType, @RequestBody UserInfo userInfo, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始调用用户注册");
        logger.debug("用户注册请求参数：userType:[{}]", userType);
        logger.debug("用户注册请求参数：UserInfo[{}]", userInfo);

        Result result = CheckParam.requestParamCheck(userType, userInfo,false);
        if (!result.isSuccess()) {
            return CheckParam.resultSort(result,resp);
        }
        result = baseUserService.userRegister(userType, userInfo,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }


    /**
     * 用户批量注册
     */
    public Object batchUserRegist(List<UserInfo> userInfoList) {
        // 暂无
        return null;
    }

    /**
     * 用户信息查询
     *
     * @param userType
     * @param identType
     * @param identNumber
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/user/{userType}/{identType}/{identNumber}", method = RequestMethod.GET)
    public Object getUserInfo(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber,SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始调用用户查询");
        logger.debug("用户查询请求参数：userType:[{}],identType:[{}],identNumber:[{}]", userType, identType, identNumber);

        Result result = CheckParam.checkParameter(userType, identType,identNumber);
        if (!result.isSuccess()) {
            return CheckParam.resultSort(result,resp);
        }
        result = baseUserService.userQuery(userType, identType, identNumber,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }

    /**
     * 根据签名证书sn查询用户信息
     * @param signSn
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/user/{signSn}")
    public Object getUserInfo(@PathVariable String signSn,SystemFlagBean systemFlagBean, HttpServletResponse resp){
        logger.info("ra-openapi-normal---------------------开始调用用户查询");
        logger.debug("用户查询请求参数：signSn:[{}]", signSn);

        Result result = baseUserService.userQuery(signSn,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }

    /**
     * 用户信息更新
     *
     * @param userType
     * @param identType
     * @param identNumber
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/user/{userType}/{identType}/{identNumber}", method = RequestMethod.PUT)
    public Object updateUserInfo(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, @RequestBody UserInfo userInfo, SystemFlagBean systemFlagBean,HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始调用用户更新");
        logger.debug("用户更新请求参数：userType:[{}],identType:[{}],identNumber:[{}]", userType, identType, identNumber);
        logger.debug("用户更新请求参数：userInfo[{}]", userInfo);

        Result result = CheckParam.checkParameter(userType, identType,identNumber);
        if (!result.isSuccess()) {
            return CheckParam.resultSort(result,resp);
        }
        result = CheckParam.requestParamCheck(userType, userInfo,true);
        if (!result.isSuccess()) {
            return CheckParam.resultSort(result,resp);
        }
        result = baseUserService.userUpdate(userType, identType, identNumber, userInfo, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }


    /**
     * 修改用户状态
     *
     * @param userType
     * @param identType
     * @param identNumber
     * @return
     */
    @SignIntercep
    @RequestMapping(value = "/v1/ra-openapi/user/{userType}/{identType}/{identNumber}/{userStatus}", method = RequestMethod.PUT)
    public Object updateUserInfo(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, @PathVariable Integer userStatus,SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        logger.info("ra-openapi-normal---------------------开始修改用户状态");
        logger.debug("修改用户状态请求参数：userType:[{}],identType:[{}],identNumber:[{}],userStatus:[{}]", userType, identType, identNumber, userStatus);
        Result result = CheckParam.CheckParameter(userType,identType,identNumber,userStatus);
        if (!result.isSuccess()) {
            return CheckParam.resultSort(result,resp);
        }
        result = baseUserService.updateUserStatus(userType, identType, identNumber, userStatus,systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal(result, resp);
    }


    /**
     * 用户信息审核
     *
     * @return
     */

    public Object userInfoCheck() {
        //TODO 暂无
        return null;
    }

}
