package com.xdja.pki.ra.openapi.normal.api;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.openapi.core.BaseCMPInfo;
import com.xdja.pki.ra.service.manager.cache.RedisCacheManagerService;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.security.SecureRandom;

/**
 * @author wly
 */
@RestController
public class NormalRandomController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    RedisCacheManagerService redisCacheManagerService;
    /**
     * 接收设备的随机数请求
     *
     * @param transId
     * @param resp
     */
    @RequestMapping(value = "/v1/normal/ra/random", method = RequestMethod.GET)
    public Object genRandomNum(@RequestParam String transId, HttpServletResponse resp) {
        logger.debug("NormalRandomController.genRandomNum>>>>>>transId:" + transId);
        if (StringUtils.isBlank(transId)) {
            return ErrorEnum.ILLEGAL_REQUEST_PARAMETER.resp(resp);
        }
        byte[] raRecipNonce = new byte[16];
        raRecipNonce = genRandomByHsm(raRecipNonce.length);

        // RA内存缓存用户transId对应的nonce值
        BaseCMPInfo baseCMPInfo = new BaseCMPInfo(null, raRecipNonce, transId, -1, 0);
        redisCacheManagerService.cacheRaSdkCmpInfo(transId, JsonUtils.object2Json(baseCMPInfo));
        return Base64.toBase64String(raRecipNonce);
    }
    /**
     * 通过密码机生成随机数
     *
     * @return
     */
    public static byte[] genRandomByHsm(int length) {
        //  String randomByHsm = GMSSLRandomUtils.generateRandomByYunhsm(length);
        byte[] normalSenderNonce = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(normalSenderNonce);
        //  byte[] random = Base64.decode(randomByHsm);
        return normalSenderNonce;
    }
}
