/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal.handler;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.openapi.core.common.FreeText;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.cache.RedisCacheManagerService;
import com.xdja.pki.ra.service.manager.cache.bean.BaseCMPInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="cmpNormalErrorMsgHandler")
public class CmpNormalErrorMsgHandler
implements ICmpMessageHandler {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    CustomerSysService customerSysService;
    @Autowired
    RedisCacheManagerService redisCacheManagerService;

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException {
        this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage errorMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (errorMessage == null) {
            String errMsg = "RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== No pkiMessage response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        PKIHeader header = errorMessage.getHeader();
        if (header == null) {
            String errMsg = "RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        GeneralName sender = header.getSender();
        GeneralName recipient = header.getRecipient();
        byte[] normalRecipNonce = new byte[]{};
        byte[] normalSenderNonce = new byte[]{};
        String normalTranID = null;
        AlgorithmIdentifier protectionAlg = null;
        try {
            normalRecipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            normalSenderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            normalTranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        if (normalRecipNonce == null || normalSenderNonce == null || protectionAlg == null || StringUtils.isBlank((CharSequence)normalTranID)) {
            String errMsg = "RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u9519\u8bef\u6d88\u606f\u63a5\u53e3\u4e2d\u5fc5\u586b\u9879\u6709\u7a7a\u503c";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        BaseCMPInfo baseCMPInfo = this.redisCacheManagerService.removeRaSdkCmpInfo(normalTranID);
        if (baseCMPInfo == null) {
            this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4e8b\u52a1ID tranId:{}", (Object)normalTranID);
            result.setError(ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST);
            return result;
        }
        FreeText freeText = null;
        PKIFreeText pkiFreeText = header.getFreeText();
        if (pkiFreeText != null) {
            String freeTestStr = pkiFreeText.getStringAt(0).getString();
            freeText = (FreeText)JsonUtils.json2Object((String)freeTestStr, FreeText.class);
            if (freeText == null) {
                this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== PKI\u6d88\u606f\u4f53\u4e2d\u4e0d\u5305\u542bsn\u4fe1\u606f");
                RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.code, (String)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.desc);
                PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)23, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)revRepContent);
                result.setInfo((Object)errPkiMessage);
                return result;
            }
        } else {
            this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== PKI\u6d88\u606f\u4f53\u4e2d\u4e0d\u5305\u542bsn\u4fe1\u606f");
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.code, (String)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)23, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        String signSn = freeText.getSignSn();
        String normalSender = sender.getName().toString();
        Result certResult = this.customerSysService.getSysCertBySysNumber(normalSender, signSn);
        if (!certResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== \u901a\u8fc7\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6807\u8bc6\u786e\u8ba4\u7b2c\u4e09\u65b9\u7684\u8bc1\u4e66\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)certResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)certResult.getError().code, (String)certResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)23, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PublicKey publicKey = (PublicKey)certResult.getInfo();
        this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        DERBitString protectData = errorMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign((PublicKey)publicKey, (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, null);
        if (!checkResult.isSuccess()) {
            this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== 3.1 \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)checkResult));
            result.setError(checkResult.getError());
            return result;
        }
        PKIBody body = errorMessage.getBody();
        if (body == null) {
            this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            result.setError(ErrorEnum.NO_PKI_BODY_FOR_RECEIVED);
            return result;
        }
        if (body.getType() != 23) {
            this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f23");
            result.setError(ErrorEnum.ERROR_MSG_PKI_BODY_TAG_NOT_23);
            return result;
        }
        String applyNo = this.redisCacheManagerService.removeNomalTransId(normalTranID);
        ErrorMsgContent errorMsgContent = (ErrorMsgContent)body.getContent();
        try {
            int errorCode = errorMsgContent.getErrorCode() == null ? 111111 : errorMsgContent.getErrorCode().getValue().intValue();
            String errorMsg = errorMsgContent.getErrorDetails() == null ? "RA\u81ea\u5b9a\u4e49normal\u8fd4\u56de\u7684\u9519\u8bef\u6d88\u606f" : errorMsgContent.getErrorDetails().getStringAt(0).getString();
            this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u9519\u8bef\u7801:[{}] \u9519\u8bef\u6d88\u606f:[{}]", (Object)errorCode, (Object)errorMsg);
            Result errResult = this.certApplyService.genErrorMsgContent(applyNo, errorCode, errorMsg, true);
            if (!errResult.isSuccess()) {
                this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ==========  \u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u8bf7\u6c42\u9519\u8bef{}", (Object)JsonUtils.object2Json((Object)errResult));
                result.setErrorBean(errResult.getErrorBean());
                return result;
            }
        }
        catch (Exception e) {
            this.logger.error("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u89e3\u6790normal\u7684\u9519\u8bef\u6d88\u606f\u65f6\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.NORMAI_ERROR_MES_REQ_PARAMS_ERROR);
            return result;
        }
        this.logger.info("RA\u8bc1\u4e66\u9519\u8bef\u6d88\u606f ========== \u3010\u7ed3\u675f\u3011");
        this.redisCacheManagerService.removeCaTransId(applyNo);
        return result;
    }
}

