/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal.handler;

import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.PKICertHelper;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.openapi.core.common.CmpRespCertType;
import com.xdja.pki.ra.openapi.core.common.FreeText;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.cache.RedisCacheManagerService;
import com.xdja.pki.ra.service.manager.cache.bean.BaseCMPInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyManagerService;
import com.xdja.pki.ra.service.manager.certapply.bean.DoubleCode;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import java.security.PublicKey;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="cmpNormalIssuerCertReqHandler")
public class CmpNormalIssuerCertReqHandler
implements ICmpMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyManagerService certApplyManagerService;
    @Autowired
    CustomerSysService customerSysService;
    @Autowired
    CertApplyDao certApplyDao;
    @Autowired
    RedisCacheManagerService redisCacheManagerService;

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException {
        CertResponse[] certRespos;
        this.logger.info("RA\u63a5\u6536normal\u7b7e\u53d1\u5904\u7406 ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage reqPkiMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (reqPkiMessage == null) {
            String errMsg = "RA\u7b7e\u53d1\u5904\u7406 ========== No pkiMessage response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        PKIHeader header = null;
        this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        try {
            header = reqPkiMessage.getHeader();
        }
        catch (Exception e) {
            this.logger.error("opani========", (Throwable)e);
        }
        if (header == null) {
            String errMsg = "RA\u7b7e\u53d1\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        GeneralName sender = GeneralName.getInstance((Object)header.getSender());
        GeneralName recipient = header.getRecipient();
        byte[] normalRecipNonce = new byte[]{};
        byte[] normalSenderNonce = new byte[]{};
        String normalTranID = null;
        AlgorithmIdentifier protectionAlg = null;
        try {
            normalRecipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            normalSenderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            normalTranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u7b7enormalTranID\u53d1\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        if (normalRecipNonce == null || normalSenderNonce == null || protectionAlg == null || StringUtils.isBlank((CharSequence)normalTranID)) {
            String errMsg = "RA\u7b7e\u53d1\u5904\u7406 ========== \u7b7e\u53d1\u63a5\u53e3\u4e2d\u5fc5\u586b\u9879\u6709\u7a7a\u503c";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        BaseCMPInfo baseCMPInfo = this.redisCacheManagerService.removeRaSdkCmpInfo(normalTranID);
        if (baseCMPInfo == null) {
            this.logger.info("\u7b7e\u53d1\u5904\u7406 ========== \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4e8b\u52a1ID tranId:{}", (Object)normalTranID);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.code, (String)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        CertReqMessages ir = (CertReqMessages)reqPkiMessage.getBody().getContent();
        long signRequestId = ir.toCertReqMsgArray()[0].getCertReq().getCertReqId().getValue().longValue();
        baseCMPInfo.setRequestId(signRequestId);
        this.redisCacheManagerService.cacheRaSdkCmpInfo(normalTranID, baseCMPInfo);
        FreeText freeText = null;
        PKIFreeText pkiFreeText = header.getFreeText();
        if (pkiFreeText != null) {
            String freeTestStr = pkiFreeText.getStringAt(0).getString();
            freeText = (FreeText)JsonUtils.json2Object((String)freeTestStr, FreeText.class);
            if (freeText == null) {
                this.logger.info("\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u4e0d\u5305\u542b\u7533\u8bf7\u4fe1\u606f");
                RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.code, (String)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.desc);
                PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)revRepContent);
                result.setInfo((Object)errPkiMessage);
                return result;
            }
        } else {
            this.logger.info("\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u4e0d\u5305\u542b\u7533\u8bf7\u4fe1\u606f");
            RevRepContent revRepContent = PKIMessageHelper.genFailRevRepContent((long)-1L, (int)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.code, (String)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)revRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        String applyNo = freeText.getApplyNo();
        DoubleCode doubleCode = freeText.getDoubleCode();
        String signSn = freeText.getSignSn();
        Integer keyFormat = freeText.getKeyFormat();
        String normalSender = sender.getName().toString();
        this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== \u7b7e\u53d1\u7533\u8bf7\u7684applyNo\uff1a[{}] \u7b2c\u4e09\u65b9\u7cfb\u7edf-\u552f\u4e00\u6807\u8bc6:[{}] \u79c1\u94a5\u683c\u5f0f:[{}]", new Object[]{applyNo, normalSender, keyFormat});
        Result certResult = this.customerSysService.getSysCertBySysNumber(normalSender, signSn);
        if (!certResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== \u901a\u8fc7\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6807\u8bc6\u786e\u8ba4\u7b2c\u4e09\u65b9\u7684\u8bc1\u4e66\u9519\u8bef \u539f\u56e0\uff1a[{}]", (Object)JsonUtils.object2Json((Object)certResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR.code, (String)ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PublicKey publicKey = (PublicKey)certResult.getInfo();
        this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        DERBitString protectData = reqPkiMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign((PublicKey)publicKey, (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, null);
        if (!checkResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0\uff1a[{}]", (Object)JsonUtils.object2Json((Object)checkResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)checkResult.getError().code, (String)checkResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PKIBody body = pkiMessage.getBody();
        if (body == null) {
            this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.code, (String)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (body.getType() != 0 && body.getType() != 2) {
            this.logger.info("RA\u7b7e\u53d1\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f0\u62162");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.code, (String)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        ASN1Encodable content = body.getContent();
        CertReqMessages myCertReqMessages = CertReqMessages.getInstance((Object)content);
        CertReqMsg[] certReqMsgs = myCertReqMessages.toCertReqMsgArray();
        CertReqMsg certReqMsg = certReqMsgs[0];
        CertRequest certReq = certReqMsg.getCertReq();
        CertTemplate certTemplate = certReq.getCertTemplate();
        PublicKey normalPublicKey = null;
        try {
            SubjectPublicKeyInfo subPublicKey = certTemplate.getPublicKey();
            if (subPublicKey == null) {
                this.logger.error("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u4e3a\u7a7a");
                CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EMPTY.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EMPTY.desc);
                PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
                result.setInfo((Object)errPkiMessage);
                return result;
            }
            normalPublicKey = PKICertHelper.getPublicKeyFromSubjectPublicKey((SubjectPublicKeyInfo)subPublicKey, (String)"BC");
        }
        catch (Exception e) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        this.redisCacheManagerService.cacheNomalTransId(normalTranID, applyNo);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4. \u53d1\u8d77\u7b7e\u53d1\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42");
        Result issueResult = this.certApplyManagerService.certApplyCarry(normalSender, Integer.valueOf(1), applyNo, doubleCode, normalPublicKey.getEncoded(), keyFormat);
        if (!issueResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.1. \u7b7e\u53d1\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42\u9519\u8bef[{}]", (Object)JsonUtils.object2Json((Object)issueResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)issueResult.getErrorBean().getErrCode(), (String)issueResult.getErrorBean().getErrMsg());
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== CA\u8fd4\u56de\u7684\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u7684\u54cd\u5e94\u7ed3\u679c >>>>>>> [{}]", (Object)JsonUtils.object2Json((Object)issueResult));
        if (issueResult.getInfo() == null) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.2. \u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u6682\u65e0\u8fd4\u56de\u8bc1\u4e66\u4fe1\u606f");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.code, (String)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)issueResult.getInfo();
        Integer certPatterm = null;
        try {
            certPatterm = this.certApplyDao.getCertPatterm(applyNo);
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        if (null == userCertInfo.getSignCert()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (1 != certPatterm && null == userCertInfo.getEncCert()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        CertResponse signCertResponse = null;
        CertResponse encCertResponse = null;
        try {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 5. \u5c06\u8bc1\u4e66\u5c01\u88c5\u7b7e\u540dCertResponse\u7ed3\u6784\u4f53");
            signCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_SIGN_CERT_1.value, (Integer)keyFormat);
            if (1 != certPatterm) {
                this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 6. \u5c06\u8bc1\u4e66\u5c01\u88c5\u52a0\u5bc6CertResponse\u7ed3\u6784\u4f53");
                encCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_ENC_CERT_AND_ENC_PRI_KEY_2.value, (Integer)keyFormat);
            }
        }
        catch (Exception e) {
            this.logger.error("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u5c01\u88c5CertResponse\u7ed3\u6784\u4f53\u5f02\u5e38", (Throwable)e);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.code, (String)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (signCertResponse != null && encCertResponse == null) {
            certRespos = new CertResponse[]{signCertResponse};
        } else if (signCertResponse != null && encCertResponse != null) {
            certRespos = new CertResponse[]{signCertResponse, encCertResponse};
        } else {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 6.1. \u5c01\u88c5CertResponse\u5931\u8d25");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.code, (String)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 7. \u5c01\u88c5CertRepMessage\u7ed3\u6784\u4f53");
        CertRepMessage certRepMessage = new CertRepMessage(null, certRespos);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 8. \u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage repPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])normalRecipNonce, (byte[])normalSenderNonce, (String)normalTranID, (ASN1Encodable)certRepMessage, null, (String)userCertInfo.getExtraCertsP7b());
        result.setInfo((Object)repPkiMessage);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u3010\u7ed3\u675f\u3011");
        return result;
    }
}

