/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal.handler;

import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.PKICertHelper;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.CertApplyDao;
import com.xdja.pki.ra.openapi.core.common.FreeText;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.cache.RedisCacheManagerService;
import com.xdja.pki.ra.service.manager.cache.bean.BaseCMPInfo;
import com.xdja.pki.ra.service.manager.certapply.CertApplyManagerService;
import com.xdja.pki.ra.service.manager.customer.CustomerSysService;
import java.io.IOException;
import java.security.PublicKey;
import javax.annotation.Resource;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.KeyRecRepContent;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;

@Component(value="cmpNormalRecoveryCertReqHandler")
public class CmpNormalRecoveryCertReqHandler
implements ICmpMessageHandler {
    private static final Logger logger = LoggerFactory.getLogger(CmpNormalRecoveryCertReqHandler.class);
    @Resource
    private CertApplyManagerService certApplyManagerService;
    @Resource
    private CustomerSysService customerSysService;
    @Resource
    private CertApplyDao certApplyDao;
    @Autowired
    private RedisCacheManagerService redisCacheManagerService;

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException, IOException {
        byte[] publickey;
        AlgorithmIdentifier protectionAlg;
        String tranID;
        byte[] senderNonce;
        byte[] recipNonce;
        logger.info("[CmpNormalRecoveryCertReqHandler#handleMessage] RA\u63a5\u6536normal\u66f4\u65b0\u5904\u7406 ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        logger.info("RA\u6062\u590d\u5904\u7406 ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage reqPkiMessage = this.getPkiMessage(pkiMessage);
        PKIHeader header = this.getPkiHeader(reqPkiMessage);
        GeneralName sender = GeneralName.getInstance((Object)header.getSender());
        GeneralName recipient = header.getRecipient();
        try {
            recipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            senderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            tranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u6062\u590d\u5904\u7406 ========== No header in response message.";
            logger.info(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        FreeText freeText = null;
        PKIFreeText pkiFreeText = header.getFreeText();
        if (pkiFreeText != null) {
            String freeTestStr = pkiFreeText.getStringAt(0).getString();
            freeText = (FreeText)JsonUtils.json2Object((String)freeTestStr, FreeText.class);
            if (freeText == null) {
                logger.info("RA\u6062\u590d\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u4e0d\u5305\u542b\u7533\u8bf7\u4fe1\u606f");
                KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)-1L, (int)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.code, (String)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.desc);
                PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
                result.setInfo((Object)errPkiMessage);
                return result;
            }
        } else {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u4e0d\u5305\u542b\u7533\u8bf7\u4fe1\u606f");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)-1L, (int)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.code, (String)ErrorEnum.PKI_MESSAGE_NOT_CONTENT_REVOKE_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        String applyNo = freeText.getApplyNo();
        Integer keyFormat = freeText.getKeyFormat();
        String normalSender = sender.getName().toString();
        BaseCMPInfo baseCMPInfo = this.redisCacheManagerService.removeRaSdkCmpInfo(tranID);
        if (baseCMPInfo == null) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4e8b\u52a1ID tranId:{}", (Object)tranID);
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)-1L, (int)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.code, (String)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        long signRequestId = this.getSignRequestId(reqPkiMessage);
        baseCMPInfo.setRequestId(signRequestId);
        this.redisCacheManagerService.cacheRaSdkCmpInfo(tranID, baseCMPInfo);
        Result certResult = this.customerSysService.getSysCertBySysNumber(normalSender, freeText.getSignSn());
        if (!certResult.isSuccess()) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== \u901a\u8fc7\u7b2c\u4e09\u65b9\u7cfb\u7edf\u6807\u8bc6\u786e\u8ba4\u7b2c\u4e09\u65b9\u7684\u8bc1\u4e66\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)certResult));
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)-1L, (int)ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR.code, (String)ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PublicKey publicKey = (PublicKey)certResult.getInfo();
        logger.info("RA\u6062\u590d\u5904\u7406 ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        DERBitString protectData = reqPkiMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign((PublicKey)publicKey, (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, null);
        if (!checkResult.isSuccess()) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)checkResult));
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)-1L, (int)checkResult.getError().code, (String)checkResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PKIBody body = pkiMessage.getBody();
        if (body == null) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.code, (String)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (body.getType() != 9) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f9");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.code, (String)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        ASN1Encodable content = body.getContent();
        CertReqMessages myCertReqMessages = CertReqMessages.getInstance((Object)content);
        CertReqMsg[] certReqMsgs = myCertReqMessages.toCertReqMsgArray();
        CertReqMsg certReqMsg = certReqMsgs[0];
        CertRequest certReq = certReqMsg.getCertReq();
        CertTemplate certTemplate = certReq.getCertTemplate();
        PublicKey normalPublicKey = null;
        try {
            SubjectPublicKeyInfo subPublicKey = certTemplate.getPublicKey();
            if (subPublicKey == null) {
                publickey = null;
                logger.info("RA\u6062\u590d\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5931\u8d25");
            } else {
                normalPublicKey = PKICertHelper.getPublicKeyFromSubjectPublicKey((SubjectPublicKeyInfo)subPublicKey, (String)"BC");
                publickey = normalPublicKey.getEncoded();
            }
        }
        catch (Exception e) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        logger.info("RA\u6062\u590d\u5904\u7406 ========== \u66f4\u65b0\u7533\u8bf7\u7684applyNo\uff1a{}  \u7b2c\u4e09\u65b9\u7cfb\u7edf-\u552f\u4e00\u6807\u8bc6:{} ", (Object)applyNo, (Object)normalSender);
        this.redisCacheManagerService.cacheNomalTransId(tranID, applyNo);
        logger.info("RA\u6062\u590d\u5904\u7406 ========== 4. \u53d1\u8d77\u6062\u590d\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42");
        Result recoveryResult = this.certApplyManagerService.certApplyCarry(normalSender, Integer.valueOf(4), applyNo, freeText.getDoubleCode(), publickey, keyFormat);
        if (!recoveryResult.isSuccess()) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== 4.1.\u6062\u590d\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42\u9519\u8bef:{} ", (Object)JsonUtils.object2Json((Object)recoveryResult));
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)recoveryResult.getErrorBean().getErrCode(), (String)recoveryResult.getErrorBean().getErrMsg());
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        logger.info("RA\u6062\u590d\u5904\u7406 ========== CA\u8fd4\u56de\u7684\u8bc1\u4e66\u6062\u590d\u8bf7\u6c42\u7684\u54cd\u5e94\u7ed3\u679c >>>>>>>:{} ", (Object)JsonUtils.object2Json((Object)recoveryResult));
        if (recoveryResult.getInfo() == null) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== 4.2. \u6062\u590d\u7528\u6237\u8bc1\u4e66\u6682\u65e0\u8fd4\u56de\u8bc1\u4e66\u4fe1\u606f");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.code, (String)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)recoveryResult.getInfo();
        Integer certPatterm = null;
        try {
            certPatterm = this.certApplyDao.getCertPatterm(applyNo);
        }
        catch (Exception e) {
            logger.info("\u83b7\u53d6\u7b7e\u53d1\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        if (null == userCertInfo.getSignCert()) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (1 != certPatterm && null == userCertInfo.getEncCert()) {
            logger.info("RA\u6062\u590d\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        logger.info("\u5bc6\u94a5\u6062\u590d\u7533\u8bf7\u5904\u7406 ========== 5. \u5c06\u5bc6\u94a5\u6062\u590d\u5bf9\u8c61\u8bc1\u4e66KeyRecRepContent\u7ed3\u6784\u4f53");
        KeyRecRepContent keyRecRepContent = null;
        try {
            keyRecRepContent = PKIMessageHelper.genKeyRecRepContent((UserCertInfo)userCertInfo);
        }
        catch (Exception e) {
            logger.error("\u5c01\u88c5\u5bc6\u94a5\u6062\u590d\u8fd4\u56de\u5bf9\u8c61KeyRecRepContent\u5f02\u5e38", (Throwable)e);
            KeyRecRepContent failKeyRecRepContent = PKIMessageHelper.genFailKeyRecRepContent((long)signRequestId, (int)ErrorEnum.GEN_KEY_RECOVERY_REP_EXCEPTION.code, (String)ErrorEnum.GEN_KEY_RECOVERY_REP_EXCEPTION.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)failKeyRecRepContent);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        logger.info("RA\u6062\u590d\u5904\u7406 ========== 6. \u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage repPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)10, (byte[])recipNonce, (byte[])senderNonce, (String)tranID, (ASN1Encodable)keyRecRepContent, null, (String)userCertInfo.getExtraCertsP7b());
        result.setInfo((Object)repPkiMessage);
        logger.info("RA\u6062\u590d\u5904\u7406 ========== \u3010\u7ed3\u675f\u3011");
        return result;
    }

    private PKIMessage getPkiMessage(PKIMessage pkiMessage) throws PKIMessageException {
        PKIMessage reqPkiMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (reqPkiMessage == null) {
            String errMsg = "RA\u6062\u590d\u5904\u7406========== No pkiMessage response message.";
            logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        return reqPkiMessage;
    }

    private PKIHeader getPkiHeader(PKIMessage reqPkiMessage) throws PKIMessageException {
        PKIHeader header = null;
        logger.info("RA\u6062\u590d\u5904\u7406 ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        try {
            header = reqPkiMessage.getHeader();
        }
        catch (Exception e) {
            logger.info("RA\u6062\u590d\u5904\u7406 opani========", (Throwable)e);
        }
        if (header == null) {
            String errMsg = "RA\u6062\u590d\u5904\u7406========== No header in response message.";
            logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        return header;
    }

    private long getSignRequestId(PKIMessage reqPkiMessage) {
        CertReqMessages ir = (CertReqMessages)reqPkiMessage.getBody().getContent();
        return ir.toCertReqMsgArray()[0].getCertReq().getCertReqId().getValue().longValue();
    }
}

