/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.aop;

import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.commonenum.ReqAttributeEnum;
import com.xdja.pki.ra.core.util.SignUtils;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.params.CheckUtils;
import com.xdja.pki.ra.manager.dao.CustomerDao;
import com.xdja.pki.ra.openapi.bean.SystemFlagBean;
import com.xdja.pki.ra.service.manager.certapply.bean.ErrorMsg;
import java.io.IOException;
import java.io.Reader;
import java.io.StringWriter;
import java.net.URLDecoder;
import java.security.PublicKey;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.util.ContentCachingRequestWrapper;

@Component
@Aspect
public class RaSdkInterceptAspect {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private CustomerDao customerDao;
    @Value(value="${ra-openapi.response.overtime}")
    private String OverTime;

    @Pointcut(value="@annotation(SignIntercep)")
    public void pointcut() {
    }

    @Around(value="pointcut()")
    public Object signIntercept(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        this.logger.debug("a-openapi-normal---------------------\u5f00\u59cb\u62e6\u622a\u5230RA-SDK\u7684\u8bf7\u6c42");
        ServletRequestAttributes servletRequestAttributes = (ServletRequestAttributes)RequestContextHolder.currentRequestAttributes();
        HttpServletRequest request = servletRequestAttributes.getRequest();
        HttpServletResponse response = servletRequestAttributes.getResponse();
        HttpServletRequestWrapper httpRequestWrapper = (HttpServletRequestWrapper)request;
        ContentCachingRequestWrapper requestWrapper = !(httpRequestWrapper instanceof ContentCachingRequestWrapper) ? (ContentCachingRequestWrapper)httpRequestWrapper.getRequest() : (ContentCachingRequestWrapper)httpRequestWrapper;
        String body = new String(requestWrapper.getContentAsByteArray());
        String systemFlag = request.getHeader(ReqAttributeEnum.SYSTEM_FLAG.name);
        String signValue = request.getHeader(ReqAttributeEnum.SING_VALUE.name);
        String timestamp = request.getHeader(ReqAttributeEnum.TIMESTAMP.name);
        String signAlg = request.getHeader(ReqAttributeEnum.SIGN_ALG.name);
        String signSn = request.getHeader(ReqAttributeEnum.SIGN_SN.name);
        String url = URLDecoder.decode(request.getRequestURI(), "UTF-8");
        this.logger.debug("\u8bf7\u6c42\u5730\u5740,url:[{}]", (Object)url);
        this.logger.debug("\u9a8c\u7b7e\u53c2\u6570\uff0csystemFlag:[{}],sign:[{}],timestamp:[{}],signAlg:[{}],signSn:[{}]", new Object[]{systemFlag, signValue, timestamp, signAlg, signSn});
        this.logger.debug("\u8bf7\u6c42body:[{}]", (Object)body);
        if (!CheckUtils.checkParamsNotNull((Object[])new Object[]{systemFlag, signValue, timestamp})) {
            this.logger.error("\u7f3a\u5c11\u5fc5\u8981\u53c2\u6570");
            response.setStatus(400);
            return this.getErrorResult(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        if (this.checkOverTime(request.getHeader(ReqAttributeEnum.TIMESTAMP.name))) {
            this.logger.error("sdk\u54cd\u5e94\u8d85\u65f6");
            response.setStatus(400);
            return this.getErrorResult(ErrorEnum.RA_SDK_REQUEST_TIMEOUT);
        }
        String source = url.replaceFirst("/ra-openapi", "") + body;
        String certStr = null;
        try {
            certStr = this.customerDao.getSysCertBySystemFlagAndSn(systemFlag, signSn);
        }
        catch (Exception e) {
            this.logger.error("\u6b63\u5e38\u72b6\u6001\u7684\u8be5\u7cfb\u7edf\u8bc1\u4e66\u4e0d\u5b58\u5728=========\uff1asystemFlag:[{}],signSn:[{}]", (Object)systemFlag, (Object)signSn);
            this.logger.error("\u6b63\u5e38\u72b6\u6001\u7684\u8be5\u7cfb\u7edf\u8bc1\u4e66\u4e0d\u5b58\u5728", (Throwable)e);
            response.setStatus(400);
            return this.getErrorResult(ErrorEnum.NORMAL_CERT_IS_NOT_EXIST);
        }
        PublicKey key = CertUtils.getCertFromStr((String)certStr).getPublicKey();
        if (!SignUtils.verify((String)signAlg, (PublicKey)key, (String)source, (String)signValue)) {
            this.logger.error("sdk\u8bf7\u6c42\u9a8c\u7b7e\u5931\u8d25");
            this.logger.debug("signSn:[{}]", (Object)signSn);
            this.logger.debug("source:[{}]", (Object)source);
            this.logger.debug("sign:[{}]", (Object)signValue);
            response.setStatus(400);
            return this.getErrorResult(ErrorEnum.REQUEST_BODY_AND_SIGN_BODY_DISACCORD);
        }
        SystemFlagBean systemFlagBean = new SystemFlagBean();
        systemFlagBean.setSystemFlag(systemFlag);
        Object[] args = proceedingJoinPoint.getArgs();
        for (int i = 0; i < args.length; ++i) {
            if (null == args[i] || args[i].getClass() != SystemFlagBean.class) continue;
            args[i] = systemFlagBean;
        }
        return proceedingJoinPoint.proceed(args);
    }

    public static void main(String[] args) throws Exception {
        String certStr = "-----BEGIN CERTIFICATE-----\nMIIDFTCCArqgAwIBAgIEEAAAVzAKBggqgRzPVQGDdTA2MQswCQYDVQQGEwJDTjEXMBUGA1UECgwOQ2FzY29UZXN0U3ViQ2ExDjAMBgNVBAMMBXN1YkNhMB4XDTE5MTIyNzA4NTIwMVoXDTQ5MTIwOTA4NTIwMVowRzELMAkGA1UEBhMCQ04xFzAVBgNVBAoMDkNhc2NvVGVzdFN1YkNhMRAwDgYDVQQDDAdjYXNjb1JhMQ0wCwYDVQQDDAR0ZXN0MFkwEwYHKoZIzj0CAQYIKoEcz1UBgi0DQgAEpQbDwI+iNJTDhy4m+avytsJuWDREOrgT3B3bcU7CGr1MZaNW+O1bEQR8jFvBHx6rMSMEXxG76TvtcrG7CMyzVaOCAaMwggGfMA4GA1UdDwEB/wQEAwIDODCBgAYDVR0uBHkwdzB1oHOgcYZvbGRhcDovLzExLjEyLjEwNy4xMDA6Mzg5L089Q2FzY29UZXN0Q0EsQz1DTi9jbj1jcmwwLG89c3ViQ2FDUkwsTz1DYXNjb1Rlc3RTdWJDYSxDPUNOP2RlbHRhUmV2b2NhdGlvbkxpc3Q7YmluYXJ5MGIGA1UdIwRbMFmAFDm5j5xeORqC9a8JXnE9PgGg4T3coTukOTA3MQswCQYDVQQGEwJDTjEUMBIGA1UECgwLQ2FzY29UZXN0Q0ExEjAQBgNVBAMMCWNhc2NvUm9vdIIEEAAADTCBhgYDVR0fBH8wfTB7oHmgd4Z1bGRhcDovLzExLjEyLjEwNy4xMDA6Mzg5L089Q2FzY29UZXN0Q0EsQz1DTi9jbj1jcmwwLG89c3ViQ2FDUkwsTz1DYXNjb1Rlc3RTdWJDYSxDPUNOP2NlcnRpZmljYXRlUmV2b2NhdGlvbkxpc3Q7YmluYXJ5MB0GA1UdDgQWBBSmbACtC8srsgw6myJAJbzWVsPJyDAKBggqgRzPVQGDdQNJADBGAiEA1ZSIxxNZNPwGGYmLuprYgYQEpsSsf9+j7Bo7l2Qs4qsCIQD6TNQjRFiaqVnMONGRL+zO+eG9OWhei9fiDku9Q1yrOg==\n-----END CERTIFICATE-----";
        String signAlg = "1.2.156.10197.1.501";
        PublicKey key = CertUtils.getCertFromStr((String)certStr).getPublicKey();
        String sourceData = "/v1/ra-openapi/user/1{\"personUser\":{\"licenseNumber\":\"TldTest\",\"licenseType\":1,\"personName\":\"jiekouTest\",\"sex\":1,\"status\":0}}";
        String signValue = "MEYCIQDNef3Y4lvs6/OFOp+DY0/Z2W/mXEf7O3ud6BfVTTiL8gIhAIm6BlEoIwEkGyBgF6ci7M+LGZRZRRtFKV2sz5PpOJKr";
        boolean verity = SignUtils.verify((String)signAlg, (PublicKey)key, (String)sourceData, (String)signValue);
        System.out.println(verity);
    }

    private boolean checkOverTime(String timeStamp) {
        long overTime;
        long reqTime = Long.parseLong(timeStamp);
        long currentTime = System.currentTimeMillis();
        return currentTime - reqTime > (overTime = (long)Integer.parseInt(this.OverTime) * 60L * 1000L);
    }

    private String read(Reader reader) {
        try {
            int n;
            StringWriter writer = new StringWriter();
            char[] buffer = new char[4096];
            while (-1 != (n = reader.read(buffer))) {
                writer.write(buffer, 0, n);
            }
            return writer.toString();
        }
        catch (IOException e) {
            throw new IllegalStateException("\u83b7\u53d6body\u5b57\u7b26\u4e32\u5931\u8d25", e);
        }
    }

    private Object getErrorResult(ErrorEnum errorEnum) {
        ErrorMsg errorMsg = new ErrorMsg();
        errorMsg.setErrorCode(Integer.valueOf(errorEnum.code));
        errorMsg.setErrorMsg(errorEnum.desc);
        return errorMsg;
    }
}

