/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal;

import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.openapi.aop.SignIntercep;
import com.xdja.pki.ra.openapi.bean.SystemFlagBean;
import com.xdja.pki.ra.openapi.normal.Utils.CheckParam;
import com.xdja.pki.ra.service.manager.usercertmanager.UserCertManagerService;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserCertManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private UserCertManagerService userCertManagerService;

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/cert/{userType}/{identType}/{identNumber}"}, method={RequestMethod.GET})
    public Object userCertQuery(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u67e5\u8be2\u7528\u6237\u8bc1\u4e66");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570userType:[{}]", (Object)userType);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570identType:[{}]", (Object)identType);
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570identNumber:[{}]", (Object)identNumber);
        Result result = CheckParam.checkParameter((Integer)userType, (Integer)identType, (String)identNumber);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.userCertManagerService.getUserCertInfoList(userType, identType, identNumber, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/cert/{certSn}"}, method={RequestMethod.GET})
    public Object userCertDetailQuery(@PathVariable String certSn, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u67e5\u8be2\u7528\u6237\u8bc1\u4e66\u8be6\u60c5");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570certSn:[{}]", (Object)certSn);
        Result result = this.userCertManagerService.getUserCertBaseInfo(certSn, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/cert/file/{certSn}"}, method={RequestMethod.GET})
    public Object userCertDownload(@PathVariable String certSn, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u67e5\u8be2\u7528\u6237\u53cc\u8bc1\u4e66\u4e0b\u8f7d");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570certSn:[{}]", (Object)certSn);
        Result result = this.userCertManagerService.downLoadUserCertFile(certSn, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"v1/ra-openapi/cert/base64/{certSn}"})
    public Object getUserCert(@PathVariable String certSn, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u83b7\u53d6base64\u683c\u5f0f\u8bc1\u4e66\u63a5\u53e3");
        this.logger.debug("\u8bf7\u6c42\u53c2\u6570certSn:[{}]", (Object)certSn);
        Result result = this.userCertManagerService.getUserCert(certSn, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }
}

