/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.normal;

import com.xdja.pki.core.utils.TimeMonitor;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.openapi.aop.SignIntercep;
import com.xdja.pki.ra.openapi.bean.SystemFlagBean;
import com.xdja.pki.ra.openapi.normal.Utils.CheckParam;
import com.xdja.pki.ra.service.manager.baseuser.BaseUserService;
import com.xdja.pki.ra.service.manager.baseuser.bean.UserInfo;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class UserManagerController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private BaseUserService baseUserService;

    @RequestMapping(value={"v1/ra-openapi/trustCertChain"}, method={RequestMethod.GET})
    public Object testConnect() {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u9a8c\u8bc1\u4fe1\u4efb\u8bc1\u4e66\u94fe");
        return Result.success((Object)"success");
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/user/{userType}"}, method={RequestMethod.POST})
    public Object userRegister(@PathVariable Integer userType, @RequestBody UserInfo userInfo, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7528\u6237\u6ce8\u518c");
        TimeMonitor monitor = new TimeMonitor("Controller\u5c42 \u7528\u6237\u6ce8\u518c");
        monitor.start("\u53c2\u6570\u6821\u9a8c");
        Result result = CheckParam.requestParamCheck((Integer)userType, (UserInfo)userInfo, (boolean)false);
        monitor.stop();
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        monitor.start("service \u4e1a\u52a1\u6267\u884c");
        result = this.baseUserService.userRegister(userType, userInfo, systemFlagBean.getSystemFlag());
        monitor.stop();
        monitor.prettyPrint();
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    public Object batchUserRegist(List<UserInfo> userInfoList) {
        return null;
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/user/{userType}/{identType}/{identNumber}"}, method={RequestMethod.GET})
    public Object getUserInfo(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7528\u6237\u67e5\u8be2");
        this.logger.debug("\u7528\u6237\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1auserType:[{}],identType:[{}],identNumber:[{}]", new Object[]{userType, identType, identNumber});
        Result result = CheckParam.checkParameter((Integer)userType, (Integer)identType, (String)identNumber);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.baseUserService.userQuery(userType, identType, identNumber, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/user/{signSn}"})
    public Object getUserInfo(@PathVariable String signSn, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7528\u6237\u67e5\u8be2");
        this.logger.debug("\u7528\u6237\u67e5\u8be2\u8bf7\u6c42\u53c2\u6570\uff1asignSn:[{}]", (Object)signSn);
        Result result = this.baseUserService.userQuery(signSn, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/user/{userType}/{identType}/{identNumber}"}, method={RequestMethod.PUT})
    public Object updateUserInfo(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, @RequestBody UserInfo userInfo, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u8c03\u7528\u7528\u6237\u66f4\u65b0");
        this.logger.debug("\u7528\u6237\u66f4\u65b0\u8bf7\u6c42\u53c2\u6570\uff1auserType:[{}],identType:[{}],identNumber:[{}]", new Object[]{userType, identType, identNumber});
        this.logger.debug("\u7528\u6237\u66f4\u65b0\u8bf7\u6c42\u53c2\u6570\uff1auserInfo[{}]", (Object)userInfo);
        Result result = CheckParam.checkParameter((Integer)userType, (Integer)identType, (String)identNumber);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = CheckParam.requestParamCheck((Integer)userType, (UserInfo)userInfo, (boolean)true);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.baseUserService.userUpdate(userType, identType, identNumber, userInfo, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    @SignIntercep
    @RequestMapping(value={"/v1/ra-openapi/user/{userType}/{identType}/{identNumber}/{userStatus}"}, method={RequestMethod.PUT})
    public Object updateUserInfo(@PathVariable Integer userType, @PathVariable Integer identType, @PathVariable String identNumber, @PathVariable Integer userStatus, SystemFlagBean systemFlagBean, HttpServletResponse resp) {
        this.logger.info("ra-openapi-normal---------------------\u5f00\u59cb\u4fee\u6539\u7528\u6237\u72b6\u6001");
        this.logger.debug("\u4fee\u6539\u7528\u6237\u72b6\u6001\u8bf7\u6c42\u53c2\u6570\uff1auserType:[{}],identType:[{}],identNumber:[{}],userStatus:[{}]", new Object[]{userType, identType, identNumber, userStatus});
        Result result = CheckParam.CheckParameter((Integer)userType, (Integer)identType, (String)identNumber, (Integer)userStatus);
        if (!result.isSuccess()) {
            return CheckParam.resultSort((Result)result, (HttpServletResponse)resp);
        }
        result = this.baseUserService.updateUserStatus(userType, identType, identNumber, userStatus, systemFlagBean.getSystemFlag());
        return CheckParam.resultDeal((Result)result, (HttpServletResponse)resp);
    }

    public Object userInfoCheck() {
        return null;
    }
}

