/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.common;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x500.X500Name;

public class IssuerAndSubject
extends ASN1Object {
    private X500Name issuerName;
    private X500Name subjectName;

    public IssuerAndSubject(X500Name issuerName, X500Name subjectName) {
        this.issuerName = issuerName;
        this.subjectName = subjectName;
    }

    public static IssuerAndSubject getInstance(Object obj) {
        if (obj instanceof IssuerAndSubject) {
            return (IssuerAndSubject)((Object)obj);
        }
        if (obj != null) {
            return new IssuerAndSubject(ASN1Sequence.getInstance((Object)obj));
        }
        return null;
    }

    public IssuerAndSubject(ASN1Sequence seq) {
        this.issuerName = X500Name.getInstance((Object)seq.getObjectAt(0));
        this.subjectName = X500Name.getInstance((Object)seq.getObjectAt(1));
    }

    public X500Name getIssuerName() {
        return this.issuerName;
    }

    public X500Name getSubjectName() {
        return this.subjectName;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)this.issuerName);
        v.add((ASN1Encodable)this.subjectName);
        return new DERSequence(v);
    }
}

