/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.handler;

import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.openapi.core.handler.IScepCaMessageHandler;
import com.xdja.pki.ra.openapi.scep.common.P7bUtils;
import com.xdja.pki.ra.service.manager.scep.ScepCertService;
import java.security.cert.X509Certificate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="getCaCertScepMessageHandler")
public class GetCaCertScepMessageHandler
implements IScepCaMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ScepCertService scepCertService;

    public Result handleMessage() {
        Result result = new Result();
        try {
            result = this.scepCertService.getRaCert(2);
            if (!result.isSuccess()) {
                this.logger.info("\u83b7\u53d6RA\u7b7e\u540d\u8bc1\u4e66\u5931\u8d25 " + JsonUtils.object2Json((Object)result));
                return result;
            }
            String raCertP7b = (String)result.getInfo();
            List<X509Certificate> certListFromP7b = P7bUtils.resolveCertChain(raCertP7b);
            if (!CommonVariable.getKeyAlgName().equals("SM2")) {
                result = this.scepCertService.getRaCert(3);
                if (!result.isSuccess()) {
                    this.logger.info("\u83b7\u53d6RA\u52a0\u5bc6\u8bc1\u4e66\u5931\u8d25 " + JsonUtils.object2Json((Object)result));
                    return result;
                }
                String raEncCert = (String)result.getInfo();
                X509Certificate encCert = CertUtils.getCertFromStr((String)raEncCert);
                certListFromP7b.add(encCert);
            }
            String certChainByCerts = P7bUtils.createCertChainByCerts(certListFromP7b);
            result.setInfo((Object)certChainByCerts);
            result.setContentType("application/x-509-ca-ra-cert");
            this.logger.info("\u670d\u52a1\u7aef\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\uff1a" + certChainByCerts);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u5185\u90e8\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CREATE_CERT_REP_STRUCTURE_EXCEPTION);
            return result;
        }
    }
}

