/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.handler;

import com.xdja.ca.utils.RFC4519StyleUpperCase;
import com.xdja.ca.utils.SdkP10Utils;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.openapi.core.handler.IScepMessageHandler;
import com.xdja.pki.ra.openapi.core.scep.CertRepUtils;
import com.xdja.pki.ra.openapi.scep.common.P7bUtils;
import com.xdja.pki.ra.service.manager.scep.ScepCertService;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component(value="getCertScepMessageHandler")
public class GetCertScepMessageHandler
implements IScepMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    ScepCertService scepCertService;

    public Result handleMessage(byte[] sourceData, byte[] transactionId, byte[] senderNonce, X509Certificate selfCert) {
        Result result = new Result();
        this.logger.info("SCEP\u83b7\u53d6\u8bc1\u4e66\u6d88\u606f\u5904\u7406\u7c7b\u63a5\u6536\u5230\u7684\u660e\u6587\u8bf7\u6c42\u6570\u636e::" + Base64.toBase64String((byte[])sourceData));
        try {
            IssuerAndSerialNumber issuerAndSerialNumber = IssuerAndSerialNumber.getInstance((Object)sourceData);
            this.logger.info("\u670d\u52a1\u7aef\u89e3\u6790\u83b7\u53d6\u5ba2\u6237\u7aef\u8bc1\u4e66\u67e5\u8be2\u5bf9\u8c61\uff1a" + Base64.toBase64String((byte[])issuerAndSerialNumber.getEncoded()));
            result.setInfo((Object)new Date());
            String sn = issuerAndSerialNumber.getSerialNumber().getValue().toString(16);
            X500Name issuerName = X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)issuerAndSerialNumber.getName());
            String issuerDn = SdkP10Utils.reverseDnSeq((X500Name)issuerName);
            result = this.scepCertService.getScepCert(sn, issuerDn);
            SignedData repSignedData = null;
            X509Certificate serviceCert = CommonVariable.getRaServiceCert();
            if (result.isSuccess() && result.getInfo() != null) {
                Map map = (Map)result.getInfo();
                String signCert = (String)map.get("signCert");
                X509Certificate sign = CertUtils.getCertFromStr((String)signCert);
                X509Certificate enc = null;
                if (null != map.get("encCert")) {
                    String encCert = (String)map.get("encCert");
                    enc = CertUtils.getCertFromStr((String)encCert);
                }
                List<X509Certificate> caTrust = null;
                if (null != map.get("CACert")) {
                    String userCACert = (String)map.get("CACert");
                    caTrust = P7bUtils.resolveCertChain(userCACert);
                }
                SignedData sourceRepSignedData = CertRepUtils.createSourceRepSignedData((X509Certificate)sign, (X509Certificate)enc, null, null, null, caTrust);
                ContentInfo sourceContentInfo = new ContentInfo(PKCSObjectIdentifiers.signedData, (ASN1Encodable)sourceRepSignedData);
                repSignedData = CertRepUtils.createRepSignedData((byte[])sourceContentInfo.getEncoded("DL"), (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"0", (byte[])senderNonce, (X509Certificate)selfCert, null);
            } else {
                int failInfoByErrorCode = CertRepUtils.getFailInfoByErrorCode((int)result.getErrorBean().getErrCode());
                repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)"3", (String)"2", (byte[])senderNonce, (X509Certificate)selfCert, (Integer)failInfoByErrorCode);
            }
            ContentInfo contentInfo = CertRepUtils.createContentInfo((ASN1ObjectIdentifier)PKCSObjectIdentifiers.signedData, (ASN1Encodable)repSignedData);
            result.setContentType("application/x-pki-message");
            result.setInfo((Object)contentInfo);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6784\u5efa\u8fd4\u56de\u6570\u636e\u7ed3\u6784\u5185\u90e8\u5f02\u5e38", (Throwable)e);
            result.setError(ErrorEnum.CREATE_CERT_REP_STRUCTURE_EXCEPTION);
            return result;
        }
    }
}

