/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.scep.proxy;

import com.xdja.ca.asn1.DigestObjectIdentifiers;
import com.xdja.pki.core.json.JsonUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLBCCipherUtils;
import com.xdja.pki.gmssl.core.utils.GMSSLSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLECSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2EncryptUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM4ECBEncryptUtils;
import com.xdja.pki.ra.core.asn1.NISTObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.RsaObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.SM2ObjectIdentifiers;
import com.xdja.pki.ra.core.asn1.SymmetryObjectIdentifiers;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.DnUtil;
import com.xdja.pki.ra.core.util.cert.HsmUtils;
import com.xdja.pki.ra.core.util.spring.SpringUtils;
import com.xdja.pki.ra.openapi.core.RaProxyBeanApi;
import com.xdja.pki.ra.openapi.core.handler.IScepMessageHandler;
import com.xdja.pki.ra.openapi.core.scep.CertRepUtils;
import com.xdja.pki.ra.openapi.core.scep.SCEPObjectIdentifiers;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import javax.naming.NamingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.cms.Attribute;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.EnvelopedData;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.pkcs.ContentInfo;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.SignedData;
import org.bouncycastle.asn1.pkcs.SignerInfo;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component(value="scepProxyBeanImpl")
public class SecpProxyBeanImpl
implements RaProxyBeanApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Result dispatch(byte[] decodeOpenApiMessageByte, Integer type) throws Exception {
        Result result = new Result();
        this.logger.info("\u63a5\u6536\u5230SCEP\u63a5\u53e3\u8bf7\u6c42\u7684\u6570\u636e\u539f\u6587 \u7ecfBase64\u7f16\u7801 ====:{}", (Object)Base64.toBase64String((byte[])decodeOpenApiMessageByte));
        ContentInfo contentInfo = null;
        try {
            contentInfo = ContentInfo.getInstance((Object)decodeOpenApiMessageByte);
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u6536\u5230\u7684\u6d88\u606f\u65e0\u6cd5\u8f6c\u6362\u4e3aContentInfo", (Throwable)e);
            result.setError(ErrorEnum.SCEP_PKCS7_STRUCTURE_CONVERT_FAILURE);
            return result;
        }
        SignedData signedData = null;
        try {
            signedData = SignedData.getInstance((Object)contentInfo.getContent());
        }
        catch (Exception e) {
            this.logger.error("\u63a5\u6536\u5230\u7684\u6d88\u606f\u65e0\u6cd5\u8f6c\u6362\u4e3aSignedData", (Throwable)e);
            result.setError(ErrorEnum.SCEP_PKCS7_STRUCTURE_CONVERT_FAILURE);
            return result;
        }
        ASN1Set certificates = signedData.getCertificates();
        if (certificates == null || certificates.size() == 0) {
            this.logger.error("\u5ba2\u6237\u7aef\u672a\u5305\u542b\u81ea\u7b7e\u540d\u8bc1\u4e66");
            result.setError(ErrorEnum.REQ_DATA_NOT_CONTAIN_SELF_CERT);
            return result;
        }
        DERSequence selfCertSequence = (DERSequence)certificates.getObjectAt(0);
        X509Certificate selfCert = CertUtils.getCertFromStr((String)Base64.toBase64String((byte[])selfCertSequence.getEncoded()));
        ASN1Set signerInfos = signedData.getSignerInfos();
        if (signerInfos == null || signerInfos.size() == 0) {
            this.logger.error("\u5ba2\u6237\u7aef\u672a\u5305\u542b\u7b7e\u540d\u8005\u4fe1\u606f");
            result.setError(ErrorEnum.REQ_DATA_NOT_CONTAIN_SIGNER_INFO);
            return result;
        }
        ContentInfo signedDataContentInfo = signedData.getContentInfo();
        SignerInfo signerInfo = SignerInfo.getInstance((Object)signerInfos.getObjectAt(0));
        ASN1OctetString signedDataInfo = signerInfo.getEncryptedDigest();
        ASN1Set authenticatedAttributes = signerInfo.getAuthenticatedAttributes();
        if (authenticatedAttributes == null || authenticatedAttributes.size() == 0) {
            this.logger.error("\u5ba2\u6237\u7aef\u672a\u5305\u542b\u5f85\u7b7e\u540d\u6269\u5c55\u5c5e\u6027\u4fe1\u606f");
            result.setError(ErrorEnum.REQ_DATA_NOT_CONTAIN_ATTR_BY_SIGN);
            return result;
        }
        AlgorithmIdentifier digestAlgorithm = signerInfo.getDigestAlgorithm();
        if (digestAlgorithm == null) {
            this.logger.error("\u5ba2\u6237\u7aef\u672a\u5305\u542b\u6458\u8981\u7b97\u6cd5\u4fe1\u606f");
            result.setError(ErrorEnum.REQ_DATA_NOT_CONTAIN_DIGEST_ALG);
            return result;
        }
        AlgorithmIdentifier digestEncryptionAlgorithm = signerInfo.getDigestEncryptionAlgorithm();
        if (digestEncryptionAlgorithm == null) {
            this.logger.error("\u5ba2\u6237\u7aef\u672a\u5305\u542b\u52a0\u5bc6\u7b97\u6cd5\u6027\u4fe1\u606f");
            result.setError(ErrorEnum.REQ_DATA_NOT_CONTAIN_ENC_ALG);
            return result;
        }
        boolean verifyResult = false;
        String sigAlgName = selfCert.getSigAlgName();
        this.logger.info("\u9a8c\u7b7e\u516c\u94a5:{}", (Object)selfCert.getPublicKey());
        this.logger.info("\u5f85\u9a8c\u8bc1\u7b7e\u540d\u539f\u6587:{}", (Object)Base64.toBase64String((byte[])signedDataContentInfo.getEncoded()));
        this.logger.info("\u5f85\u9a8c\u8bc1\u7b7e\u540d\u539f\u6587:{}", (Object)Base64.toBase64String((byte[])signedDataContentInfo.getEncoded("DER")));
        this.logger.info("\u8bf7\u6c42\u4e2d\u7684\u7b7e\u540d\u540e\u7684\u6570\u636e:{}", (Object)Base64.toBase64String((byte[])signedDataInfo.getOctets()));
        if ("sha1withrsa".equalsIgnoreCase(sigAlgName) || "sha256withrsa".equalsIgnoreCase(sigAlgName) || "sha-1withrsa".equalsIgnoreCase(sigAlgName)) {
            if (digestAlgorithm.getAlgorithm().getId().equalsIgnoreCase(DigestObjectIdentifiers.sha1.getId()) && digestEncryptionAlgorithm.getAlgorithm().getId().equalsIgnoreCase(RsaObjectIdentifiers.rsaEncryption.getId())) {
                try {
                    verifyResult = GMSSLRSASignUtils.verifyByBC((String)"sha1withrsa", (PublicKey)selfCert.getPublicKey(), (byte[])signedDataContentInfo.getEncoded("DER"), (byte[])signedDataInfo.getOctets());
                }
                catch (Exception e) {
                    this.logger.error("RSA\u7b97\u6cd5\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
                    result.setError(ErrorEnum.VERIFY_SIGN_DATA_FAILURE);
                    return result;
                }
            }
            if (digestAlgorithm.getAlgorithm().getId().equalsIgnoreCase(DigestObjectIdentifiers.sha256.getId()) && digestEncryptionAlgorithm.getAlgorithm().getId().equalsIgnoreCase(RsaObjectIdentifiers.rsaEncryption.getId())) {
                try {
                    verifyResult = GMSSLRSASignUtils.verifyByBC((String)"sha256withrsa", (PublicKey)selfCert.getPublicKey(), (byte[])signedDataContentInfo.getEncoded("DER"), (byte[])signedDataInfo.getOctets());
                }
                catch (Exception e) {
                    this.logger.error("RSA\u7b97\u6cd5\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
                    result.setError(ErrorEnum.VERIFY_SIGN_DATA_FAILURE);
                    return result;
                }
            } else {
                this.logger.info("SHA256WITHERSA\u6216SHA1WITHRSA\u4e2d\u7684\u6458\u8981\u7b97\u6cd5\u6216\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u652f\u6301");
                result.setError(ErrorEnum.CURRENT_ALG_NOT_SUPPORT);
                return result;
            }
        }
        if ("sm3withsm2".equalsIgnoreCase(sigAlgName)) {
            if (digestAlgorithm.getAlgorithm().getId().equalsIgnoreCase(DigestObjectIdentifiers.sm3.getId()) && digestEncryptionAlgorithm.getAlgorithm().getId().equalsIgnoreCase(SM2ObjectIdentifiers.sm2256_sign.getId())) {
                try {
                    verifyResult = GMSSLECSignUtils.verifyByBC((PublicKey)selfCert.getPublicKey(), (byte[])signedDataContentInfo.getEncoded("DER"), (byte[])signedDataInfo.getOctets(), (String)"SM3WITHSM2");
                }
                catch (Exception e) {
                    this.logger.error("\u56fd\u5bc6\u7b97\u6cd5\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
                    result.setError(ErrorEnum.VERIFY_SIGN_DATA_FAILURE);
                    return result;
                }
            } else {
                this.logger.info("SM3WITHSM2\u4e2d\u7684\u6458\u8981\u7b97\u6cd5\u6216\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u652f\u6301");
                result.setError(ErrorEnum.CURRENT_ALG_NOT_SUPPORT);
                return result;
            }
        }
        if (!"SHA256WITHECDSA".equalsIgnoreCase(sigAlgName)) {
            this.logger.info("\u4e0d\u652f\u6301\u7684\u7b7e\u540d\u7b97\u6cd5");
            result.setError(ErrorEnum.CURRENT_ALG_NOT_SUPPORT);
            return result;
        }
        if (digestAlgorithm.getAlgorithm().getId().equalsIgnoreCase(DigestObjectIdentifiers.sha256.getId()) && digestEncryptionAlgorithm.getAlgorithm().getId().equalsIgnoreCase(NISTObjectIdentifiers.ecies.getId())) {
            try {
                verifyResult = GMSSLSignUtils.verifySignature((String)"SHA256WITHECDSA", (PublicKey)selfCert.getPublicKey(), (byte[])signedDataContentInfo.getEncoded("DER"), (byte[])signedDataInfo.getOctets());
            }
            catch (Exception e) {
                this.logger.error("NIST\u7b97\u6cd5\u9a8c\u7b7e\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.VERIFY_SIGN_DATA_FAILURE);
                return result;
            }
        } else {
            this.logger.info("SHA256WITHECDSA\u4e2d\u7684\u6458\u8981\u7b97\u6cd5\u6216\u52a0\u5bc6\u7b97\u6cd5\u4e0d\u652f\u6301");
            result.setError(ErrorEnum.CURRENT_ALG_NOT_SUPPORT);
            return result;
        }
        if (!verifyResult) {
            this.logger.info("\u5bf9\u5ba2\u6237\u7aef\u8bf7\u6c42\u7ed3\u6784\u4f53\u9a8c\u7b7e\u5931\u8d25");
            result.setError(ErrorEnum.VERIFY_SIGN_DATA_FAILURE);
            return result;
        }
        byte[] transactionId = null;
        byte[] senderNonce = null;
        IScepMessageHandler iScepMessageHandler = null;
        for (int i = 0; i < authenticatedAttributes.size(); ++i) {
            Attribute attribute = Attribute.getInstance((Object)authenticatedAttributes.getObjectAt(i));
            ASN1ObjectIdentifier attrType = attribute.getAttrType();
            if (attrType.getId().equals(SCEPObjectIdentifiers.id_messageType.getId())) {
                DERPrintableString messageType = (DERPrintableString)attribute.getAttrValues().getObjectAt(0);
                if (messageType.getString().equals("19")) {
                    iScepMessageHandler = (IScepMessageHandler)SpringUtils.getBean((String)"certReqScepMessageHandler");
                    continue;
                }
                if (messageType.getString().equals("20")) {
                    iScepMessageHandler = (IScepMessageHandler)SpringUtils.getBean((String)"getCertInitScepMessageHandler");
                    continue;
                }
                if (messageType.getString().equals("21")) {
                    iScepMessageHandler = (IScepMessageHandler)SpringUtils.getBean((String)"getCertScepMessageHandler");
                    continue;
                }
                if (!messageType.getString().equals("22")) {
                    this.logger.info("SCEP\u6d88\u606f\u7c7b\u578b\u4e0d\u652f\u6301");
                    result.setError(ErrorEnum.SCEP_MESSAGE_TYPE_NOT_SUPPORT);
                    return result;
                }
                iScepMessageHandler = (IScepMessageHandler)SpringUtils.getBean((String)"getCrlScepMessageHandler");
                continue;
            }
            if (attrType.getId().equals(SCEPObjectIdentifiers.id_transId.getId())) {
                DEROctetString transactionIdStr = (DEROctetString)attribute.getAttrValues().getObjectAt(0);
                transactionId = transactionIdStr.getEncoded();
                continue;
            }
            if (!attrType.getId().equals(SCEPObjectIdentifiers.id_senderNonce.getId())) continue;
            DEROctetString senderNonceStr = (DEROctetString)attribute.getAttrValues().getObjectAt(0);
            senderNonce = senderNonceStr.getEncoded();
        }
        Result sourceDataResult = this.getReqSourceData(signedDataContentInfo);
        if (!sourceDataResult.isSuccess()) {
            return sourceDataResult;
        }
        if (iScepMessageHandler != null && transactionId != null && senderNonce != null) {
            if (null != sourceDataResult.getInfo()) {
                return iScepMessageHandler.handleMessage((byte[])sourceDataResult.getInfo(), transactionId, senderNonce, selfCert);
            }
            this.logger.info("\u7f3a\u5c11\u5fc5\u8981\u8bf7\u6c42\u53c2\u6570");
            result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
            return result;
        }
        this.logger.info("\u7f3a\u5c11\u5fc5\u8981\u8bf7\u6c42\u53c2\u6570");
        result.setError(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        return result;
    }

    private Result getReqSourceData(ContentInfo contentInfo) {
        byte[] sourceContent;
        Result result;
        block14: {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("contentInfo:[{}]", (Object)JsonUtils.object2Json((Object)contentInfo));
            }
            result = new Result();
            EnvelopedData envelopedData = null;
            try {
                if (!PKCSObjectIdentifiers.envelopedData.getId().equalsIgnoreCase(contentInfo.getContentType().getId())) {
                    this.logger.error("PKCS7\u7684\u6d88\u606f\u7c7b\u578b\u4e0d\u662fenvelopedData");
                    result.setError(ErrorEnum.PKCS7_CONTAIN_TYPE_NOT_ENVELOPED_DATA);
                    return result;
                }
                envelopedData = EnvelopedData.getInstance((Object)contentInfo.getContent());
            }
            catch (Exception e) {
                this.logger.error("\u83b7\u53d6\u8bf7\u6c42\u7684\u52a0\u5bc6\u7ed3\u6784\u4f53\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.SCEP_PKCS7_STRUCTURE_CONVERT_FAILURE);
                return result;
            }
            ASN1Set recipientInfos = envelopedData.getRecipientInfos();
            if (recipientInfos == null || recipientInfos.size() == 0) {
                this.logger.error("\u8bf7\u6c42\u6570\u636e\u4e2d\u672a\u5305\u542b\u63a5\u6536\u8005\u4fe1\u606f");
                result.setError(ErrorEnum.REQ_DATA_NOT_CONTAIN_RECIPIENT_INFO);
                return result;
            }
            KeyTransRecipientInfo recipientInfo = KeyTransRecipientInfo.getInstance((Object)recipientInfos.getObjectAt(0));
            AlgorithmIdentifier keyEncryptionAlgorithm = recipientInfo.getKeyEncryptionAlgorithm();
            ASN1OctetString encryptedKey = recipientInfo.getEncryptedKey();
            RecipientIdentifier recipientIdentifier = recipientInfo.getRecipientIdentifier();
            IssuerAndSerialNumber issuerAndSerialNumber = (IssuerAndSerialNumber)recipientIdentifier.getId();
            X509Certificate raServiceCert = CommonVariable.getRaServiceCert();
            ASN1Integer serialNumber = issuerAndSerialNumber.getSerialNumber();
            X500Name issuerName = DnUtil.getRFC4519X500Name((ASN1Encodable)issuerAndSerialNumber.getName());
            X500Name raCertDn = null;
            try {
                raCertDn = DnUtil.getRFC4519X500Name((String)CertUtils.getSubjectByX509Cert((X509Certificate)raServiceCert));
            }
            catch (NamingException e) {
                this.logger.error("\u83b7\u53d6\u8bc1\u4e66DN\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.GET_CERT_DN_EXCEPTION);
                return result;
            }
            String issueSn = serialNumber.getValue().toString(16);
            String raServerSn = raServiceCert.getSerialNumber().toString(16);
            if (!issueSn.equalsIgnoreCase(raServerSn) || !raCertDn.toString().equalsIgnoreCase(issuerName.toString())) {
                this.logger.error("\u5f53\u524d\u8bf7\u6c42\u7684\u7b7e\u53d1\u8005\u4e0d\u662f\u5f53\u524d\u7cfb\u7edf===\u671f\u671b\u7684\u670d\u52a1\u7aef\uff1a[{}] [{}] == \u5f53\u524d\u7684\u670d\u52a1\u7aef\uff1a[{}] [{}] ", new Object[]{issuerName.toString(), issueSn, raServerSn, raCertDn.toString()});
                result.setError(ErrorEnum.REQ_ISSUER_AND_SN_IS_NOT_CURRENT);
                return result;
            }
            byte[] symmetryKey = null;
            try {
                String decrypteData = null;
                this.logger.info("\u670d\u52a1\u7aef\u5f85\u89e3\u5bc6\u7684\u5bf9\u79f0\u5bc6\u94a5\u5bc6\u6587:{}", (Object)Base64.toBase64String((byte[])encryptedKey.getOctets()));
                decrypteData = 1 == CommonVariable.getIsHsm() && "SM2".equalsIgnoreCase(CommonVariable.getKeyAlgName()) ? GMSSLSM2EncryptUtils.decryptASN1ByYunhsm((int)CommonVariable.getKeyIndex(), (String)CommonVariable.getKeyPwd(), (String)Base64.toBase64String((byte[])encryptedKey.getOctets())) : HsmUtils.decrypteByBC((String)keyEncryptionAlgorithm.getAlgorithm().toString(), (byte[])CommonVariable.getRaSignPriKey(), (String)Base64.toBase64String((byte[])encryptedKey.getOctets()));
                symmetryKey = Base64.decode((String)decrypteData);
            }
            catch (Exception e) {
                this.logger.error("\u4f7f\u7528RA\u670d\u52a1\u5668\u7b7e\u540d\u8bc1\u4e66\u5bf9\u5e94\u7684\u79c1\u94a5\u89e3\u5bc6\u83b7\u53d6\u88ab\u52a0\u5bc6\u7684\u5bf9\u79f0\u5bc6\u94a5\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.DECRYPT_GET_SESSION_KEY_EXCEPTION);
                return result;
            }
            sourceContent = null;
            try {
                this.logger.info("\u670d\u52a1\u7aef\u89e3\u5bc6\u83b7\u53d6\u5230\u7684\u5bf9\u79f0\u5bc6\u94a5=============:{}", (Object)Base64.toBase64String((byte[])symmetryKey));
                EncryptedContentInfo encryptedContentInfo = envelopedData.getEncryptedContentInfo();
                this.logger.info("\u670d\u52a1\u7aef\u5f85\u89e3\u5bc6\u7684\u5bc6\u6587\u6570\u636e======:{}", (Object)Base64.toBase64String((byte[])encryptedContentInfo.getEncryptedContent().getEncoded()));
                AlgorithmIdentifier contentEncryptionAlgorithm = encryptedContentInfo.getContentEncryptionAlgorithm();
                if (contentEncryptionAlgorithm.getAlgorithm().getId().equals(SymmetryObjectIdentifiers.aes128ECB.getId())) {
                    sourceContent = GMSSLBCCipherUtils.symmetricECBDecrypt((String)"AES/ECB/PKCS5Padding", (byte[])symmetryKey, (byte[])encryptedContentInfo.getEncryptedContent().getOctets());
                    this.logger.info("AES \u89e3\u5bc6\u540e\u7684\u660e\u6587\u6570\u636e=====:{}", (Object)Base64.toBase64String((byte[])sourceContent));
                    break block14;
                }
                if (contentEncryptionAlgorithm.getAlgorithm().getId().equals(SymmetryObjectIdentifiers.sm4.getId())) {
                    sourceContent = GMSSLSM4ECBEncryptUtils.decryptByBCWithPKCS5Padding((byte[])symmetryKey, (byte[])encryptedContentInfo.getEncryptedContent().getOctets());
                    this.logger.info("SM4 \u89e3\u5bc6\u540e\u7684\u660e\u6587\u6570\u636e=====:{}", (Object)Base64.toBase64String((byte[])sourceContent));
                    break block14;
                }
                this.logger.info("\u4e0d\u652f\u6301\u8be5\u975e\u5bf9\u79f0\u52a0\u5bc6\u7b97\u6cd5:{}", (Object)contentEncryptionAlgorithm.getAlgorithm().toString());
                result.setError(ErrorEnum.CURRENT_ALG_NOT_SUPPORT);
                return result;
            }
            catch (Exception e) {
                this.logger.error("\u4f7f\u7528\u5bf9\u79f0\u5bc6\u94a5\u89e3\u5bc6\u83b7\u53d6\u5ba2\u6237\u7aef\u8bf7\u6c42\u6570\u636e\u5f02\u5e38", (Throwable)e);
                result.setError(ErrorEnum.DECRYPT_GET_SOURCE_DATA_EXCEPTION);
                return result;
            }
        }
        result.setInfo((Object)sourceContent);
        return result;
    }

    private ContentInfo createRespContentInfo(X509Certificate serviceCert, byte[] transactionId, String messageType, byte[] senderNonce, X509Certificate selfCert, int failInfo) throws Exception {
        Integer scepFailInfo = null;
        switch (failInfo) {
            case 0: {
                scepFailInfo = 0;
                break;
            }
            case 1: {
                scepFailInfo = 1;
                break;
            }
            case 2: {
                scepFailInfo = 2;
                break;
            }
            case 3: {
                scepFailInfo = 3;
                break;
            }
            case 4: {
                scepFailInfo = 4;
            }
        }
        SignedData repSignedData = CertRepUtils.createRepSignedData(null, (X509Certificate)serviceCert, (byte[])transactionId, (String)messageType, (String)"2", (byte[])senderNonce, (X509Certificate)selfCert, (Integer)scepFailInfo);
        ContentInfo contentInfo = CertRepUtils.createContentInfo((ASN1ObjectIdentifier)PKCSObjectIdentifiers.signedData, (ASN1Encodable)repSignedData);
        return contentInfo;
    }
}

