/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.tbox.cmp.handler;

import com.xdja.ca.cache.RedisClient;
import com.xdja.ca.service.CaSdkRedisCacheManagerService;
import com.xdja.ca.service.impl.CaSdkRedisCacheManagerServiceImpl;
import com.xdja.ca.utils.SdkCertUtils;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.openapi.core.BaseCMPInfo;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.cache.RedisCacheManagerService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

@Component(value="cmpConfirmReqHandler")
public class CmpConfirmReqHandler
implements ICmpMessageHandler {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    RedisCacheManagerService redisCacheManagerService;
    @Autowired
    private Pool<Jedis> jedisPool;
    private CaSdkRedisCacheManagerService caSdkRedisCacheManagerService;

    @Value(value="${transId.cache.expireTime}")
    private void init(int transIdExpireTime) {
        RedisClient redisClient = new RedisClient(this.jedisPool);
        this.caSdkRedisCacheManagerService = new CaSdkRedisCacheManagerServiceImpl(redisClient, transIdExpireTime);
    }

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException {
        BaseCMPInfo baseCMPInfo;
        this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage confirmPkiMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (confirmPkiMessage == null) {
            String errMsg = "RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== No pkiMessage response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        PKIHeader header = confirmPkiMessage.getHeader();
        if (header == null) {
            String errMsg = "RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        GeneralName sender = header.getSender();
        GeneralName recipient = header.getRecipient();
        byte[] tboxRecipNonce = new byte[]{};
        byte[] tboxSenderNonce = new byte[]{};
        String tboxTranID = null;
        AlgorithmIdentifier protectionAlg = null;
        try {
            tboxRecipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            tboxSenderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            tboxTranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        if (tboxRecipNonce == null || tboxSenderNonce == null || protectionAlg == null || StringUtils.isBlank((CharSequence)tboxTranID)) {
            String errMsg = "RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== \u786e\u8ba4\u6d88\u606f\u63a5\u53e3\u4e2d\u5fc5\u586b\u9879\u6709\u7a7a\u503c";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        String cmpInfo = this.caSdkRedisCacheManagerService.removeCaSdkCmpInfo(tboxTranID);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CASDK get transId:[{}] baseCMPInfo:[{}]", (Object)tboxTranID, (Object)cmpInfo);
        }
        if ((baseCMPInfo = (BaseCMPInfo)JsonUtils.json2Object((String)cmpInfo, BaseCMPInfo.class)) == null) {
            this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4e8b\u52a1ID tranId:{}", (Object)tboxTranID);
            result.setError(ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST);
            return result;
        }
        PublicKey publicKey = null;
        if (confirmPkiMessage.getExtraCerts() != null) {
            try {
                CMPCertificate[] extraCerts = confirmPkiMessage.getExtraCerts();
                X509Certificate cert = SdkCertUtils.convertDerCertToCert((byte[])extraCerts[0].getEncoded());
                publicKey = cert.getPublicKey();
            }
            catch (Exception e) {
                this.logger.error("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== \u6d88\u606f\u4f53\u4e2d\u672a\u5305\u542b\u9a8c\u8bc1\u8bc1\u4e66");
                result.setError(ErrorEnum.THE_PKIMESSAGE_HEADER_NO_EXTRACERTS);
                return result;
            }
        }
        DERBitString protectData = confirmPkiMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign((PublicKey)publicKey, (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, (byte[])baseCMPInfo.getSharedKey());
        if (!checkResult.isSuccess()) {
            this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== 3.1 \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)checkResult));
            result.setError(checkResult.getError());
            return result;
        }
        PKIBody body = confirmPkiMessage.getBody();
        if (body == null) {
            this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            result.setError(ErrorEnum.NO_PKI_BODY_FOR_RECEIVED);
            return result;
        }
        if (body.getType() != 19 || body.getType() != 24) {
            this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f24");
            result.setError(ErrorEnum.CONFIRM_CERT_PKI_BODY_TAG_NOT_24);
            return result;
        }
        CertConfirmContent confirmContent = (CertConfirmContent)body.getContent();
        if (confirmContent == null) {
            this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== PKI\u6d88\u606f\u4e2dCertConfirmContent\u4e3a\u7a7a");
            result.setError(ErrorEnum.PKI_BODY_CERT_CONFIRM_CONTENT_IS_EMPTY);
            return result;
        }
        this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== RA\u63a5\u6536\u5230TBox\u53d1\u9001\u7684\u5173\u4e8e\u8bf7\u6c42\u4e8b\u52a1id\u4e3a[{}}]\u7684\u6d88\u606f\u786e\u8ba4\u8bf7\u6c42", (Object)tboxTranID);
        String applyNo = this.redisCacheManagerService.removeTboxTransId(tboxTranID);
        Result ackResult = this.certApplyService.issueUserCertResp(applyNo, "V2X", true);
        if (!ackResult.isSuccess()) {
            this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ==========  RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f\u8bf7\u6c42\u9519\u8bef\uff1a{}", (Object)JsonUtils.object2Json((Object)ackResult));
            result.setError(ErrorEnum.RA_SERVICE_RETURN_ISSUE_CERT_CONFIRM_ERROR);
            return result;
        }
        this.logger.info("RA\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f ========== \u3010\u7ed3\u675f\u3011");
        return result;
    }
}

