/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.tbox.cmp.handler;

import com.xdja.ca.cache.RedisClient;
import com.xdja.ca.service.CaSdkRedisCacheManagerService;
import com.xdja.ca.service.impl.CaSdkRedisCacheManagerServiceImpl;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.PKICertHelper;
import com.xdja.pki.ra.core.util.file.HexUtils;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.core.util.time.DateUtils;
import com.xdja.pki.ra.manager.dto.UpdateApplyDTO;
import com.xdja.pki.ra.openapi.core.BaseCMPInfo;
import com.xdja.pki.ra.openapi.core.common.CmpRespCertType;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.cache.RedisCacheManagerService;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.tbox.TboxDeviceService;
import java.security.PublicKey;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.OptionalValidity;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.Time;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

@Component(value="cmpUpdateCertReqHandler")
public class CmpUpdateCertReqHandler
implements ICmpMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    TboxDeviceService tboxDeviceService;
    @Autowired
    RedisCacheManagerService redisCacheManagerService;
    @Autowired
    private Pool<Jedis> jedisPool;
    private CaSdkRedisCacheManagerService caSdkRedisCacheManagerService;

    @Value(value="${transId.cache.expireTime}")
    private void init(int transIdExpireTime) {
        RedisClient redisClient = new RedisClient(this.jedisPool);
        this.caSdkRedisCacheManagerService = new CaSdkRedisCacheManagerServiceImpl(redisClient, transIdExpireTime);
    }

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException {
        CertResponse[] certRespos;
        byte[] newCertPublickey;
        PublicKey tempPublicKey;
        PKIMessage errPkiMessage;
        CertRepMessage certRepMessage;
        PublicKey tboxSignCertPublicKey;
        BaseCMPInfo baseCMPInfo;
        AlgorithmIdentifier protectionAlg;
        String tboxTranID;
        byte[] tboxSenderNonce;
        byte[] tboxRecipNonce;
        this.logger.info("RA\u63a5\u6536tbox\u66f4\u65b0\u5904\u7406 ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        this.logger.info("RA\u66f4\u65b0\u5904\u7406 ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage reqPkiMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (reqPkiMessage == null) {
            String errMsg = "RA\u66f4\u65b0\u5904\u7406 ========== No pkiMessage response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        this.logger.info("RA\u66f4\u65b0\u5904\u7406 ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        PKIHeader header = reqPkiMessage.getHeader();
        if (header == null) {
            String errMsg = "RA\u66f4\u65b0\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        GeneralName sender = GeneralName.getInstance((Object)header.getSender());
        String deviceNo = sender.getName().toString();
        GeneralName recipient = header.getRecipient();
        try {
            tboxRecipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            tboxSenderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            tboxTranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u66f4\u65b0\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        if (tboxRecipNonce == null || tboxSenderNonce == null || protectionAlg == null || StringUtils.isBlank((CharSequence)tboxTranID)) {
            String errMsg = "RA\u66f4\u65b0\u5904\u7406 ========== \u66f4\u65b0\u63a5\u53e3\u4e2d\u5fc5\u586b\u9879\u6709\u7a7a\u503c";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        String cmpInfo = this.caSdkRedisCacheManagerService.getCaSdkCmpInfo(tboxTranID);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CASDK get transId:[{}] baseCMPInfo:[{}]", (Object)tboxTranID, (Object)cmpInfo);
        }
        if ((baseCMPInfo = (BaseCMPInfo)JsonUtils.json2Object((String)cmpInfo, BaseCMPInfo.class)) == null) {
            this.logger.info("\u66f4\u65b0\u5904\u7406 ========== \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4e8b\u52a1ID tranId:{}", (Object)tboxTranID);
            CertRepMessage certRepMessage2 = PKIMessageHelper.genFailCertResponse((long)-1L, (int)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.code, (String)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.desc);
            PKIMessage errPkiMessage2 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage2);
            result.setInfo((Object)errPkiMessage2);
            return result;
        }
        CertReqMessages ir = (CertReqMessages)reqPkiMessage.getBody().getContent();
        long signRequestId = ir.toCertReqMsgArray()[0].getCertReq().getCertReqId().getValue().longValue();
        baseCMPInfo.setRequestId(signRequestId);
        CMPCertificate[] certificates = reqPkiMessage.getExtraCerts();
        if (certificates == null) {
            CertRepMessage certRepMessage3 = PKIMessageHelper.genFailCertResponse((long)-1L, (int)ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR.code, (String)ErrorEnum.GET_CERT_INFO_BY_SYSNUMBER_ERROR.desc);
            PKIMessage errPkiMessage3 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage3);
            result.setInfo((Object)errPkiMessage3);
            return result;
        }
        CMPCertificate cmpCertificate = certificates[0];
        Certificate tboxCert = cmpCertificate.getX509v3PKCert();
        SubjectPublicKeyInfo publicKeyInfo = tboxCert.getSubjectPublicKeyInfo();
        try {
            tboxSignCertPublicKey = PKICertHelper.getPublicKeyFromSubjectPublicKey((SubjectPublicKeyInfo)publicKeyInfo, (String)"BC");
        }
        catch (Exception e) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38 ", (Throwable)e);
            CertRepMessage certRepMessage4 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.desc);
            PKIMessage errPkiMessage4 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage4);
            result.setInfo((Object)errPkiMessage4);
            return result;
        }
        this.logger.info("RA\u66f4\u65b0\u5904\u7406 ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        DERBitString protectData = reqPkiMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign((PublicKey)tboxSignCertPublicKey, (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, null);
        if (!checkResult.isSuccess()) {
            this.logger.info("RA\u66f4\u65b0\u5904\u7406 ========== \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)checkResult));
            CertRepMessage certRepMessage5 = PKIMessageHelper.genFailCertResponse((long)-1L, (int)checkResult.getError().code, (String)checkResult.getError().desc);
            PKIMessage errPkiMessage5 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage5);
            result.setInfo((Object)errPkiMessage5);
            return result;
        }
        PKIBody body = pkiMessage.getBody();
        if (body == null) {
            this.logger.info("RA\u66f4\u65b0\u5904\u7406 ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            CertRepMessage certRepMessage6 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.code, (String)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.desc);
            PKIMessage errPkiMessage6 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage6);
            result.setInfo((Object)errPkiMessage6);
            return result;
        }
        if (body.getType() != 7) {
            this.logger.info("RA\u66f4\u65b0\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f7");
            CertRepMessage certRepMessage7 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.code, (String)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.desc);
            PKIMessage errPkiMessage7 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage7);
            result.setInfo((Object)errPkiMessage7);
            return result;
        }
        ASN1Encodable content = body.getContent();
        CertReqMessages myCertReqMessages = CertReqMessages.getInstance((Object)content);
        CertReqMsg[] certReqMsgs = myCertReqMessages.toCertReqMsgArray();
        CertReqMsg certReqMsg = certReqMsgs[0];
        CertRequest certReq = certReqMsg.getCertReq();
        CertTemplate certTemplate = certReq.getCertTemplate();
        Integer certValidity = 0;
        String signSn = null;
        try {
            SubjectPublicKeyInfo signPublicKey = certTemplate.getPublicKey();
            OptionalValidity tempValidity = certTemplate.getValidity();
            signSn = HexUtils.bytesToHexFun1((byte[])certTemplate.getSerialNumber().getValue().toByteArray());
            this.logger.info(" ====================\u53d1\u8d77\u66f4\u65b0\u7684signSn============== :{}", (Object)signSn);
            if (tempValidity != null) {
                Time notBefore = tempValidity.getNotBefore();
                Time notAfter = tempValidity.getNotAfter();
                Long days = DateUtils.getDays((Date)notBefore.getDate(), (Date)notAfter.getDate());
                certValidity = days.intValue();
            }
            if (signPublicKey == null) {
                this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38");
                certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.desc);
                errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
                result.setInfo((Object)errPkiMessage);
                return result;
            }
            tempPublicKey = PKICertHelper.getPublicKeyFromSubjectPublicKey((SubjectPublicKeyInfo)signPublicKey, (String)"BC");
            newCertPublickey = tempPublicKey.getEncoded();
        }
        catch (Exception e) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38");
            CertRepMessage certRepMessage8 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.desc);
            PKIMessage errPkiMessage8 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage8);
            result.setInfo((Object)errPkiMessage8);
            return result;
        }
        boolean check = PKIMessageHelper.checkReqPop((CertReqMsg)certReqMsg, (PublicKey)(tempPublicKey == null ? tboxSignCertPublicKey : tempPublicKey));
        if (!check) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== \u9a8c\u8bc1\u8bf7\u6c42\u8bc1\u4e66\u66f4\u65b0\u6d88\u606f\u8bf7\u6c42\u79c1\u94a5\u62e5\u6709\u8bc1\u660e\u672a\u901a\u8fc7");
            CertRepMessage certRepMessage9 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.REQ_CERT_MESSAGE_POP_CHECK_FAIL.code, (String)ErrorEnum.REQ_CERT_MESSAGE_POP_CHECK_FAIL.desc);
            PKIMessage errPkiMessage9 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage9);
            result.setInfo((Object)errPkiMessage9);
            return result;
        }
        Result updateCertApplyResult = this.tboxDeviceService.insertUpdateCertApply(deviceNo, null, signSn, certValidity, newCertPublickey != null);
        if (!updateCertApplyResult.isSuccess()) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== \u53d1\u8d77\u66f4\u65b0\u7533\u8bf7\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)updateCertApplyResult));
            certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)updateCertApplyResult.getError().code, (String)updateCertApplyResult.getError().desc);
            errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        UpdateApplyDTO updateApplyDTO = (UpdateApplyDTO)updateCertApplyResult.getInfo();
        String applyNo = updateApplyDTO.getApplyNo();
        this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== \u7533\u8bf7\u7f16\u53f7\u4e3a\uff1a{}", (Object)applyNo);
        this.redisCacheManagerService.cacheTboxTransId(tboxTranID, applyNo);
        this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 4. \u53d1\u8d77\u66f4\u65b0\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42");
        Result issueResult = this.certApplyService.updateCert(updateApplyDTO, newCertPublickey);
        if (!issueResult.isSuccess()) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 4.1. \u66f4\u65b0\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42\u9519\u8bef:{}", (Object)JsonUtils.object2Json((Object)issueResult));
            CertRepMessage certRepMessage10 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)issueResult.getErrorBean().getErrCode(), (String)issueResult.getErrorBean().getErrMsg());
            PKIMessage errPkiMessage10 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage10);
            result.setInfo((Object)errPkiMessage10);
            return result;
        }
        this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== CA\u8fd4\u56de\u7684\u8bc1\u4e66\u66f4\u65b0\u8bf7\u6c42\u7684\u54cd\u5e94\u7ed3\u679c >>>>>>>:{}", (Object)JsonUtils.object2Json((Object)issueResult));
        if (issueResult.getInfo() == null) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 4.2. \u66f4\u65b0\u7528\u6237\u8bc1\u4e66\u6682\u65e0\u8fd4\u56de\u8bc1\u4e66\u4fe1\u606f");
            CertRepMessage certRepMessage11 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.code, (String)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.desc);
            PKIMessage errPkiMessage11 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage11);
            result.setInfo((Object)errPkiMessage11);
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)issueResult.getInfo();
        Integer certPatterm = null;
        try {
            certPatterm = updateApplyDTO.getCertPatterm();
        }
        catch (Exception e) {
            this.logger.info("\u83b7\u53d6\u66f4\u65b0\u8bc1\u4e66\u7533\u8bf7\u57fa\u672c\u4fe1\u606f\u4e3a\u7a7a");
            result.setError(ErrorEnum.GET_ISSUE_APPLY_INFO_IS_EMPTY);
            return result;
        }
        if (null == userCertInfo.getSignCert()) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            CertRepMessage certRepMessage12 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage12 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage12);
            result.setInfo((Object)errPkiMessage12);
            return result;
        }
        if (1 != certPatterm && null == userCertInfo.getEncCert()) {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            CertRepMessage certRepMessage13 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage13 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage13);
            result.setInfo((Object)errPkiMessage13);
            return result;
        }
        CertResponse signCertResponse = null;
        CertResponse encCertResponse = null;
        try {
            this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 5. \u5c06\u8bc1\u4e66\u5c01\u88c5\u7b7e\u540dCertResponse\u7ed3\u6784\u4f53");
            signCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_SIGN_CERT_1.value, (Integer)Constants.KEY_FORMAT_0010_1);
            if (1 != certPatterm) {
                if (StringUtils.isNotBlank((CharSequence)userCertInfo.getEncPriKey())) {
                    this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 6. \u5c06\u8bc1\u4e66\u5c01\u88c5\u52a0\u5bc6(\u6709\u52a0\u5bc6\u79c1\u94a5\u4fe1\u5c01)CertResponse\u7ed3\u6784\u4f53");
                    encCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_ENC_CERT_AND_ENC_PRI_KEY_2.value, (Integer)Constants.KEY_FORMAT_0010_1);
                } else {
                    this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 6. \u5c06\u8bc1\u4e66\u5c01\u88c5\u52a0\u5bc6CertResponse\u7ed3\u6784\u4f53");
                    encCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_ENC_CERT_3.value, (Integer)Constants.KEY_FORMAT_0010_1);
                }
            }
        }
        catch (Exception e) {
            this.logger.error("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== \u5c01\u88c5CertResponse\u7ed3\u6784\u4f53\u5f02\u5e38", (Throwable)e);
            CertRepMessage certRepMessage14 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.code, (String)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.desc);
            PKIMessage errPkiMessage14 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage14);
            result.setInfo((Object)errPkiMessage14);
            return result;
        }
        if (signCertResponse != null && encCertResponse == null) {
            certRespos = new CertResponse[]{signCertResponse};
        } else if (signCertResponse != null && encCertResponse != null) {
            certRespos = new CertResponse[]{signCertResponse, encCertResponse};
        } else {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 6.1. \u5c01\u88c5CertResponse\u5931\u8d25");
            CertRepMessage certRepMessage15 = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.code, (String)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.desc);
            PKIMessage errPkiMessage15 = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage15);
            result.setInfo((Object)errPkiMessage15);
            return result;
        }
        this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 7. \u5c01\u88c5CertRepMessage\u7ed3\u6784\u4f53");
        CertRepMessage certRepMessage16 = new CertRepMessage(null, certRespos);
        this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 8. \u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage repPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)8, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage16, null, (String)userCertInfo.getExtraCertsP7b());
        result.setInfo((Object)repPkiMessage);
        this.logger.info("RA\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== \u3010\u7ed3\u675f\u3011");
        return result;
    }
}

