/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.openapi.tbox.cmp.handler;

import com.xdja.ca.cache.RedisClient;
import com.xdja.ca.service.CaSdkRedisCacheManagerService;
import com.xdja.ca.service.impl.CaSdkRedisCacheManagerServiceImpl;
import com.xdja.ca.utils.DnUtil;
import com.xdja.ca.vo.UserCertInfo;
import com.xdja.pki.ra.cache.RaSdkCache;
import com.xdja.pki.ra.core.common.Result;
import com.xdja.pki.ra.core.commonenum.ErrorEnum;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.core.util.cert.CertUtils;
import com.xdja.pki.ra.core.util.cert.PKICertHelper;
import com.xdja.pki.ra.core.util.json.JsonUtils;
import com.xdja.pki.ra.manager.dao.DeviceKeyDao;
import com.xdja.pki.ra.manager.dao.model.DeviceKeyDO;
import com.xdja.pki.ra.manager.dto.IssueApplyDTO;
import com.xdja.pki.ra.openapi.core.BaseCMPInfo;
import com.xdja.pki.ra.openapi.core.common.CmpRespCertType;
import com.xdja.pki.ra.openapi.core.common.PKIMessageException;
import com.xdja.pki.ra.openapi.core.handler.ICmpMessageHandler;
import com.xdja.pki.ra.openapi.core.helper.PKIMessageHelper;
import com.xdja.pki.ra.service.manager.certapply.CertApplyService;
import com.xdja.pki.ra.service.manager.tbox.TboxDeviceService;
import java.security.PublicKey;
import javax.naming.NamingException;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.transaction.annotation.Transactional;
import redis.clients.jedis.Jedis;
import redis.clients.util.Pool;

@Component(value="cmpIssuerCertReqHandler")
public class CmpIssuerCertReqHandler
implements ICmpMessageHandler {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    CertApplyService certApplyService;
    @Autowired
    TboxDeviceService tboxDeviceService;
    @Autowired
    DeviceKeyDao deviceKeyDao;
    @Autowired
    RaSdkCache raSdkCache;
    @Autowired
    private Pool<Jedis> jedisPool;
    private CaSdkRedisCacheManagerService caSdkRedisCacheManagerService;

    @Value(value="${transId.cache.expireTime}")
    private void init(int transIdExpireTime) {
        RedisClient redisClient = new RedisClient(this.jedisPool);
        this.caSdkRedisCacheManagerService = new CaSdkRedisCacheManagerServiceImpl(redisClient, transIdExpireTime);
    }

    @Transactional
    public Result handleMessage(PKIMessage pkiMessage, boolean authenticated) throws PKIMessageException {
        CertResponse[] certRespos;
        X500Name userCertDn;
        BaseCMPInfo baseCMPInfo;
        AlgorithmIdentifier protectionAlg;
        String senderKID;
        String tboxTranID;
        byte[] tboxSenderNonce;
        byte[] tboxRecipNonce;
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u3010\u5f00\u59cb\u3011");
        Result result = new Result();
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 1. \u83b7\u53d6PkiMessage\u6d88\u606f\u7ed3\u6784");
        PKIMessage reqPkiMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (reqPkiMessage == null) {
            String errMsg = "RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== No pkiMessage response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 2. \u83b7\u53d6PkiMessage\u6d88\u606f\u5934PKIHeader");
        PKIHeader header = reqPkiMessage.getHeader();
        if (header == null) {
            String errMsg = "RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== No header in response message.";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        GeneralName sender = GeneralName.getInstance((Object)header.getSender());
        GeneralName recipient = header.getRecipient();
        try {
            tboxRecipNonce = header.getRecipNonce() == null ? null : header.getRecipNonce().getOctets();
            tboxSenderNonce = header.getSenderNonce() == null ? null : header.getSenderNonce().getOctets();
            tboxTranID = header.getTransactionID() == null ? null : new String(header.getTransactionID().getOctets());
            senderKID = header.getSenderKID() == null ? null : new String(header.getSenderKID().getOctets());
            protectionAlg = header.getProtectionAlg();
        }
        catch (Exception e) {
            String errMsg = "RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== No header in response message.";
            this.logger.error(errMsg);
            throw new PKIMessageException(errMsg, (Throwable)e);
        }
        if (tboxRecipNonce == null || tboxSenderNonce == null || protectionAlg == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{tboxTranID, senderKID})) {
            String errMsg = "RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u7b7e\u53d1\u63a5\u53e3\u4e2d\u5fc5\u586b\u9879\u6709\u7a7a\u503c";
            this.logger.info(errMsg);
            throw new PKIMessageException(errMsg);
        }
        DERBitString protectData = reqPkiMessage.getProtection();
        byte[] sourceData = PKIMessageHelper.getProtectedBytes((PKIMessage)pkiMessage);
        DeviceKeyDO deviceSharedKey = this.deviceKeyDao.getDeviceSharedKey(senderKID);
        if (deviceSharedKey == null) {
            this.logger.error("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406\u5f02\u5e38 ========== \u672a\u83b7\u53d6\u5230\u76f8\u5e94\u7684\u5171\u4eab\u5bc6\u94a5id\u5185\u5bb9\uff1a{}", (Object)senderKID);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)ErrorEnum.CANNOT_GET_SHARED_KEY_INFO.code, (String)ErrorEnum.CANNOT_GET_SHARED_KEY_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        String deviceNo = sender.getName().toString();
        if (!deviceNo.equals(deviceSharedKey.getDeviceNo())) {
            this.logger.error("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406\u5f02\u5e38 ==========\u5171\u4eab\u79d8\u94a5\u5bf9\u5e94\u7684\u8bbe\u5907\u7f16\u53f7\u4e3a\uff1a[{}] sender\u4e2d\u7684deviceNo\u4e3a\uff1a[{}]", (Object)deviceSharedKey.getDeviceNo(), (Object)deviceNo);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)ErrorEnum.TBOX_DEVICE_NO_IS_NOT_MATCH.code, (String)ErrorEnum.TBOX_DEVICE_NO_IS_NOT_MATCH.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        byte[] sharedKey = deviceSharedKey.getSharedKey().getBytes();
        CertReqMessages ir = (CertReqMessages)reqPkiMessage.getBody().getContent();
        long signRequestId = ir.toCertReqMsgArray()[0].getCertReq().getCertReqId().getValue().longValue();
        String cmpInfo = this.caSdkRedisCacheManagerService.getCaSdkCmpInfo(tboxTranID);
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("CASDK get transId:[{}] baseCMPInfo:[{}]", (Object)tboxTranID, (Object)cmpInfo);
        }
        if ((baseCMPInfo = (BaseCMPInfo)JsonUtils.json2Object((String)cmpInfo, BaseCMPInfo.class)) == null) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u4e8b\u52a1ID tranId:{}", (Object)tboxTranID);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.code, (String)ErrorEnum.CMP_TRAN_ID_IS_NOT_EXIST.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        baseCMPInfo.setRequestId(signRequestId);
        baseCMPInfo.setSharedKey(sharedKey);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 3. \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u7684\u6b63\u786e\u6027");
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign(null, (PKIHeader)header, (byte[])protectData.getBytes(), (byte[])sourceData, (AlgorithmIdentifier)protectionAlg, (byte[])sharedKey);
        if (!checkResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u9a8c\u8bc1cmp\u6d88\u606f\u7684header\u548c\u7b7e\u540d\u9519\u8bef \u539f\u56e0\uff1a{}", (Object)JsonUtils.object2Json((Object)checkResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)-1L, (int)checkResult.getError().code, (String)checkResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        PKIBody body = pkiMessage.getBody();
        if (body == null) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u6ca1\u6709\u5bf9\u5e94\u7684PKI\u6d88\u606f\u4f53");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.code, (String)ErrorEnum.NO_PKI_BODY_FOR_RECEIVED.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (body.getType() != 0 && body.getType() != 2) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u7684\u7c7b\u578b\u4e0d\u662f0\u62162");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.code, (String)ErrorEnum.ISSUE_CERT_PKI_BODY_TAG_NOT_0_OR_2.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        ASN1Encodable content = body.getContent();
        CertReqMessages myCertReqMessages = CertReqMessages.getInstance((Object)content);
        CertReqMsg[] certReqMsgs = myCertReqMessages.toCertReqMsgArray();
        CertReqMsg certReqMsg = certReqMsgs[0];
        CertRequest certReq = certReqMsg.getCertReq();
        CertTemplate certTemplate = certReq.getCertTemplate();
        Result raBaseDNResult = this.certApplyService.getRaBaseDn();
        if (!raBaseDNResult.isSuccess()) {
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)raBaseDNResult.getErrorBean().getErrCode(), (String)raBaseDNResult.getErrorBean().getErrMsg());
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        String baseDn = (String)raBaseDNResult.getInfo();
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u5728\u7ebf\u83b7\u53d6RA\u7684BaseDN\u4e3a\uff1a{}", (Object)baseDn);
        try {
            userCertDn = DnUtil.getRFC4519X500Name((String)("CN=" + deviceNo + "," + baseDn));
            if (certTemplate.getSubject() != null) {
                String temp = certTemplate.getSubject().toString().toUpperCase();
                userCertDn = temp.endsWith(baseDn.toUpperCase()) ? certTemplate.getSubject() : DnUtil.getRFC4519X500Name((String)(certTemplate.getSubject().toString() + "," + baseDn));
            }
        }
        catch (NamingException e) {
            this.logger.error("\u8bc1\u4e66\u7533\u8bf7\u7684DN\u9519\u8bef", (Throwable)e);
            result.setError(ErrorEnum.CERT_APPLY_DN_IS_ERROR);
            return result;
        }
        this.logger.info("\u81ea\u5b9a\u4e49\u62fc\u88c5\u5728\u7ebf\u7533\u8bf7\u7684\u8bbe\u5907\u7528\u6237DN ===== userCertDn:{}", (Object)userCertDn.toString());
        PublicKey tboxPublicKey = null;
        try {
            SubjectPublicKeyInfo subPublicKey = certTemplate.getPublicKey();
            if (subPublicKey == null) {
                this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u4e3a\u7a7a");
                CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EMPTY.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EMPTY.desc);
                PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
                result.setInfo((Object)errPkiMessage);
                return result;
            }
            tboxPublicKey = PKICertHelper.getPublicKeyFromSubjectPublicKey((SubjectPublicKeyInfo)subPublicKey, (String)"BC");
        }
        catch (Exception e) {
            this.logger.error("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== PKI\u6d88\u606f\u4f53\u4e2d\u516c\u94a5\u4fe1\u606f\u83b7\u53d6\u5f02\u5e38", (Throwable)e);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_EXCEPTION.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        boolean check = PKIMessageHelper.checkReqPop((CertReqMsg)certReqMsg, (PublicKey)tboxPublicKey);
        if (!check) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u9a8c\u8bc1\u8bf7\u6c42\u8bc1\u4e66\u7684\u79c1\u94a5\u62e5\u6709\u8bc1\u660e\u672a\u901a\u8fc7");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.REQ_CERT_MESSAGE_POP_CHECK_FAIL.code, (String)ErrorEnum.REQ_CERT_MESSAGE_POP_CHECK_FAIL.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        Result issueCertApplyResult = this.tboxDeviceService.insertIssueCertApply(deviceNo, userCertDn.toString());
        if (!issueCertApplyResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u53d1\u8d77\u7b7e\u53d1\u7533\u8bf7\u5931\u8d25:{}", (Object)JsonUtils.object2Json((Object)issueCertApplyResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)issueCertApplyResult.getError().code, (String)issueCertApplyResult.getError().desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        IssueApplyDTO issueApplyDTO = (IssueApplyDTO)issueCertApplyResult.getInfo();
        Boolean aBoolean = CertUtils.checkPublicKey((PublicKey)tboxPublicKey, (String)issueApplyDTO.getKeyAlg(), (Integer)issueApplyDTO.getPrivateKeyLength());
        if (!aBoolean.booleanValue()) {
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_ERROR.code, (String)ErrorEnum.GET_PKI_MESSAGE_PUBLIC_KEY_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        String applyNo = issueApplyDTO.getApplyNo();
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u7533\u8bf7\u7f16\u53f7\u4e3a\uff1a{}", (Object)applyNo);
        this.raSdkCache.cacheTboxTransId(tboxTranID, applyNo);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4. \u53d1\u8d77\u7b7e\u53d1\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42");
        Result issueResult = this.certApplyService.issueCert("V2X", issueApplyDTO, tboxPublicKey.getEncoded(), null);
        if (!issueResult.isSuccess()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.1. \u7b7e\u53d1\u7528\u6237\u53cc\u8bc1\u4e66\u8bf7\u6c42\u9519\u8bef:{}", (Object)JsonUtils.object2Json((Object)issueResult));
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)issueResult.getErrorBean().errCode, (String)issueResult.getErrorBean().getErrMsg());
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== CA\u8fd4\u56de\u7684\u8bc1\u4e66\u7b7e\u53d1\u8bf7\u6c42\u7684\u54cd\u5e94\u7ed3\u679c >>>>>>> :{}", (Object)JsonUtils.object2Json((Object)issueResult));
        if (issueResult.getInfo() == null) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.2. \u7b7e\u53d1\u7528\u6237\u8bc1\u4e66\u6682\u65e0\u8fd4\u56de\u8bc1\u4e66\u4fe1\u606f");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.code, (String)ErrorEnum.ISSUE_USER_CERT_NO_CERT_INFO.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        UserCertInfo userCertInfo = (UserCertInfo)issueResult.getInfo();
        if (null == userCertInfo.getSignCert()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        Integer certPatterm = issueApplyDTO.getCertPatterm();
        if (1 != certPatterm && null == userCertInfo.getEncCert()) {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 4.3. \u7528\u6237\u8bc1\u4e66\u6216\u52a0\u5bc6\u8bc1\u4e66\u4e3a\u7a7a");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.code, (String)ErrorEnum.SIGN_CERT_OR_ENC_CERT_IS_EMPTY.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        CertResponse signCertResponse = null;
        CertResponse encCertResponse = null;
        try {
            this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 5. \u5c06\u8bc1\u4e66\u5c01\u88c5\u7b7e\u540dCertResponse\u7ed3\u6784\u4f53");
            signCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_SIGN_CERT_1.value, (Integer)Constants.KEY_FORMAT_0010_1);
            if (1 != certPatterm) {
                this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 6. \u5c06\u8bc1\u4e66\u5c01\u88c5\u52a0\u5bc6CertResponse\u7ed3\u6784\u4f53");
                encCertResponse = PKIMessageHelper.genCertResponse((long)signRequestId, (UserCertInfo)userCertInfo, (int)CmpRespCertType.GEN_CERT_RESPONSE_ENC_CERT_AND_ENC_PRI_KEY_2.value, (Integer)Constants.KEY_FORMAT_0010_1);
            }
        }
        catch (Exception e) {
            this.logger.error("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u5c01\u88c5CertResponse\u7ed3\u6784\u4f53\u5f02\u5e38", (Throwable)e);
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.code, (String)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        if (signCertResponse != null && encCertResponse == null) {
            certRespos = new CertResponse[]{signCertResponse};
        } else if (signCertResponse != null && encCertResponse != null) {
            certRespos = new CertResponse[]{signCertResponse, encCertResponse};
        } else {
            this.logger.info("\u66f4\u65b0\u7533\u8bf7\u5904\u7406 ========== 6.1. \u5c01\u88c5CertResponse\u5931\u8d25");
            CertRepMessage certRepMessage = PKIMessageHelper.genFailCertResponse((long)signRequestId, (int)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.code, (String)ErrorEnum.MAKE_CERT_RESPONSE_ERROR.desc);
            PKIMessage errPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage);
            result.setInfo((Object)errPkiMessage);
            return result;
        }
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 7. \u5c01\u88c5CertRepMessage\u7ed3\u6784\u4f53");
        CertRepMessage certRepMessage = new CertRepMessage(null, certRespos);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== 8. \u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        PKIMessage repPkiMessage = PKIMessageHelper.generatePKIMessage((GeneralName)sender, (GeneralName)recipient, (int)3, (byte[])tboxRecipNonce, (byte[])tboxSenderNonce, (String)tboxTranID, (ASN1Encodable)certRepMessage, null, (String)userCertInfo.getExtraCertsP7b());
        result.setInfo((Object)repPkiMessage);
        this.logger.info("RA\u7b7e\u53d1\u7533\u8bf7\u5904\u7406 ========== \u3010\u7ed3\u675f\u3011");
        return result;
    }
}

