/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.schedule.service.impl;

import com.xdja.pki.backup.dao.model.BackupConfigDO;
import com.xdja.pki.backup.service.manager.BackupConfigService;
import com.xdja.pki.backup.service.manager.bean.BackupReq;
import com.xdja.pki.backup.util.DateUtils;
import com.xdja.pki.backup.util.JsonUtils;
import com.xdja.pki.cache.RedisClient;
import com.xdja.pki.core.constants.RedisKey;
import com.xdja.pki.dynamic.schedule.CronTaskRegistrar;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.config.ArchiveConfigBean;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.schedule.service.ApplicationInitService;
import com.xdja.pki.ra.service.manager.system.SystemService;
import com.xdja.pki.thread.schedule.DynamicThreadConstants;
import com.xdja.pki.thread.schedule.thread.PeriodAuditLogThread;
import java.util.Date;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApplicationInitServiceImpl
implements ApplicationInitService {
    private Logger logger = LoggerFactory.getLogger(ApplicationInitServiceImpl.class);
    @Autowired
    private CronTaskRegistrar cronTaskRegistrar;
    @Autowired
    private BackupConfigService backupConfigService;
    @Autowired
    private SystemService systemService;
    @Value(value="${cluster.deployment.type}")
    private String deploymentType;
    @Autowired
    RedisClient redisClient;

    public void initBackupConfig() {
        BackupConfigDO backupConfigDO = this.backupConfigService.getBackupConfigModel();
        if ("0".equals(this.deploymentType)) {
            if (backupConfigDO.getIsOpenAutoBackup() == 1) {
                this.logger.info("\u5907\u4efd\u6a21\u5f0f\uff1a\u81ea\u52a8\u5907\u4efd");
                this.logger.info("\u542f\u52a8\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[autoTotalBackup()] crn[{}]", (Object)backupConfigDO.getTotalCron());
                this.cronTaskRegistrar.addCronTask("backupServiceImpl", "autoTotalBackup", backupConfigDO.getTotalCron());
                this.logger.info("\u542f\u52a8\u589e\u91cf\u5907\u4efd\u7ebf\u7a0b[autoIncBackup()] crn[{}]", (Object)backupConfigDO.getIncCron());
                this.cronTaskRegistrar.addCronTask("backupServiceImpl", "autoIncBackup", backupConfigDO.getIncCron());
                this.logger.info("\u542f\u52a8\u81ea\u52a8\u6e05\u7406\u5907\u4efd\u7ebf\u7a0b[autoCleanOverdueBackup()] crn[{}]", (Object)backupConfigDO.getRetentionCron());
                this.cronTaskRegistrar.addCronTask("backupServiceImpl", "autoCleanOverdueBackup", backupConfigDO.getRetentionCron());
            } else {
                this.logger.info("\u5907\u4efd\u6a21\u5f0f\uff1a\u624b\u5de5\u5907\u4efd");
                this.logger.info("\u5220\u9664\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[autoTotalBackup()] ");
                this.cronTaskRegistrar.removeCronTask("backupServiceImpl", "autoTotalBackup");
                this.logger.info("\u5220\u9664\u589e\u91cf\u5907\u4efd\u7ebf\u7a0b[autoIncBackup()] ");
                this.cronTaskRegistrar.removeCronTask("backupServiceImpl", "autoIncBackup");
                this.logger.info("\u5220\u9664\u81ea\u52a8\u6e05\u7406\u5907\u4efd\u7ebf\u7a0b[autoCleanOverdueBackup()] ");
                this.cronTaskRegistrar.removeCronTask("backupServiceImpl", "autoCleanOverdueBackup");
            }
        } else {
            this.logger.info("\u7cfb\u7edf\u96c6\u7fa4\u90e8\u7f72\u4e0d\u652f\u6301\u5907\u4efd\uff01");
        }
    }

    public void artificialBackup(String message) {
        BackupReq backupReq = (BackupReq)JsonUtils.json2Object((String)message, BackupReq.class);
        String currentDateStr = DateUtils.plusSecond((int)2, (String)"yyyy-MM-dd HH:mm:ss");
        String currentDateCron = DateUtils.getCron6((Date)DateUtils.strToDate((String)currentDateStr));
        if (0 == backupReq.getBackupType()) {
            System.setProperty("system_property_key_backup_artificial_total", JsonUtils.object2Json((Object)backupReq));
            this.logger.info("\u542f\u52a8\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[artificialTotalBackup()] crn[{}]", (Object)currentDateCron);
            this.cronTaskRegistrar.addCronTask("backupServiceImpl", "artificialTotalBackup", currentDateCron);
        } else {
            System.setProperty("system_property_key_backup_artificial_inc", JsonUtils.object2Json((Object)backupReq));
            this.logger.info("\u542f\u52a8\u5168\u91cf\u5907\u4efd\u7ebf\u7a0b[artificialIncBackup()] crn[{}]", (Object)currentDateCron);
            this.cronTaskRegistrar.addCronTask("backupServiceImpl", "artificialIncBackup", currentDateCron);
        }
    }

    public void initArchiveConfig() {
        ArchiveConfigBean archiveConfigBean;
        Config config = null;
        try {
            config = this.systemService.getConfigFile("config.json");
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        if (null != config && null != (archiveConfigBean = config.getArchiveConfigBean())) {
            CommonVariable.setArchiveConfig((ArchiveConfigBean)archiveConfigBean);
            if (null != archiveConfigBean.getAutoArchiveFlag()) {
                if (archiveConfigBean.getAutoArchiveFlag() == 1) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u81ea\u52a8\u5f52\u6863\u5b9a\u65f6\u4efb\u52a1\u8bbe\u5b9a\uff1a{}", (Object)archiveConfigBean.toCNString());
                    }
                    this.cronTaskRegistrar.addCronTask("auditLogServiceImpl", "doAutoArchiveOperateLogLock", archiveConfigBean.getAutoArchiveCron());
                } else if (archiveConfigBean.getAutoArchiveFlag() == 0) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u81ea\u52a8\u5f52\u6863\u5b9a\u65f6\u4efb\u52a1\u8bbe\u5b9a\uff1a{}", (Object)archiveConfigBean.toCNString());
                    }
                    this.cronTaskRegistrar.removeCronTask("auditLogServiceImpl", "doAutoArchiveOperateLogLock");
                }
            }
        }
    }

    public void initPeriodAuditConfig() {
        ArchiveConfigBean archiveConfigBean;
        Config config = null;
        try {
            config = this.systemService.getConfigFile("config.json");
        }
        catch (Exception e) {
            this.logger.error("\u83b7\u53d6\u7cfb\u7edf\u914d\u7f6e\u53c2\u6570\u5f02\u5e38", (Throwable)e);
        }
        if (null != config && null != (archiveConfigBean = config.getArchiveConfigBean())) {
            CommonVariable.setArchiveConfig((ArchiveConfigBean)archiveConfigBean);
            Integer auditPeriod = archiveConfigBean.getAuditLogPeriod();
            if (null != auditPeriod) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("\u81ea\u52a8\u5468\u671f\u5ba1\u8ba1\u5b9a\u65f6\u4efb\u52a1\u8bbe\u5b9a\uff1a{} \u5c0f\u65f6", (Object)auditPeriod);
                }
                if (DynamicThreadConstants.DYNAMIC_THREAD_COLLECTION.containsKey("period_audit_log_thread")) {
                    ((Future)DynamicThreadConstants.DYNAMIC_THREAD_COLLECTION.get("period_audit_log_thread")).cancel(true);
                }
                String nextAuditTime = this.redisClient.get(RedisKey.TIME_AUDIT_PERIOD);
                long sleepTime = 0L;
                if (null == nextAuditTime) {
                    Date intervalDate = DateUtils.getIntervalDate((Date)new Date(), (int)10, (int)auditPeriod);
                    nextAuditTime = String.valueOf(intervalDate.getTime());
                    this.redisClient.set(RedisKey.TIME_AUDIT_PERIOD, nextAuditTime);
                    this.logger.debug("\u4e0d\u5b58\u5728\u4e0b\u6b21\u5468\u671f\u5ba1\u8ba1\u65f6\u95f4\uff0c\u7acb\u5373\u6267\u884c\u4e00\u6b21");
                } else {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug("\u83b7\u53d6\u5230\u4e0b\u6b21\u5468\u671f\u5ba1\u8ba1\u65f6\u95f4\uff1a{}", (Object)DateUtils.longToStr((long)Long.parseLong(nextAuditTime)));
                    }
                    long time = System.currentTimeMillis();
                    if (Long.parseLong(nextAuditTime) > time) {
                        sleepTime = (Long.parseLong(nextAuditTime) - time) / 1000L;
                        this.logger.debug("\u5b58\u5728\u4e0b\u6b21\u5468\u671f\u5ba1\u8ba1\u65f6\u95f4\u5927\u4e8e\u5f53\u524d\u65f6\u95f4\uff0csleepTime:{} s", (Object)sleepTime);
                    } else {
                        this.logger.debug("\u5b58\u5728\u4e0b\u6b21\u5468\u671f\u5ba1\u8ba1\u65f6\u95f4\u5c0f\u4e8e\u5f53\u524d\u65f6\u95f4\uff0c\u7acb\u5373\u6267\u884c\u5468\u671f\u6027\u5ba1\u8ba1");
                    }
                }
                PeriodAuditLogThread periodAuditLogThread = new PeriodAuditLogThread("periodAuditLogServiceImpl", "saveAndSignAuditLogLock", auditPeriod);
                DynamicThreadConstants.DYNAMIC_THREAD_COLLECTION.put("period_audit_log_thread", DynamicThreadConstants.DYNAMIC_THREAD_POOL_EXECUTOR.scheduleAtFixedRate((Runnable)periodAuditLogThread, sleepTime, 3600L * (long)auditPeriod.intValue(), TimeUnit.SECONDS));
            }
        }
    }

    public void monitorCpuForQuarter() {
        if ("0".equals(this.deploymentType)) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u975e\u96c6\u7fa4\u90e8\u7f72\uff0c\u542f\u52a8CPU\u5229\u7528\u7387\u76d1\u63a7\u7ebf\u7a0b\uff01");
            }
            String cron = "0 */15 * * * ?";
            this.cronTaskRegistrar.addCronTask("monitorServiceImpl", "monitorCpu", cron);
        } else {
            this.logger.info("\u96c6\u7fa4\u90e8\u7f72\uff0c\u4e0d\u542f\u52a8CPU\u5229\u7528\u7387\u76d1\u63a7\u7ebf\u7a0b\uff01");
        }
    }
}

