/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.schedule.subscriber;

import com.xdja.pki.ra.core.constant.RaRedisKey;
import com.xdja.pki.ra.schedule.service.ApplicationInitService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import redis.clients.jedis.JedisPubSub;

@Component
public class Subscriber
extends JedisPubSub {
    private static final Logger logger = LoggerFactory.getLogger(Subscriber.class);
    @Autowired
    private ApplicationInitService applicationInitService;

    public void onMessage(String channel, String message) {
        if (logger.isDebugEnabled()) {
            logger.debug("receive published message, channel [{}], message [{}]  ", (Object)channel, (Object)message);
        }
        if (RaRedisKey.CHANNEL_SYSTEM_NOTICE.equals(channel)) {
            switch (message) {
                case "notice:backup.config.changed": {
                    this.applicationInitService.initBackupConfig();
                    return;
                }
                case "notice:audit.config.changed": {
                    this.applicationInitService.initArchiveConfig();
                    return;
                }
                case "notice:period.config.changed": {
                    this.applicationInitService.initPeriodAuditConfig();
                    return;
                }
            }
            if (logger.isErrorEnabled()) {
                logger.error("receive unknown channel published message, channel [{}], message [{}]  ", (Object)channel, (Object)message);
            }
        } else if (RaRedisKey.CHANNEL_BACKUP_ACTIFICIAL.equals(channel)) {
            this.applicationInitService.artificialBackup(message);
        } else if (logger.isErrorEnabled()) {
            logger.error("receive unknown channel : channel [{}], message [{}]  ", (Object)channel, (Object)message);
        }
    }

    public void onSubscribe(String channel, int subscribedChannels) {
        if (logger.isDebugEnabled()) {
            logger.debug("subscribe redis channel success, channel [{}], subscribedChannels [{}]", (Object)channel, (Object)subscribedChannels);
        }
    }

    public void onUnsubscribe(String channel, int subscribedChannels) {
        if (logger.isDebugEnabled()) {
            logger.debug("unsubscribe redis channel, channel [{}], subscribedChannels [{}]", (Object)channel, (Object)subscribedChannels);
        }
    }
}

