/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.pki.ra.schedule;

import com.xdja.pki.backup.service.manager.BackupService;
import com.xdja.pki.backup.util.ConfigUtils;
import com.xdja.pki.gmssl.crypto.init.GMSSLPkiCryptoInit;
import com.xdja.pki.ra.core.common.CommonVariable;
import com.xdja.pki.ra.core.config.Config;
import com.xdja.pki.ra.core.constant.Constants;
import com.xdja.pki.ra.schedule.service.ApplicationInitService;
import com.xdja.pki.ra.schedule.subscriber.SubscriberThread;
import com.xdja.pki.ra.service.manager.system.SystemService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.ApplicationArguments;
import org.springframework.boot.ApplicationRunner;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class ApplicationInitRunner
implements ApplicationRunner {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationInitRunner.class);
    @Autowired
    private BackupService backupService;
    @Autowired
    private ApplicationInitService applicationInitService;
    @Autowired
    private SubscriberThread subscriberThread;
    @Autowired
    SystemService systemService;
    @Autowired
    private Environment environment;

    public void run(ApplicationArguments args) {
        try {
            Constants.SYSTEM_DATABASE_TYPE = ConfigUtils.getSystemDatabaseType((Environment)this.environment);
            logger.info("\u6570\u636e\u5e93\u7c7b\u578b\u4e3a:{} \u83b7\u53d6\u6210\u529f\uff01", (Object)Constants.SYSTEM_DATABASE_TYPE);
            Config config = this.systemService.getConfigFile("config.json");
            if (0 != config.getInitStep()) {
                logger.info("\u5bc6\u7801\u673a\u5df2\u521d\u59cb\u5316\u5b8c\u6210\uff0c\u52a0\u8f7dGMSSL\uff01");
                if (2 == CommonVariable.getIsHsm()) {
                    GMSSLPkiCryptoInit.getSancHsmInstance();
                } else if (1 == CommonVariable.getIsHsm()) {
                    GMSSLPkiCryptoInit.getXdjaYunHsmInstance();
                } else if (3 == CommonVariable.getIsHsm()) {
                    GMSSLPkiCryptoInit.getHsmInstance();
                }
            } else {
                logger.info("\u5bc6\u7801\u673a\u6682\u672a\u521d\u59cb\u5316\uff01");
            }
            logger.info("cpu\u8d44\u6e90\u76d1\u63a7\u5f00\u59cb");
            this.applicationInitService.monitorCpuForQuarter();
            logger.info("\u52a0\u8f7d\u5b9a\u65f6\u5907\u4efd\u914d\u7f6e\u6587\u4ef6");
            this.applicationInitService.initBackupConfig();
            logger.info("\u52a0\u8f7d\u5ba1\u8ba1\u65e5\u5fd7\u5f52\u6863\u914d\u7f6e\u6587\u4ef6");
            this.applicationInitService.initArchiveConfig();
            logger.info("\u52a0\u8f7d\u5ba1\u8ba1\u65e5\u5fd7\u5ba1\u8ba1\u5468\u671f\u914d\u7f6e\u6587\u4ef6");
            this.applicationInitService.initPeriodAuditConfig();
            logger.info("\u5904\u7406\u5f02\u5e38\u5907\u4efd\u8bb0\u5f55");
            int count = this.backupService.cleanErrorBackup();
            if (logger.isDebugEnabled()) {
                logger.debug("\u5904\u7406\u5f02\u5e38\u5907\u4efd\u8bb0\u5f55:\u6e05\u9664\u8bb0\u5f55\u6570[{}]", (Object)count);
            }
            logger.info("\u542f\u52a8\u8ba2\u9605\u7ebf\u7a0b");
            this.subscriberThread.start();
        }
        catch (Exception e) {
            logger.error("\u52a0\u8f7d\u5907\u4efd\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            System.exit(1);
        }
    }
}

