package com.xdja.ra.bean;


import com.xdja.ra.error.ErrorEnum;
import org.apache.commons.lang3.StringUtils;

/**
 * RA-SDK 结果返回errorMsg： code + 中文描述
 *
 * @author: ggp
 * @Date: 2019/11/1 13:59
 * @Description:
 */
public class Result {

    /**
     * 错误返回对象
     */
    public ErrorMsg errorMsg;
    /**
     * 成功时 返回数据对象
     */
    private Object info;
    /**
     * true 成功  false失败
     */
    public static Boolean isSuccess = true;

    public ErrorMsg getErrorMsg() {
        return errorMsg;
    }

    public void setErrorMsg(ErrorMsg errorMsg) {
        this.setSuccess(false);
        this.errorMsg = errorMsg;
    }

    public Object getInfo() {
        return info;
    }

    public void setInfo(Object info) {
        this.info = info;
    }

    public Result() {
    }

    /**
     * 构造函数 成功
     *
     * @param info 返回业务数据
     */
    public static Result success(Object info) {
        Result result = new Result();
        result.setSuccess(true);
        result.setInfo(info);
        return result;
    }
    /**
     * 构造函数 成功
     *
     */
    public static Result success() {
        Result result = new Result();
        result.setSuccess(true);
        return result;
    }


    /**
     * 构造函数 失败
     *
     * @param errorEnum 执行结果代码 枚举
     */

    public static Result failure(ErrorEnum errorEnum) {
        return failure(errorEnum.code, errorEnum.errMsg);
    }

    /**
     * 构造函数 失败
     *
     * @param errorCode 业务异常枚举
     * @param errorMsg  错误描述
     */
    public static Result failure(Integer errorCode, String errorMsg) {
        ErrorMsg msg = new ErrorMsg(errorCode, errorMsg);
        Result result = new Result();
        result.setErrorMsg(msg);
        return result;
    }

    /**
     * 兼容
     *
     * @return
     */
    public Boolean isSuccess() {
        return isSuccess;
    }

    public void setSuccess(Boolean success) {
        isSuccess = success;
    }

    @Override
    public String toString() {
        return "Result{" +
                "errorMsg=" + errorMsg +
                ", info=" + info +
                ", isSuccess=" + isSuccess +
                '}';
    }
}
