package com.xdja.ra.error;

import org.apache.commons.lang3.StringUtils;


/**
 * 系统共用异常枚举定义
 *
 * @author wly
 *
 */
public enum ErrorEnum {

	/**
	 * ra-sdk 错误码
	 */
	MISSING_REQUIRED_PARAMETERS(400, 10001, "missing_required_parameters", "缺少必要请求参数"),
	ILLEGAL_REQUEST_PARAMETER(400, 10002, "illegal_request_parameter", "非法请求参数"),
	WRITE_OR_READ_CONFIG_FILE_FAIL(400, 10006, "write_or_read_config_file_fail", "读写配置文件失败"),

	SDK_INNER_EXCEPTION(400, 10003, "sdk_inner_exception", "SDK内部异常"),
	RA_OPEN_API_RETURN_EXCEPTION(400, 10004, "ra_open_api_return_exception", "Ra的外部接口返回异常"),
	RA_OPEN_API_RETURN_INFO_IS_EMPTY(400, 10005, "ra_open_api_return_info_is_empty", "RA的外部接口返回数据为空"),
	P10_GET_PUBLIC_ERROR(400, 10007, "p10_get_public_error", "P10获取公钥异常"),

	RA_SERVICE_INNER_EXCEPTION(400, 10008, "ra_service_inner_exception", "RA-service内部异常"),
	CA_RETURN_USER_CERT_INFO_ERROR(400, 10009, "ca_return_user_cert_info_error", "RA收到CA返回的用户证书信息异常"),
	RA_OPEN_API_INNER_EXCEPTION(400, 10010, "ra_open_api_inner_exception", "RA的外部接口内部异常"),


	/**
	 * CMP相关错误码
	 */
	MAKE_CERT_CONFIRM_CONTENT_EXCEPTION(400, 40001, "make_cert_confirm_content_exception", "封装CertConfirmContent异常"),
	NO_PROTECTION_ALG_IN_PKI_HEADER(400, 40002, "no_protection_alg_in_pki_header", "没有保护算法在pki消息头部"),
	VERIFY_CERT_CONVERSION_ERROR(400, 40003, "verify_cert_conversion_error", "验证证书转换异常"),
	VERIFY_RESP_MESSAGE_ERROR(400, 40004, "verify_resp_message_error", "验证resp消息异常"),
	VERIFY_PKI_MESSAGE_PROTECTION_ERROR(400, 40005, "verify_pki_message_protection_error", "校验pki消息保护失败"),
	CONVERT_CERT_ERROR(400, 40006, "convert_cert_error", "解析证书链错误"),
	GMSSL_HTTP_CLIENT_INTER_EXCEPTION(400, 40007, "gmssl_http_client_inter_exception", "国密安全通道工具类异常"),
	GET_CMP_RANDOM_IS_EXCEPTION(400, 40008, "get_cmp_random_is_exception", "获取CMP请求随机数异常"),
	MAKE_CERT_REQUEST_EXCEPTION(400, 40010, "make_cert_request_exception", "封装certRequest异常"),
	MAKE_CERT_REQUEST_MESSAGE_EXCEPTION(400, 40011, "make_cert_request_message_exception", "封装certReqMessages异常"),
	MAKE_PKI_MESSAGE_EXCEPTION(400, 40012, "make_pki_message_exception", "封装PKIMessage异常"),
	SEND_HTTP_MESSAGE_EXCEPTION(400, 40013, "send_http_message_exception", "发送Http消息异常"),
	NO_PKI_MESSAGE_RESP_MESSAGE(400, 40014, "no_pki_message_resp_message", "No pkiMessage response message"),
	NO_HEADER_IN_RESPONSE_MESSAGE(400, 40015, "no_header_in_response_message", "No header in response message"),
	WRONG_LEN_OF_RECEIVED_RECIP_NONCE(400, 40016, "wrong_len_of_received_recip_nonce", "收到的recipNonce的长度不是16位"),
	WRONG_LEN_OF_RECEIVED_SENDER_NONCE(400, 40017, "wrong_len_of_received_sender_nonce", "Wrong length of received sender nonce"),
	RECIPIENT_NONCE_NOT_THE_SAME_AS_WE_SENT(400, 40018, "recipient_nonce_not_the_same_as_we_sent", "recipient nonce not the same as we sent"),
	TRANS_ID_IS_NOT_THE_SAME_AS_WE_SENT(400, 40019, "trans_id_is_not_the_same_as_we_sent", "transid is not the same as the one we sent"),
	ERROR_MSG_CONTENT_EXCEPTION(400, 40020, "error_msg_content_exception", "封装ErrorMsgContent异常"),
	RESOLVE_CERT_REP_MESSAGE_EXCEPTION(400, 40022, "resolve_cert_rep_message_exception", "解析CertRepMessage异常"),
	RESOLVE_REV_REP_CONTENT_EXCEPTION(400, 40023, "resolve_rev_rep_content_exception", "解析RevRepContent异常"),
	RA_NOT_SUPPORT_THIS_CERT_BODY_TAG(400, 40024, "ra_not_support_this_cert_body_tag", "RA 暂不支持解析当前类型的CMP请求"),
	NO_CERT_REQ_MESSAGE_RECEIVED(400, 40025, "no_cert_req_message_received", "No CertRepMessage for certificate received."),
	NO_CERT_RESPONSE_MESSAGE_RECEIVED(400, 40026, "no_cert_response_message_received", "No CertResponse for certificate received"),
	NO_RA_SEND_TRANS_ID(400, 11027, "no_ra_send_trans_id", "No ra send transId"),
	RA_RECEIVED_CERT_REQ_ID_IS_ERROR(400, 40028, "ra_received_cert_req_id_is_error", "Received CertReqId is ERROR"),
	NO_PKI_STATUS_INFO_FOR_RECEIVE(400, 40029, "no_pki_status_info_for_receive", "No PKIStatusInfo for certificate received."),
	RECEIVED_STATUS_IS_NOT_0(400, 40030, "received_status_is_not_0", "Received Status is not 0"),
	NO_CERTIFIED_KEY_PAIR_FOR_RECEIVED(400, 40031, "no_certified_key_pair_for_received", "No CertifiedKeyPair for certificate received."),
	NO_CERT_OR_ENC_CERT_FOR_RECEIVED(400, 40032, "no_cert_or_enc_cert_for_received", "No CertOrEncCert for certificate received."),
	NO_X509_CERT_FOR_RECEIVED(400, 40033, "no_x509_cert_for_receive", "No X509CertificateStructure for certificate received."),
	NO_ENCODE_CERT_FOR_RECEIVED(400, 40034, "no_encode_cert_for_received", "No encoded certificate received"),
	CMP_CERT_ENCODE_EXCEPTION(400, 40035, "cmp_cert_encode_exception", "CMPCertificate Encode Exception."),
	NOT_POSSIBLE_TO_CREATE_CERT(400, 40036, "not_possible_to_create_cert", "Not possible to create certificate."),
	CERT_P7B_VERIFY_ERROR(400, 40037, "cert_p7b_verify_error", "验证P7b证书链错误"),
	CERT_IS_NOT_VALID(400, 40038, "cert_is_not_valid", "证书不在有效期"),
	LOCAL_CMP_CACHE_IS_EMPTY(400, 40039, "local_cmp_cache_is_empty", "本地缓存CMP数据为空"),
	CANNOT_GET_TRANS_ID_FORM_LOCAL_CACHE(400, 40040, "cannot_get_trans_id_from_local_cache", "不能从本地缓存获取到发送的transId"),
	GET_RANDOM_BY_SECURERANDOM_EXCEPTION(400, 40041, "get_random_by_securerandom_exception", "通过secureRandom获取随机数异常"),
	PROTECTION_ALG_IS_NOT_SUPPORT(400, 40042, "protection_alg_is_not_support", "保护算法不支持");

	/**
	 * HTTP状态码
	 */
	private int status;
	/**
	 * 异常信息对象
	 */
	private ErrorBean errorBean;
	/**
	 * 异常描述
	 */
	public String desc;
	/**
	 * 异常描述  英文
	 */
	public String errMsg;
	/**
	 * 错误码 syg
	 */
	public int code;

	ErrorEnum(int status, int errCode, String errMsg, String desc) {
		this.status = status;
		this.errorBean = new ErrorBean(errCode, errMsg);
		this.code = errCode;
		this.desc = desc;
		this.errMsg = errMsg;
	}

	public static ErrorEnum getErrorEnumByCode(String errCode) {
		for (ErrorEnum errorEnum : values()) {
			if (StringUtils.equals(String.valueOf(errorEnum.code), errCode)) {
				return errorEnum;
			}
		}
		return null;
	}
}
