/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.asn1;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class EccCipherBlob
extends ASN1Object {
    private ASN1OctetString xCoordinate;
    private ASN1OctetString yCoordinate;
    private ASN1OctetString hash;
    private ASN1Integer cipherLen;
    private ASN1OctetString cipherText;

    public static EccCipherBlob getInstance(Object o) {
        if (o instanceof EccCipherBlob) {
            return (EccCipherBlob)((Object)o);
        }
        if (o != null) {
            return new EccCipherBlob(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public EccCipherBlob(ASN1Sequence eccCipherBlobSequence) {
        Enumeration e = eccCipherBlobSequence.getObjects();
        this.xCoordinate = ASN1OctetString.getInstance(e.nextElement());
        this.yCoordinate = ASN1OctetString.getInstance(e.nextElement());
        this.hash = ASN1OctetString.getInstance(e.nextElement());
        this.cipherLen = ASN1Integer.getInstance(e.nextElement());
        this.cipherText = ASN1OctetString.getInstance(e.nextElement());
    }

    public EccCipherBlob(ASN1OctetString xCoordinate, ASN1OctetString yCoordinate, ASN1OctetString hash, ASN1Integer cipherLen, ASN1OctetString cipherText) {
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
        this.hash = hash;
        this.cipherLen = cipherLen;
        this.cipherText = cipherText;
    }

    public EccCipherBlob(byte[] x, byte[] y, byte[] hash, int cipherLen, byte[] cipherText) {
        this.xCoordinate = new DEROctetString(x);
        this.yCoordinate = new DEROctetString(y);
        this.hash = hash == null ? null : new DEROctetString(hash);
        this.cipherLen = new ASN1Integer((long)cipherLen);
        this.cipherText = new DEROctetString(cipherText);
    }

    public byte[] getxCoordinate() {
        return this.xCoordinate.getOctets();
    }

    public byte[] getyCoordinate() {
        return this.yCoordinate.getOctets();
    }

    public byte[] getHash() {
        return this.hash.getOctets();
    }

    public BigInteger getCipherLen() {
        return this.cipherLen.getValue();
    }

    public byte[] getCipherText() {
        return this.cipherText.getOctets();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.xCoordinate);
        vector.add((ASN1Encodable)this.yCoordinate);
        vector.add((ASN1Encodable)this.hash);
        vector.add((ASN1Encodable)this.cipherLen);
        vector.add((ASN1Encodable)this.cipherText);
        return new DERSequence(vector);
    }
}

