/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.asn1;

import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;

public class EccPublicKeyBlob
extends ASN1Object {
    private ASN1Integer bitLen;
    private ASN1OctetString xCoordinate;
    private ASN1OctetString yCoordinate;

    public static EccPublicKeyBlob getInstance(Object o) {
        if (o instanceof EccPublicKeyBlob) {
            return (EccPublicKeyBlob)((Object)o);
        }
        if (o != null) {
            return new EccPublicKeyBlob(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public EccPublicKeyBlob(ASN1Sequence eccPublicKeyBlobSequence) {
        Enumeration e = eccPublicKeyBlobSequence.getObjects();
        this.bitLen = ASN1Integer.getInstance(e.nextElement());
        this.xCoordinate = ASN1OctetString.getInstance(e.nextElement());
        this.yCoordinate = ASN1OctetString.getInstance(e.nextElement());
    }

    public EccPublicKeyBlob(ASN1Integer bitLen, ASN1OctetString xCoordinate, ASN1OctetString yCoordinate) {
        this.bitLen = bitLen;
        this.xCoordinate = xCoordinate;
        this.yCoordinate = yCoordinate;
    }

    public EccPublicKeyBlob(int bigLen, byte[] x, byte[] y) {
        this.bitLen = new ASN1Integer((long)bigLen);
        this.xCoordinate = new DEROctetString(x);
        this.yCoordinate = new DEROctetString(y);
    }

    public byte[] getxCoordinate() {
        return this.xCoordinate.getOctets();
    }

    public byte[] getyCoordinate() {
        return this.yCoordinate.getOctets();
    }

    public BigInteger getBitLen() {
        return this.bitLen.getValue();
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.bitLen);
        vector.add((ASN1Encodable)this.xCoordinate);
        vector.add((ASN1Encodable)this.yCoordinate);
        return new DERSequence(vector);
    }
}

