/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.asn1;

import com.xdja.ra.asn1.EccCipherBlob;
import com.xdja.ra.asn1.EccPublicKeyBlob;
import java.math.BigInteger;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;

public class SkfEnvelopedKeyBlob
extends ASN1Object {
    private ASN1Integer version;
    private AlgorithmIdentifier ulSymmAlgID;
    private ASN1Integer ulBits;
    private ASN1OctetString cbEncryptedPriKey;
    private EccPublicKeyBlob pubKey;
    private EccCipherBlob eccCipherBlob;

    public static SkfEnvelopedKeyBlob getInstance(Object o) {
        if (o instanceof SkfEnvelopedKeyBlob) {
            return (SkfEnvelopedKeyBlob)((Object)o);
        }
        if (o != null) {
            return new SkfEnvelopedKeyBlob(ASN1Sequence.getInstance((Object)o));
        }
        return null;
    }

    public SkfEnvelopedKeyBlob(ASN1Sequence skfEnvelopedKeyBlobSequence) {
        Enumeration e = skfEnvelopedKeyBlobSequence.getObjects();
        this.version = ASN1Integer.getInstance(e.nextElement());
        this.ulSymmAlgID = AlgorithmIdentifier.getInstance(e.nextElement());
        this.ulBits = ASN1Integer.getInstance(e.nextElement());
        this.cbEncryptedPriKey = ASN1OctetString.getInstance(e.nextElement());
        this.pubKey = EccPublicKeyBlob.getInstance(e.nextElement());
        this.eccCipherBlob = EccCipherBlob.getInstance(e.nextElement());
    }

    public SkfEnvelopedKeyBlob(ASN1Integer version, AlgorithmIdentifier ulSymmAlgID, ASN1Integer ulBits, ASN1OctetString cbEncryptedPriKey, EccPublicKeyBlob eccPublicKeyBlob, EccCipherBlob eccCipherBlob) {
        this.version = version;
        this.ulSymmAlgID = ulSymmAlgID;
        this.ulBits = ulBits;
        this.cbEncryptedPriKey = cbEncryptedPriKey;
        this.pubKey = this.pubKey;
        this.eccCipherBlob = eccCipherBlob;
    }

    public SkfEnvelopedKeyBlob(int version, ASN1ObjectIdentifier ulSymmAlgID, int ulBits, byte[] cbEncryptedPriKey, EccPublicKeyBlob eccPublicKeyBlob, EccCipherBlob eccCipherBlob) {
        this.version = new ASN1Integer((long)version);
        this.ulSymmAlgID = new AlgorithmIdentifier(ulSymmAlgID);
        this.ulBits = new ASN1Integer((long)ulBits);
        this.cbEncryptedPriKey = new DEROctetString(cbEncryptedPriKey);
        this.pubKey = eccPublicKeyBlob;
        this.eccCipherBlob = eccCipherBlob;
    }

    public BigInteger getVersion() {
        return this.version.getValue();
    }

    public ASN1ObjectIdentifier getUlSymmAlgID() {
        return this.ulSymmAlgID.getAlgorithm();
    }

    public BigInteger getUlBits() {
        return this.ulBits.getValue();
    }

    public byte[] getCbEncryptedPriKey() {
        return this.cbEncryptedPriKey.getOctets();
    }

    public EccPublicKeyBlob getPubKey() {
        return this.pubKey;
    }

    public EccCipherBlob getEccCipherBlob() {
        return this.eccCipherBlob;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector vector = new ASN1EncodableVector();
        vector.add((ASN1Encodable)this.version);
        vector.add((ASN1Encodable)this.ulSymmAlgID);
        vector.add((ASN1Encodable)this.ulBits);
        vector.add((ASN1Encodable)this.cbEncryptedPriKey);
        vector.add((ASN1Encodable)this.pubKey);
        vector.add((ASN1Encodable)this.eccCipherBlob);
        return new DERSequence(vector);
    }
}

