/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.xdja.pki.apache.client.core.ClientErrorEnum;
import com.xdja.pki.apache.client.core.ClientKeyStoreConfig;
import com.xdja.pki.apache.client.result.AdaptClientResult;
import com.xdja.pki.apache.client.result.RAClientResult;
import com.xdja.pki.apache.client.utils.ApacheClientHttpUtils;
import com.xdja.pki.core.utils.TimeMonitor;
import com.xdja.ra.bean.ApplyRep;
import com.xdja.ra.bean.BaseCertApply;
import com.xdja.ra.bean.CertApplyInfo;
import com.xdja.ra.bean.CertBaseInfo;
import com.xdja.ra.bean.CheckApply;
import com.xdja.ra.bean.Config;
import com.xdja.ra.bean.DoubleCode;
import com.xdja.ra.bean.EditCertApplyInfo;
import com.xdja.ra.bean.ErrorMsg;
import com.xdja.ra.bean.FreezeApply;
import com.xdja.ra.bean.IssueApply;
import com.xdja.ra.bean.KeyStoreConfig;
import com.xdja.ra.bean.RecoveryApply;
import com.xdja.ra.bean.Result;
import com.xdja.ra.bean.RevokeApply;
import com.xdja.ra.bean.TemplateInfo;
import com.xdja.ra.bean.UpdateApply;
import com.xdja.ra.bean.UserCertInfo;
import com.xdja.ra.bean.UserCertReq;
import com.xdja.ra.bean.UserCertStr;
import com.xdja.ra.bean.UserInfo;
import com.xdja.ra.constant.SdkConstants;
import com.xdja.ra.ennum.ReqMethodEnum;
import com.xdja.ra.ennum.SignatureAlgorithmEnum;
import com.xdja.ra.error.ErrorEnum;
import com.xdja.ra.sdk.RaCmpApi;
import com.xdja.ra.sdk.param.GetUserInfoParam;
import com.xdja.ra.sdk.param.ISdkServiceParam;
import com.xdja.ra.sdk.param.QueryUserCertListParam;
import com.xdja.ra.sdk.param.UpdateUserInfoParam;
import com.xdja.ra.sdk.param.UpdateUserStatusParam;
import com.xdja.ra.utils.CertUtils;
import com.xdja.ra.utils.FileUtils;
import com.xdja.ra.utils.KeyStoreUtils;
import com.xdja.ra.utils.SdkJsonUtils;
import com.xdja.ra.utils.SignUtils;
import com.xdja.ra.utils.SignedDataUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;

public class SDKService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    private static final Object LOCK_TRANS_ID = "transId";
    private static SDKService sdkService;
    public static Config config;

    public static SDKService getInstance() {
        return sdkService;
    }

    public SDKService(Config config) {
        SDKService.config = config;
    }

    public SDKService(String serverIp, String serverPort, String prikeyPath, String prikeyPwd, String trustCertPath, String systemFlag) {
        try {
            config = new Config();
            config.setServerIp(serverIp);
            config.setServerPort(serverPort);
            config.setPrikeyPath(prikeyPath);
            config.setPriKeyPwd(prikeyPwd);
            config.setTrustCertPath(trustCertPath);
            config.setSystemFlag(systemFlag);
            this.init();
            SignUtils.sign(config.getSignName(), config.getPrivateKey(), "init");
            JSON.toJSONString((Object)new UserInfo());
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316SDK\u5931\u8d25", e);
        }
    }

    public SDKService(String serverIp, String serverPort, boolean isHttps, String prikeyPath, String prikeyPwd, String trustCertPath, String systemFlag) {
        try {
            new SDKService(serverIp, serverPort, prikeyPath, prikeyPwd, trustCertPath, systemFlag);
            config.setHttps(isHttps);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316SDK\u5931\u8d25", e);
        }
    }

    public SDKService(String serverIp, String serverPort, boolean isHttps, String systemFlag, KeyStoreConfig keyStoreConfig) {
        try {
            new SDKService(serverIp, serverPort, keyStoreConfig.getClientKeyStorePath(), keyStoreConfig.getClientKeyStorePwd(), null, systemFlag);
            config.setHttps(isHttps);
            config.setKeyStoreConfig(keyStoreConfig);
            X509Certificate[] trustCerts = KeyStoreUtils.getTrustCertFromP12(keyStoreConfig.getTrustKeyStorePwd(), keyStoreConfig.getClientKeyStorePath());
            config.setTrustCert(trustCerts);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316SDK\u5931\u8d25", e);
        }
    }

    public SDKService(String serverIp, String serverPort, boolean isHttps, String prikeyPath, String prikeyPwd, String trustCertPath, String systemFlag, KeyStoreConfig keyStoreConfig) {
        try {
            new SDKService(serverIp, serverPort, prikeyPath, prikeyPwd, trustCertPath, systemFlag);
            config.setHttps(isHttps);
            config.setKeyStoreConfig(keyStoreConfig);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            throw new RuntimeException("\u521d\u59cb\u5316SDK\u5931\u8d25", e);
        }
    }

    public SDKService(String serverIp, String serverPort, boolean isHttps, String prikeyPath, String prikeyPwd, String trustCertPath, String systemFlag, KeyStoreConfig keyStoreConfig, boolean isUseHsm) {
        new SDKService(serverIp, serverPort, isHttps, prikeyPath, prikeyPwd, trustCertPath, systemFlag, keyStoreConfig);
        config.setUseHsm(isUseHsm);
    }

    private void init() {
        try {
            String baseUrl = config.getServerIp() + ":" + config.getServerPort() + "/ra-openapi";
            config.setRaBaseUrl(baseUrl);
            X509Certificate cert = (X509Certificate)KeyStoreUtils.getPublicKeyFromP12(null, config.getPrikeyPath(), config.getPriKeyPwd());
            config.setSystemCert(cert);
            config.setUserCertSn(cert.getSerialNumber().toString(16));
            config.setCertSignAlgOid(cert.getSigAlgOID());
            if (null == cert.getSigAlgName()) {
                config.setSignName(SignatureAlgorithmEnum.getName(config.getCertSignAlgOid()));
            } else {
                config.setSignName(cert.getSigAlgName());
            }
            if (null != config.getTrustCertPath()) {
                List<X509Certificate> certs = null;
                try {
                    String trustCertP7b = FileUtils.read(config.getTrustCertPath());
                    byte[] base64Bytes = Base64.decode((String)trustCertP7b);
                    certs = CertUtils.getCertListFromP7b(base64Bytes);
                }
                catch (Exception e) {
                    byte[] trustCertP7b = FileUtils.readByBinary(config.getTrustCertPath());
                    certs = SignedDataUtils.resolveCertChain(trustCertP7b);
                }
                X509Certificate[] caCerts = new X509Certificate[certs.size()];
                for (int i = 0; i < certs.size(); ++i) {
                    caCerts[i] = certs.get(i);
                }
                config.setTrustCert(caCerts);
            }
            PrivateKey privateKey = SignUtils.getPrivateKeyFromP12(config.getPrikeyPath(), config.getPriKeyPwd().toCharArray());
            config.setPrivateKey(privateKey);
            sdkService = new SDKService(config);
        }
        catch (Exception e) {
            this.logger.error("\u521d\u59cb\u5316SDKService\u5f02\u5e38", (Throwable)e);
        }
    }

    public Result registUser(Integer userType, UserInfo userInfo) {
        try {
            String reqUrl = "/v1/ra-openapi/user/" + userType;
            if (StringUtils.isNotBlank((CharSequence)userInfo.getSystemFlag())) {
                reqUrl = "/v1/ra-openapi/user/cross/" + userType;
            }
            String source = reqUrl + JSON.toJSONString((Object)userInfo);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.POST.name, JSON.toJSONString((Object)userInfo));
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getUserInfo(Integer userType, Integer identType, String identNumber) {
        try {
            String reqUrl = "/v1/ra-openapi/user/" + userType + "/" + identType + "/" + identNumber;
            return this.getUser(reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getUserInfo(String sn) {
        try {
            String reqUrl = "/v1/ra-openapi/user/" + sn;
            return this.getUser(reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    private Result getUser(String reqUrl) throws Exception {
        String source = reqUrl;
        Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
        if (result.isSuccess().booleanValue() && null != result.getInfo()) {
            UserInfo userInfo = (UserInfo)JSON.parseObject((String)new String((byte[])result.getInfo()), UserInfo.class);
            result.setInfo(userInfo);
        } else {
            result.setInfo(null);
        }
        return result;
    }

    public Result updateUserInfo(Integer userType, Integer identType, String identNumber, UserInfo userInfo) {
        try {
            String reqUrl = "/v1/ra-openapi/user/" + userType + "/" + identType + "/" + identNumber;
            String source = reqUrl + JSON.toJSONString((Object)userInfo);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)userInfo));
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result updateUserStatus(Integer userType, Integer identType, String identNumber, Integer userStatus) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/user/" + userType + "/" + identType + "/" + identNumber + "/" + userStatus;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, null);
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getRASystemBaseDn() {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/baseDn";
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                result.setInfo(new String((byte[])result.getInfo()));
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getTemplateInfoList(String systemFlag) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/template/" + systemFlag;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                List templateInfoList = JSON.parseArray((String)new String((byte[])result.getInfo()), TemplateInfo.class);
                result.setInfo(templateInfoList);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startIssueUserCertApply(IssueApply issueApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/issue";
            return this.getApplyResult(JSON.toJSONString((Object)issueApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startUpdateUserCertApply(UpdateApply updateApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/update";
            return this.getApplyResult(JSON.toJSONString((Object)updateApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startRevokeUserCertApply(RevokeApply revokeApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/revoke";
            return this.getApplyResult(JSON.toJSONString((Object)revokeApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startRecoveryUserCertApply(RecoveryApply recoveryApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/recovery";
            return this.getApplyResult(JSON.toJSONString((Object)recoveryApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result startFreezeOrUnFreezeUserCertApply(FreezeApply freezeApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/freeze";
            return this.getApplyResult(JSON.toJSONString((Object)freezeApply), reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result checkUserCertApply(Integer applyType, String applyNo, CheckApply checkApply) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/check/" + applyType + "/" + applyNo;
            String source = reqUrl + JSON.toJSONString((Object)checkApply);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)checkApply));
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                DoubleCode doubleCode = (DoubleCode)JSON.parseObject((String)new String((byte[])result.getInfo()), DoubleCode.class);
                result.setInfo(doubleCode);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result generateUserCert(Integer applyType, String applyNo, UserCertReq userCertReq) {
        return this.generateUserCert(applyType, applyNo, userCertReq, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Result generateUserCert(Integer applyType, String applyNo, UserCertReq userCertReq, Integer keyFormat) {
        Result sdkResult;
        String transId;
        Result result = new Result();
        if (applyType == null || userCertReq == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{applyNo, userCertReq.getAuthCode(), userCertReq.getRefCode()})) {
            return Result.failure(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        if (applyType != 1 && applyType != 2 && applyType != 4) {
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        if (keyFormat == null) {
            keyFormat = SdkConstants.KEY_FORMAT_0010_1;
        } else {
            if (!(keyFormat.equals(SdkConstants.KEY_FORMAT_0010_1) || keyFormat.equals(SdkConstants.KEY_FORMAT_0016_2) || keyFormat.equals(SdkConstants.KEY_FORMAT_0016_3))) {
                return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
            }
            if (!applyType.equals(1) && !applyType.equals(2)) {
                return Result.failure(ErrorEnum.APPLY_TYPE_CANNOT_SUPPORT_KEY_FORMAT);
            }
        }
        Object object = LOCK_TRANS_ID;
        synchronized (object) {
            transId = String.valueOf(System.nanoTime()) + (ThreadLocalRandom.current().nextLong(0L, 9999999L) + 90000000L);
        }
        RaCmpApi raCmpApi = new RaCmpApi();
        try {
            KeyStoreConfig keyStoreConfig = config.getKeyStoreConfig();
            ClientKeyStoreConfig clientKeyStoreConfig = null;
            if (keyStoreConfig != null) {
                clientKeyStoreConfig = new ClientKeyStoreConfig();
                BeanUtils.copyProperties((Object)keyStoreConfig, (Object)clientKeyStoreConfig);
            }
            sdkResult = raCmpApi.sendCertReqMessage(applyType, transId, config.getSystemFlag(), config.getCertSignAlgOid(), applyNo, userCertReq, keyFormat, clientKeyStoreConfig);
        }
        catch (Exception e) {
            this.logger.error("SDK\u5185\u90e8\u5f02\u5e38", (Throwable)e);
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("SDKService.generateUserCert.result:{}", (Object)SdkJsonUtils.object2Json(sdkResult.getInfo()));
        }
        return this.getCmpResult(result, sdkResult);
    }

    public Result certApplyConfirmMsg(String applyNo) {
        Result sdkResult;
        Result result = new Result();
        RaCmpApi raCmpApi = new RaCmpApi();
        KeyStoreConfig keyStoreConfig = config.getKeyStoreConfig();
        ClientKeyStoreConfig clientKeyStoreConfig = null;
        if (keyStoreConfig != null) {
            clientKeyStoreConfig = new ClientKeyStoreConfig();
            BeanUtils.copyProperties((Object)keyStoreConfig, (Object)clientKeyStoreConfig);
        }
        try {
            sdkResult = raCmpApi.sendConfirmMessage(config.getCertSignAlgOid(), config.getSystemFlag(), applyNo, clientKeyStoreConfig);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
        return this.getCmpResult(result, sdkResult);
    }

    public Result generateUserCertAndConfirm(Integer applyType, String applyNo, UserCertReq userCertReq, Integer keyFormat) {
        TimeMonitor monitor = new TimeMonitor("ra-sdk generateUserCertAndConfirm\u6700\u5916\u5c42");
        monitor.start("\u5236\u8bc1");
        Result result = this.generateUserCert(applyType, applyNo, userCertReq, keyFormat);
        monitor.stop();
        if (result.isSuccess().booleanValue()) {
            monitor.start("\u786e\u8ba4");
            Result confirmResult = this.certApplyConfirmMsg(applyNo);
            monitor.stop();
            if (!confirmResult.isSuccess().booleanValue()) {
                return confirmResult;
            }
        }
        monitor.prettyPrint();
        return result;
    }

    public Result certApplyErrorMsg(String applyNo, ErrorMsg errorMsg) {
        Result sdkResult;
        Result result = new Result();
        RaCmpApi raCmpApi = new RaCmpApi();
        KeyStoreConfig keyStoreConfig = config.getKeyStoreConfig();
        ClientKeyStoreConfig clientKeyStoreConfig = null;
        if (keyStoreConfig != null) {
            clientKeyStoreConfig = new ClientKeyStoreConfig();
            BeanUtils.copyProperties((Object)keyStoreConfig, (Object)clientKeyStoreConfig);
        }
        try {
            sdkResult = raCmpApi.sendErrorMessage(applyNo, config.getCertSignAlgOid(), config.getSystemFlag(), errorMsg.getErrorMsg(), errorMsg.getErrorCode(), clientKeyStoreConfig);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
        return this.getCmpResult(result, sdkResult);
    }

    public Result getUserCertApplyInfo(Integer applyType, String applyNo) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/" + applyType + "/" + applyNo;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                CertApplyInfo certApplyInfo = (CertApplyInfo)JSON.parseObject((String)new String((byte[])result.getInfo()), CertApplyInfo.class);
                result.setInfo(certApplyInfo);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result baseCertApplyQuery(String applyNo) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/apply/" + applyNo;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                BaseCertApply baseCertApply = (BaseCertApply)JSON.parseObject((String)new String((byte[])result.getInfo()), BaseCertApply.class);
                result.setInfo(baseCertApply);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result editUserCertApplyInfo(Integer applyType, String applyNo, EditCertApplyInfo editCertApplyInfo) {
        try {
            String reqUrl = "/v1/ra-openapi/apply/" + applyType + "/" + applyNo;
            String source = reqUrl + JSON.toJSONString((Object)editCertApplyInfo);
            return this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)editCertApplyInfo));
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result queryUserCertInfoList(Integer userType, Integer identType, String identNumber) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/" + userType + "/" + identType + "/" + identNumber;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                List userCertInfoList = JSON.parseArray((String)new String((byte[])result.getInfo()), UserCertInfo.class);
                result.setInfo(userCertInfoList);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getUserCertBaseInfo(String certSn) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/" + certSn;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                CertBaseInfo certBaseInfo = (CertBaseInfo)JSON.parseObject((String)new String((byte[])result.getInfo()), CertBaseInfo.class);
                result.setInfo(certBaseInfo);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result downloadUserCertFile(String certSn) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/file/" + certSn;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (!result.isSuccess().booleanValue()) {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getUserCert(String certSn) {
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/base64/" + certSn;
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                UserCertStr userCertStr = (UserCertStr)JSON.parseObject((String)new String((byte[])result.getInfo()), UserCertStr.class);
                result.setInfo(userCertStr);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result getUserCertBatch(List<String> userIds) {
        try {
            String reqUrl = "/v1/ra-openapi/cert/batch";
            String source = reqUrl + JSON.toJSONString(userIds);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.POST.name, JSON.toJSONString(userIds));
            if (result.isSuccess().booleanValue()) {
                List data = (List)JSON.parseObject((String)new String((byte[])result.getInfo()), (TypeReference)new TypeReference<List<Map<String, Object>>>(){}, (Feature[])new Feature[0]);
                HashMap info = new HashMap();
                ArrayList<Object> certs = null;
                List tempCerts = null;
                for (Map item : data) {
                    String userId = String.valueOf(item.get("userId"));
                    certs = (ArrayList<Object>)info.get(userId);
                    if (null == certs) {
                        certs = new ArrayList<Object>();
                        info.put(userId, certs);
                    }
                    tempCerts = (List)item.get("certs");
                    for (JSONObject obj : tempCerts) {
                        certs.add(JSON.parseObject((String)obj.toString(), UserCertStr.class));
                    }
                }
                result.setInfo(info);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u6839\u636e\u7528\u6237\u6807\u8bc6\u6279\u91cf\u83b7\u53d6\u8bc1\u4e66\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
        }
    }

    private Result buildData(String reqUrl, String source, String methodName, String reqBody) throws UnsupportedEncodingException {
        String[] temp = reqUrl.split("/");
        StringBuilder urlBuilder = new StringBuilder();
        for (String str : temp) {
            urlBuilder.append(URLEncoder.encode(str, "UTF-8")).append("/");
        }
        String url = config.getRaBaseUrl() + urlBuilder.toString();
        String signData = SignUtils.sign(config.getSignName(), config.getPrivateKey(), source);
        HashMap<String, String> headerMap = new HashMap<String, String>();
        headerMap.put("systemFlag", config.getSystemFlag());
        headerMap.put("signAlg", config.getSignName());
        headerMap.put("signValue", signData);
        headerMap.put("signSn", config.getUserCertSn());
        KeyStoreConfig keyStoreConfig = config.getKeyStoreConfig();
        ClientKeyStoreConfig clientKeyStoreConfig = null;
        if (keyStoreConfig != null) {
            clientKeyStoreConfig = new ClientKeyStoreConfig();
            BeanUtils.copyProperties((Object)keyStoreConfig, (Object)clientKeyStoreConfig);
        }
        if (null == reqBody) {
            reqBody = "";
        }
        Result result = new Result();
        try {
            CloseableHttpResponse closeableHttpResponse = ApacheClientHttpUtils.sendApacheClientRequest((byte[])reqBody.getBytes(), null, headerMap, (String)url.substring(0, url.length() - 1), (String)"application/json", (String)config.getSignName(), (boolean)config.isHttps(), (String)methodName, (boolean)false, (ClientKeyStoreConfig)clientKeyStoreConfig);
            RAClientResult resultFromClientResponse = AdaptClientResult.getClientResponse((CloseableHttpResponse)closeableHttpResponse);
            if (!resultFromClientResponse.isSuccess().booleanValue()) {
                result.setErrorMsg(new ErrorMsg(resultFromClientResponse.getErrorMsg().getErrorCode(), resultFromClientResponse.getErrorMsg().getErrorMsg()));
                return result;
            }
            result.setInfo(resultFromClientResponse.getInfo());
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bf7\u6c42\u8fd4\u56de\u6570\u636e\u89e3\u6790\u5f02\u5e38", (Throwable)e);
            result.setErrorMsg(new ErrorMsg(ClientErrorEnum.RESOLVE_CLIENT_RESULT_EXCEPTION.code, ClientErrorEnum.RESOLVE_CLIENT_RESULT_EXCEPTION.desc));
            return result;
        }
    }

    private Result getApplyResult(String applyReq, String reqUrl) throws Exception {
        String source = reqUrl + applyReq;
        Result result = this.buildData(reqUrl, source, ReqMethodEnum.POST.name, applyReq);
        if (result.isSuccess().booleanValue() && null != result.getInfo()) {
            ApplyRep applyRep = (ApplyRep)JSON.parseObject((String)new String((byte[])result.getInfo()), ApplyRep.class);
            result.setInfo(applyRep);
        } else {
            result.setInfo(null);
        }
        return result;
    }

    private Result getCmpResult(Result result, Result sdkResult) {
        if (!sdkResult.isSuccess().booleanValue()) {
            if ("400".equals(String.valueOf(sdkResult.getErrorMsg().getErrorCode()).substring(0, 3))) {
                return Result.failure(ErrorEnum.SDK_INNER_EXCEPTION);
            }
            result.setErrorMsg(sdkResult.getErrorMsg());
            return result;
        }
        return Result.success(sdkResult.getInfo());
    }

    public Result getUserInfoAcrossSystemFlag(ISdkServiceParam param) {
        if (!(param instanceof GetUserInfoParam)) {
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        GetUserInfoParam userInfoParam = (GetUserInfoParam)param;
        int userType = userInfoParam.getBaseUserType();
        int identType = userInfoParam.getLicenseType();
        String identNumber = userInfoParam.getLicenseNum();
        String systemFlag = userInfoParam.getSystemFlag();
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{identNumber, systemFlag})) {
            return Result.failure(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        try {
            String reqUrl = "/v1/ra-openapi/user/cross/" + userType + "/" + identType + "/" + identNumber + "/" + systemFlag;
            return this.getUser(reqUrl);
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result updateUserInfoAcrossSystemFlag(ISdkServiceParam sdkServiceParam) {
        if (!(sdkServiceParam instanceof UpdateUserInfoParam)) {
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        UpdateUserInfoParam userInfoParam = (UpdateUserInfoParam)sdkServiceParam;
        int userType = userInfoParam.getBaseUserType();
        int identType = userInfoParam.getLicenseType();
        String identNumber = userInfoParam.getLicenseNum();
        UserInfo userInfo = userInfoParam.getUserInfo();
        if (userInfo == null || StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userInfo.getSystemFlag()})) {
            this.logger.error("userInfo \u6570\u636e\u672a\u586b\u5145\uff0c\u6216\u8005\u8de8\u5b9e\u4f53\u6807\u8bc6\u672a\u586b\u5145");
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        try {
            String reqUrl = "/v1/ra-openapi/user/cross/" + userType + "/" + identType + "/" + identNumber + "/" + userInfo.getSystemFlag();
            String source = reqUrl + JSON.toJSONString((Object)userInfo);
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, JSON.toJSONString((Object)userInfo));
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result updateUserStatusAcrossSystemFlag(ISdkServiceParam param) {
        if (!(param instanceof UpdateUserStatusParam)) {
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        UpdateUserStatusParam userStatusParam = (UpdateUserStatusParam)param;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{userStatusParam.getLicenseNum(), userStatusParam.getSystemFlag()})) {
            this.logger.error("\u8de8\u5b9e\u4f53\u4fee\u6539\u7528\u6237\u72b6\u6001\u7528\u6237\u8eab\u4efdid\u6216\u8de8\u5b9e\u4f53\u6807\u8bc6\u4e3a\u7a7a");
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/user/cross/" + userStatusParam.getUserType() + "/" + userStatusParam.getLicenseType() + "/" + userStatusParam.getLicenseNum() + "/" + userStatusParam.getUserStatus() + "/" + userStatusParam.getSystemFlag();
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.PUT.name, null);
            result.setInfo(null);
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }

    public Result queryUserCertListAcrossSystemFlag(ISdkServiceParam param) {
        if (!(param instanceof QueryUserCertListParam)) {
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        QueryUserCertListParam certListParam = (QueryUserCertListParam)param;
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{certListParam.getLicenseNum(), certListParam.getSystemFlag()})) {
            this.logger.error("\u8de8\u5b9e\u4f53\u4fee\u6539\u7528\u6237\u72b6\u6001\u7528\u6237\u8eab\u4efdid\u6216\u8de8\u5b9e\u4f53\u6807\u8bc6\u4e3a\u7a7a");
            return Result.failure(ErrorEnum.ILLEGAL_REQUEST_PARAMETER);
        }
        try {
            String reqUrl;
            String source = reqUrl = "/v1/ra-openapi/cert/cross/" + certListParam.getUserType() + "/" + certListParam.getLicenseType() + "/" + certListParam.getLicenseNum() + "/" + certListParam.getSystemFlag();
            Result result = this.buildData(reqUrl, source, ReqMethodEnum.GET.name, null);
            if (result.isSuccess().booleanValue() && null != result.getInfo()) {
                List userCertInfoList = JSON.parseArray((String)new String((byte[])result.getInfo()), UserCertInfo.class);
                result.setInfo(userCertInfoList);
            } else {
                result.setInfo(null);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("\u8bfb\u5199\u914d\u7f6e\u6587\u4ef6\u5931\u8d25", (Throwable)e);
            return Result.failure(ErrorEnum.WRITE_OR_READ_CONFIG_FILE_FAIL);
        }
    }
}

