/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.ra.asn1.NISTObjectIdentifiers;
import com.xdja.ra.asn1.RsaObjectIdentifiers;
import com.xdja.ra.asn1.SM2ObjectIdentifiers;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.text.MessageFormat;
import org.bouncycastle.asn1.edec.EdECObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkBCUtils {
    private static Logger logger = LoggerFactory.getLogger(SdkBCUtils.class.getClass());

    public static boolean verifyCertByBC(String protectionAlgId, PublicKey publicKey, byte[] sourceData, byte[] signData) throws Exception {
        boolean verifyResult = false;
        if (SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (RsaObjectIdentifiers.sha384WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA384_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (RsaObjectIdentifiers.sha512WithRSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA512_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (NISTObjectIdentifiers.sha256WithECDSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (NISTObjectIdentifiers.sha384WithECDSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (NISTObjectIdentifiers.sha512WithECDSA.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else if (EdECObjectIdentifiers.id_Ed25519.getId().equalsIgnoreCase(protectionAlgId)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.ED25519.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData);
        } else {
            logger.error("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5 OID {}", (Object)protectionAlgId);
            throw new Exception(MessageFormat.format("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5 OID {0}", protectionAlgId));
        }
        return verifyResult;
    }

    public static boolean verifyCertByBC(X509Certificate cert, PublicKey publicKey) throws Exception {
        String sigAlgOID = cert.getSigAlgOID();
        boolean verifyResult = false;
        if (SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (RsaObjectIdentifiers.sha384WithRSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA384_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (RsaObjectIdentifiers.sha512WithRSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA512_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (NISTObjectIdentifiers.sha256WithECDSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (NISTObjectIdentifiers.sha384WithECDSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA384_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (NISTObjectIdentifiers.sha512WithECDSA.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA512_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else if (EdECObjectIdentifiers.id_Ed25519.getId().equalsIgnoreCase(sigAlgOID)) {
            verifyResult = GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.ED25519.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature());
        } else {
            logger.error("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5 OID {}", (Object)sigAlgOID);
            throw new Exception(MessageFormat.format("\u4e0d\u652f\u6301\u7684\u7b97\u6cd5 OID {0}", sigAlgOID));
        }
        return verifyResult;
    }
}

