/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.helper;

import com.alibaba.fastjson.JSON;
import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.sdf.SdfSDKException;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.ra.asn1.DigestObjectIdentifiers;
import com.xdja.ra.asn1.NISTObjectIdentifiers;
import com.xdja.ra.asn1.RsaObjectIdentifiers;
import com.xdja.ra.asn1.SM2ObjectIdentifiers;
import com.xdja.ra.asn1.SignedAndEnvelopedData;
import com.xdja.ra.asn1.SymmetryObjectIdentifiers;
import com.xdja.ra.bean.BaseCMPInfo;
import com.xdja.ra.bean.Result;
import com.xdja.ra.bean.UserCertRep;
import com.xdja.ra.constant.SdkCommonVariable;
import com.xdja.ra.constant.SdkConstants;
import com.xdja.ra.error.ErrorEnum;
import com.xdja.ra.sdk.SDKService;
import com.xdja.ra.utils.DnUtil;
import com.xdja.ra.utils.SdkApacheClientUtils;
import com.xdja.ra.utils.SdkBCUtils;
import com.xdja.ra.utils.SdkCertUtils;
import com.xdja.ra.vo.FreeText;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Signature;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1GeneralizedTime;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1Integer;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERUTF8String;
import org.bouncycastle.asn1.cmp.CMPCertificate;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.CertOrEncCert;
import org.bouncycastle.asn1.cmp.CertRepMessage;
import org.bouncycastle.asn1.cmp.CertResponse;
import org.bouncycastle.asn1.cmp.CertStatus;
import org.bouncycastle.asn1.cmp.CertifiedKeyPair;
import org.bouncycastle.asn1.cmp.ErrorMsgContent;
import org.bouncycastle.asn1.cmp.KeyRecRepContent;
import org.bouncycastle.asn1.cmp.PKIBody;
import org.bouncycastle.asn1.cmp.PKIFreeText;
import org.bouncycastle.asn1.cmp.PKIHeader;
import org.bouncycastle.asn1.cmp.PKIHeaderBuilder;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.cmp.PKIStatus;
import org.bouncycastle.asn1.cmp.PKIStatusInfo;
import org.bouncycastle.asn1.cmp.RevRepContent;
import org.bouncycastle.asn1.cms.EncryptedContentInfo;
import org.bouncycastle.asn1.cms.IssuerAndSerialNumber;
import org.bouncycastle.asn1.cms.KeyTransRecipientInfo;
import org.bouncycastle.asn1.cms.RecipientIdentifier;
import org.bouncycastle.asn1.cms.SignerIdentifier;
import org.bouncycastle.asn1.cms.SignerInfo;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertReqMsg;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.crmf.EncryptedValue;
import org.bouncycastle.asn1.nist.NISTNamedCurves;
import org.bouncycastle.asn1.sec.SECObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Certificate;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.ExtensionsGenerator;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.X509KeyUsage;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKIMessageHelper {
    private static Logger logger = LoggerFactory.getLogger(PKIMessageHelper.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";

    public static Result checkCmpHeaderAndSign(byte[] pkiMessage, String transId, byte[] senderNonce) {
        PKIMessage respPkiMessage = PKIMessage.getInstance((Object)pkiMessage);
        if (respPkiMessage == null) {
            logger.info(" =================== No pkiMessage response message.");
            return Result.failure(ErrorEnum.NO_PKI_MESSAGE_RESP_MESSAGE);
        }
        PKIHeader header = respPkiMessage.getHeader();
        if (header == null) {
            logger.info(" =================== No header in response message.");
            return Result.failure(ErrorEnum.NO_HEADER_IN_RESPONSE_MESSAGE);
        }
        if (header.getRecipNonce().getOctets().length != 16) {
            logger.info("\u68c0\u67e5\u6d88\u606f\u5934\u548c\u7b7e\u540d ====== Wrong length of received recip nonce (made up by server). Is " + header.getRecipNonce().getOctets().length + " byte but should be 16.");
            return Result.failure(ErrorEnum.WRONG_LEN_OF_RECEIVED_RECIP_NONCE);
        }
        String recipient = header.getRecipient().getName().toString();
        logger.info("\u7b2c\u4e09\u65b9\u552f\u4e00\u6807\u8bc6normal ========== " + recipient);
        String s = new String(header.getTransactionID().getOctets());
        if (!transId.equalsIgnoreCase(s)) {
            logger.info(" =================== transid is not the same as the one we sent");
            return Result.failure(ErrorEnum.TRANS_ID_IS_NOT_THE_SAME_AS_WE_SENT);
        }
        if (header.getSenderNonce().getOctets().length != 16) {
            logger.info(" =================== Wrong length of received sender nonce (made up by server). Is " + header.getSenderNonce().getOctets().length + " byte but should be 16.");
            return Result.failure(ErrorEnum.WRONG_LEN_OF_RECEIVED_SENDER_NONCE);
        }
        if (!Arrays.equals(header.getSenderNonce().getOctets(), senderNonce)) {
            logger.info(" =================== recipient nonce not the same as we sent away as the sender nonce. Sent: " + Arrays.toString(senderNonce) + " Received: " + Arrays.toString(header.getRecipNonce().getOctets()));
            return Result.failure(ErrorEnum.RECIPIENT_NONCE_NOT_THE_SAME_AS_WE_SENT);
        }
        AlgorithmIdentifier algId = header.getProtectionAlg();
        String protectionAlgId = algId.getAlgorithm().getId();
        if (algId == null || algId.getAlgorithm() == null || algId.getAlgorithm().getId() == null) {
            logger.info("\u68c0\u67e5\u6d88\u606f\u5934\u548c\u7b7e\u540d ======  Not possible to get algorithm.");
            return Result.failure(ErrorEnum.NO_PROTECTION_ALG_IN_PKI_HEADER);
        }
        logger.debug("\u68c0\u67e5\u6d88\u606f\u5934\u548c\u7b7e\u540d ====== \u6821\u9a8c\u7b7e\u540d\u503c");
        CMPCertificate[] extraCerts = respPkiMessage.getExtraCerts();
        X509Certificate certificate = null;
        try {
            certificate = PKIMessageHelper.convertDerCertToCert(extraCerts[0].getEncoded());
        }
        catch (IOException e) {
            logger.error("\u9a8c\u8bc1\u8bc1\u4e66\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
            return Result.failure(ErrorEnum.VERIFY_CERT_CONVERSION_ERROR);
        }
        boolean verifyResult = false;
        try {
            verifyResult = SdkBCUtils.verifyCertByBC(protectionAlgId, certificate.getPublicKey(), PKIMessageHelper.getProtectedBytes(header, respPkiMessage.getBody()), respPkiMessage.getProtection().getBytes());
            logger.info("\u9a8c\u7b7e\u7ed3\u679c ====== " + verifyResult);
        }
        catch (Exception e) {
            logger.error("\u9a8c\u8bc1resp\u6d88\u606f\u5f02\u5e38", (Throwable)e);
            return Result.failure(ErrorEnum.VERIFY_RESP_MESSAGE_ERROR);
        }
        if (!verifyResult) {
            logger.info("\u68c0\u67e5\u6d88\u606f\u5934\u548c\u7b7e\u540d ====== verify_pki_message_protection_error");
            return Result.failure(ErrorEnum.VERIFY_PKI_MESSAGE_PROTECTION_ERROR);
        }
        return Result.success(null);
    }

    public static Result genErrorPKIMsg(String normalName, PrivateKey normalPrivateKey, X509Certificate[] trustCaCert, X509Certificate normalCert, String errMsg, int errCode, byte[] recipNonce, byte[] senderNonce, String transId, String url, ASN1ObjectIdentifier protectAlgName) {
        ErrorMsgContent errorMsgContent;
        Result sdkResult = new Result();
        logger.info("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== 1.\u5c01\u88c5ErrorMsgContent\u7ed3\u6784\u4f53");
        try {
            errorMsgContent = PKIMessageHelper.genErrorMsgContent(PKIStatus.rejection, errMsg, errCode);
        }
        catch (Exception e) {
            logger.error("=============== \u5c01\u88c5ErrorMsgContent\u5f02\u5e38{}", (Throwable)e);
            return Result.failure(ErrorEnum.ERROR_MSG_CONTENT_EXCEPTION);
        }
        FreeText freeText = new FreeText();
        freeText.setSignSn(SDKService.config.getUserCertSn().toLowerCase());
        logger.debug("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== 2.\u5c01\u88c5PKIMesage\u7ed3\u6784\u4f53");
        PKIMessage errorPKIMessage = null;
        try {
            errorPKIMessage = PKIMessageHelper.genPKIMessage(normalPrivateKey, normalName, 23, recipNonce, senderNonce, transId, (ASN1Encodable)errorMsgContent, protectAlgName, JSON.toJSONString((Object)freeText), normalCert);
        }
        catch (Exception e) {
            logger.error("=============== \u5c01\u88c5ErrorMsg\u7684PKIMessage\u5f02\u5e38{}", (Throwable)e);
            return Result.failure(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
        }
        logger.debug("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== 3.\u53d1\u9001\u8bc1\u4e66\u9519\u8bef\u6d88\u606f");
        try {
            Result postResult = SdkApacheClientUtils.sendApacheClientRequest(errorPKIMessage.getEncoded(), null, url, "application/pkixcmp", trustCaCert, SDKService.config, null, true, "post");
            if (!postResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(postResult.getErrorMsg());
                return sdkResult;
            }
        }
        catch (Exception e) {
            logger.error(" ============= \u53d1\u9001\u8bc1\u4e66\u9519\u8befHttp\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            return Result.failure(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
        }
        logger.debug("\u53d1\u9001\u9519\u8bef\u6d88\u606f ========\u6b63\u5e38\u7ed3\u675f");
        return sdkResult;
    }

    public static Result resolveVarietyRepMessage(byte[] pkiInfo, String transId, int keyFormat) {
        Result sdkResult = new Result();
        PKIMessage respPkiMessage = PKIMessage.getInstance((Object)pkiInfo);
        PKIBody body = respPkiMessage.getBody();
        logger.debug("CMP\u8fd4\u56debody\u4f53\u7684tagNo:" + body.getType());
        if (body.getType() == 1 || body.getType() == 3) {
            Result certRepSdkResult = null;
            try {
                certRepSdkResult = PKIMessageHelper.resolveCertRepMessage(body, transId);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790CertRepMessage\u5f02\u5e38{}", (Throwable)e);
                return Result.failure(ErrorEnum.RESOLVE_CERT_REP_MESSAGE_EXCEPTION);
            }
            if (!certRepSdkResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(certRepSdkResult.getErrorMsg());
                return sdkResult;
            }
            sdkResult.setInfo(certRepSdkResult.getInfo());
            return sdkResult;
        }
        if (body.getType() == 10) {
            Result recRepSdkResult = null;
            try {
                recRepSdkResult = PKIMessageHelper.resolveKeyRecRepContent(body);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790KeyRecRepContent\u5f02\u5e38", (Throwable)e);
                return Result.failure(ErrorEnum.RESOLVE_REV_REP_CONTENT_EXCEPTION);
            }
            sdkResult.setInfo(recRepSdkResult.getInfo());
        } else if (body.getType() == 12) {
            Result revRepSdkResult = null;
            try {
                revRepSdkResult = PKIMessageHelper.resolveRevRepContent(body);
            }
            catch (Exception e) {
                logger.error("\u89e3\u6790RevRepContent\u5f02\u5e38{}", (Throwable)e);
                return Result.failure(ErrorEnum.RESOLVE_REV_REP_CONTENT_EXCEPTION);
            }
            sdkResult.setInfo(revRepSdkResult.getInfo());
        } else {
            logger.debug("Cert body tag is:" + body.getType());
            return Result.failure(ErrorEnum.RA_NOT_SUPPORT_THIS_CERT_BODY_TAG);
        }
        return sdkResult;
    }

    private static Result resolveKeyRecRepContent(PKIBody body) {
        Result sdkResult = new Result();
        KeyRecRepContent keyRecRepContent = (KeyRecRepContent)body.getContent();
        PKIStatusInfo pkiStatusInfo = keyRecRepContent.getStatus();
        int status = 0;
        UserCertRep userCertInfo = new UserCertRep();
        if (status == pkiStatusInfo.getStatus().intValue()) {
            logger.debug("==========RA\u8fd4\u56de\u7684\u6062\u590d\u6210\u529f=========");
            logger.trace("==========\u63d0\u53d6\u7b7e\u540d\u8bc1\u4e66=========");
            CMPCertificate newSigCert = keyRecRepContent.getNewSigCert();
            Result checkResult = PKIMessageHelper.checkCMPCert(newSigCert);
            if (!checkResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(checkResult.getErrorMsg());
                return sdkResult;
            }
            X509Certificate signCert = (X509Certificate)checkResult.getInfo();
            String base64SignCert = SdkCertUtils.certToFullB64(signCert);
            userCertInfo.setSignCert(base64SignCert);
            logger.trace("==========\u63d0\u53d6\u52a0\u5bc6\u8bc1\u4e66=========");
            CertifiedKeyPair[] keyPairHist = keyRecRepContent.getKeyPairHist();
            CertOrEncCert oldEncCert = keyPairHist[0].getCertOrEncCert();
            if (oldEncCert == null) {
                logger.info("No CertOrEncCert for certificate received.");
                return Result.failure(ErrorEnum.NO_CERT_OR_ENC_CERT_FOR_RECEIVED);
            }
            CMPCertificate cmpCertificate = oldEncCert.getCertificate();
            checkResult = PKIMessageHelper.checkCMPCert(cmpCertificate);
            if (!checkResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(checkResult.getErrorMsg());
                return sdkResult;
            }
            X509Certificate encCert = (X509Certificate)checkResult.getInfo();
            String base64EncCert = SdkCertUtils.certToFullB64(encCert);
            userCertInfo.setEncCert(base64EncCert);
            EncryptedValue encPprKey = keyPairHist[0].getPrivateKey();
            if (encPprKey == null) {
                logger.info("No encPprKey for certificate received.");
                return Result.failure(ErrorEnum.NO_CERTIFIED_KEY_PAIR_FOR_RECEIVED);
            }
            if (encPprKey != null) {
                SignedAndEnvelopedData signedAndEnvelopedData = null;
                try {
                    signedAndEnvelopedData = PKIMessageHelper.buildSignedAndEnvelopedData(signCert, encPprKey, SDKService.config.getUserCertSn());
                }
                catch (Exception e) {
                    logger.error("Build SignedAndEnvelopedData From Encryptedvalue Exception.", (Throwable)e);
                    return Result.failure(ErrorEnum.NO_CERT_OR_ENC_CERT_FOR_RECEIVED);
                }
                userCertInfo.setEncPriKey(Base64.toBase64String((byte[])signedAndEnvelopedData.getDEREncoded()));
            }
            sdkResult.setInfo(userCertInfo);
        } else {
            PKIFreeText pkiFreeTexts = pkiStatusInfo.getStatusString();
            String failInfo = pkiFreeTexts.getStringAt(0).toString();
            logger.debug("RA\u8fd4\u56de\u7684\u6062\u590d\u5931\u8d25,\u539f\u56e0:{}", (Object)failInfo);
            sdkResult.setInfo("\u6062\u590d\u5931\u8d25");
        }
        return sdkResult;
    }

    public static Result resolveRevRepContent(PKIBody body) {
        Result sdkResult = new Result();
        int status = 0;
        RevRepContent revRepContent = (RevRepContent)body.getContent();
        PKIStatusInfo[] pkiStatusInfos = revRepContent.getStatus();
        if (status == pkiStatusInfos[0].getStatus().intValue()) {
            logger.debug("==========RA\u8fd4\u56de\u7684\u64a4\u9500\u6210\u529f=========");
            sdkResult.setInfo("\u64a4\u9500\u6210\u529f");
        } else {
            PKIFreeText pkiFreeTexts = pkiStatusInfos[0].getStatusString();
            String failInfo = pkiFreeTexts.getStringAt(0).toString();
            logger.debug("RA\u8fd4\u56de\u7684\u64a4\u9500\u5931\u8d25,\u539f\u56e0:" + failInfo);
            sdkResult.setInfo("\u64a4\u9500\u5931\u8d25");
        }
        return sdkResult;
    }

    public static Result checkCMPCert(CMPCertificate cmpCertificate) {
        if (cmpCertificate == null) {
            logger.debug("No X509CertificateStructure for certificate received.");
            return Result.failure(ErrorEnum.NO_X509_CERT_FOR_RECEIVED);
        }
        byte[] encoded = new byte[]{};
        try {
            encoded = cmpCertificate.getEncoded();
            if (encoded == null || encoded.length <= 0) {
                logger.debug("No encoded certificate received");
                return Result.failure(ErrorEnum.NO_ENCODE_CERT_FOR_RECEIVED);
            }
        }
        catch (IOException e) {
            logger.debug("CMPCertificate Encode Exception.{}", (Throwable)e);
            return Result.failure(ErrorEnum.CMP_CERT_ENCODE_EXCEPTION);
        }
        X509Certificate cert = null;
        try {
            cert = SdkCertUtils.convertDerCertToCert(encoded);
        }
        catch (Exception e) {
            logger.error("Not possible to create certificate.{}", (Throwable)e);
            return Result.failure(ErrorEnum.NOT_POSSIBLE_TO_CREATE_CERT);
        }
        return Result.success(cert);
    }

    public static Result resolveCertRepMessage(PKIBody body, String transId) throws IOException {
        Result sdkResult = new Result();
        CertRepMessage certRepMessage = (CertRepMessage)body.getContent();
        if (certRepMessage == null) {
            logger.debug("============== No CertRepMessage for certificate received.");
            return Result.failure(ErrorEnum.NO_CERT_REQ_MESSAGE_RECEIVED);
        }
        CertResponse[] certResponses = certRepMessage.getResponse();
        UserCertRep userCertInfo = new UserCertRep();
        X509Certificate signCert = null;
        for (CertResponse resp : certResponses) {
            if (resp == null) {
                logger.debug("============== No CertResponse for certificate received.");
                return Result.failure(ErrorEnum.NO_CERT_RESPONSE_MESSAGE_RECEIVED);
            }
            PKIStatusInfo info = resp.getStatus();
            if (info == null) {
                logger.debug("No PKIStatusInfo for certificate received.");
                return Result.failure(ErrorEnum.NO_PKI_STATUS_INFO_FOR_RECEIVE);
            }
            int pkiStatus = info.getStatus().intValue();
            if (pkiStatus != 0) {
                logger.debug("Received Status is " + pkiStatus + " but should be 0  ");
                DERUTF8String stringAt = info.getStatusString().getStringAt(0);
                int failInfo = info.getFailInfo().intValue();
                if ("300".equals(String.valueOf(failInfo).substring(0, 3))) {
                    return Result.failure(ErrorEnum.RA_OPEN_API_INNER_EXCEPTION);
                }
                if (PKIMessageHelper.getHashSet().contains(failInfo)) {
                    return Result.failure(ErrorEnum.RA_SERVICE_INNER_EXCEPTION);
                }
                if (failInfo >= 20502 && failInfo <= 20506) {
                    return Result.failure(ErrorEnum.CA_RETURN_USER_CERT_INFO_ERROR);
                }
                return Result.failure(failInfo, stringAt.toString());
            }
            CertifiedKeyPair certifiedKeyPair = resp.getCertifiedKeyPair();
            if (certifiedKeyPair == null) {
                logger.debug("No CertifiedKeyPair for certificate received.");
                return Result.failure(ErrorEnum.NO_CERTIFIED_KEY_PAIR_FOR_RECEIVED);
            }
            CertOrEncCert certOrEncCert = certifiedKeyPair.getCertOrEncCert();
            if (certOrEncCert == null) {
                logger.debug("No CertOrEncCert for certificate received.");
                return Result.failure(ErrorEnum.NO_CERT_OR_ENC_CERT_FOR_RECEIVED);
            }
            CMPCertificate cmpCertificate = certOrEncCert.getCertificate();
            Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
            BaseCMPInfo baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
            if (baseCMPInfo == null) {
                logger.debug(" ============= No ra send transId.");
                return Result.failure(ErrorEnum.NO_RA_SEND_TRANS_ID);
            }
            boolean isSignCert = false;
            long requestId = baseCMPInfo.getRequestId();
            long receiveCertReqId = resp.getCertReqId().getValue().longValue();
            if (receiveCertReqId == requestId) {
                isSignCert = true;
            } else if (receiveCertReqId == -1L) {
                isSignCert = false;
            } else {
                String errMsg = "=============== Received CertReqId is " + receiveCertReqId + " but should be " + requestId;
                logger.debug(errMsg);
                return Result.failure(ErrorEnum.RA_RECEIVED_CERT_REQ_ID_IS_ERROR);
            }
            Result checkResult = PKIMessageHelper.checkCMPCert(cmpCertificate);
            if (!checkResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(checkResult.getErrorMsg());
                return sdkResult;
            }
            if (isSignCert) {
                signCert = (X509Certificate)checkResult.getInfo();
                String base64SignCert = SdkCertUtils.certToFullB64(signCert);
                userCertInfo.setSignCert(base64SignCert);
            } else {
                X509Certificate encCert = (X509Certificate)checkResult.getInfo();
                String base64EncCert = SdkCertUtils.certToFullB64(encCert);
                userCertInfo.setEncCert(base64EncCert);
            }
            EncryptedValue privateKey = certifiedKeyPair.getPrivateKey();
            if (privateKey == null) continue;
            ASN1OctetString priKey = ASN1OctetString.getInstance((Object)ASN1Sequence.getInstance((Object)resp.getEncoded()).getObjectAt(3));
            userCertInfo.setEncPriKey(new String(priKey.getOctets()));
        }
        return Result.success(userCertInfo);
    }

    private static HashSet getHashSet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(20339);
        hashSet.add(20340);
        hashSet.add(20317);
        hashSet.add(20403);
        hashSet.add(20334);
        hashSet.add(20328);
        return hashSet;
    }

    public static void main(String[] args) {
        int failInfo = 100001;
        if ("300".equals(String.valueOf(failInfo).substring(0, 3))) {
            System.out.println(1111);
        } else if (PKIMessageHelper.getHashSet().contains(failInfo)) {
            System.out.println(2222);
        } else if (failInfo >= 20502 && failInfo <= 20506) {
            System.out.println(3333);
        } else {
            System.out.println(4444);
        }
    }

    public static CertRequest genCertRequest(byte[] publicKey, ASN1ObjectIdentifier signAlg, long certReqId, int certType) throws Exception {
        CertTemplateBuilder myCertTemplate = new CertTemplateBuilder();
        myCertTemplate.setVersion(1);
        myCertTemplate.setSigningAlg(new AlgorithmIdentifier(signAlg));
        SubjectPublicKeyInfo keyInfo = null;
        if (publicKey != null) {
            if (SM2ObjectIdentifiers.sm2SignWithSm3.equals((Object)signAlg)) {
                if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                    keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey);
                } else {
                    PublicKey pubKey = SdkCertUtils.convertSM2PublicKey(Base64.toBase64String((byte[])publicKey));
                    keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
                }
            } else if (NISTObjectIdentifiers.nistSignAlgorithm.equals((Object)signAlg)) {
                if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                    try {
                        keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey);
                    }
                    catch (Exception e) {
                        PublicKey pubKey = SdkCertUtils.convertECPublicKey(Base64.toBase64String((byte[])publicKey), NISTNamedCurves.getName((ASN1ObjectIdentifier)SECObjectIdentifiers.secp256r1));
                        keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
                    }
                }
            } else if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                keyInfo = SubjectPublicKeyInfo.getInstance((Object)publicKey);
            } else {
                KeyFactory kf = KeyFactory.getInstance("RSA", (Provider)new BouncyCastleProvider());
                RSAPublicKeySpec rsaPublicKeySpec = new RSAPublicKeySpec(BigIntegers.fromUnsignedByteArray((byte[])publicKey), BigInteger.valueOf(65537L));
                PublicKey pubKey = kf.generatePublic(rsaPublicKeySpec);
                keyInfo = SubjectPublicKeyInfo.getInstance((Object)pubKey.getEncoded());
            }
        }
        myCertTemplate.setPublicKey(keyInfo);
        ExtensionsGenerator extgen = new ExtensionsGenerator();
        try {
            int bcku = 0;
            if (certType == SdkConstants.CERT_TYPE_SIGN_2) {
                bcku = 192;
            } else if (certType == SdkConstants.CERT_TYPE_ENC_3) {
                bcku = 56;
            }
            X509KeyUsage ku = new X509KeyUsage(bcku);
            extgen.addExtension(Extension.keyUsage, false, (ASN1Encodable)ku);
        }
        catch (IOException e) {
            logger.info("\u5c01\u88c5CertRequest\u7684\u6269\u5c55\u4fe1\u606f\u5f02\u5e38{}", (Throwable)e);
            throw new IOException();
        }
        myCertTemplate.setExtensions(extgen.generate());
        return new CertRequest(new ASN1Integer(certReqId), myCertTemplate.build(), null);
    }

    public static CertReqMessages genCertReqMessages(CertRequest[] certRequests) {
        CertReqMsg[] certReqMsgs = new CertReqMsg[certRequests.length];
        for (int i = 0; i < certRequests.length; ++i) {
            CertReqMsg certReqMsg;
            if (certRequests[i] == null) continue;
            certReqMsgs[i] = certReqMsg = new CertReqMsg(certRequests[i], null, null);
        }
        CertReqMessages myCertReqMessages = new CertReqMessages(certReqMsgs);
        return myCertReqMessages;
    }

    public static PKIMessage genPKIMessage(PrivateKey normalPrivateKey, String sender, int tagNo, byte[] recipNonce, byte[] senderNonce, String transId, ASN1Encodable asn1Encodable, ASN1ObjectIdentifier protectionAlg, String freeText, X509Certificate normalCert) throws Exception {
        String singValue;
        PKIBody myPKIBody = new PKIBody(tagNo, asn1Encodable);
        GeneralName normalName = new GeneralName(6, sender);
        GeneralName raName = new GeneralName(6, "RA");
        PKIHeaderBuilder myPKIHeader = new PKIHeaderBuilder(1, normalName, raName);
        myPKIHeader.setMessageTime(new ASN1GeneralizedTime(new Date()));
        myPKIHeader.setSenderNonce((ASN1OctetString)new DEROctetString(senderNonce));
        myPKIHeader.setRecipNonce((ASN1OctetString)new DEROctetString(recipNonce));
        myPKIHeader.setTransactionID(transId.getBytes());
        myPKIHeader.setProtectionAlg(new AlgorithmIdentifier(protectionAlg));
        if (freeText != null) {
            myPKIHeader.setFreeText(new PKIFreeText(freeText));
        }
        PKIHeader myHeader = myPKIHeader.build();
        if (normalPrivateKey == null) {
            throw new Exception("\u7b2c\u4e09\u65b9\u7b7e\u540d\u79c1\u94a5\u4e3a\u7a7a");
        }
        logger.info("\u88ab\u7b7e\u540d\u8ba1\u7b97\u7684\u539f\u59cb\u6570\u636e\uff1a" + Base64.toBase64String((byte[])PKIMessageHelper.getProtectedBytes(myHeader, myPKIBody)));
        if (protectionAlg.getId().equalsIgnoreCase(SM2ObjectIdentifiers.sm2SignWithSm3.getId())) {
            long begin = System.currentTimeMillis();
            singValue = GMSSLSM2SignUtils.signByBC((PrivateKey)normalPrivateKey, (String)Base64.toBase64String((byte[])PKIMessageHelper.getProtectedBytes(myHeader, myPKIBody)));
            System.out.println(System.currentTimeMillis() - begin);
        } else {
            singValue = protectionAlg.getId().equalsIgnoreCase(RsaObjectIdentifiers.sha256WithRSA.getId()) ? GMSSLRSASignUtils.signByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PrivateKey)normalPrivateKey, (String)Base64.toBase64String((byte[])PKIMessageHelper.getProtectedBytes(myHeader, myPKIBody))) : (protectionAlg.getId().equalsIgnoreCase(RsaObjectIdentifiers.sha1WithRSA.getId()) ? GMSSLRSASignUtils.signByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PrivateKey)normalPrivateKey, (String)Base64.toBase64String((byte[])PKIMessageHelper.getProtectedBytes(myHeader, myPKIBody))) : Base64.toBase64String((byte[])GMSSLBCSignUtils.generateSignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PrivateKey)normalPrivateKey, (byte[])PKIMessageHelper.getProtectedBytes(myHeader, myPKIBody))));
        }
        if (StringUtils.isBlank((CharSequence)singValue)) {
            throw new Exception("\u4f7f\u7528BC\u7b7e\u540d\u5931\u8d25");
        }
        logger.info("\u7b7e\u540d\u503c\uff1a" + singValue);
        CMPCertificate[] cmpCert = PKIMessageHelper.getCMPCert(normalCert);
        PKIMessage pkiMessage = new PKIMessage(myHeader, myPKIBody, new DERBitString(Base64.decode((String)singValue)), cmpCert);
        return pkiMessage;
    }

    public static byte[] getProtectedBytes(PKIHeader header, PKIBody body) {
        byte[] res = null;
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)header);
        v.add((ASN1Encodable)body);
        DERSequence protectedPart = new DERSequence(v);
        try {
            ByteArrayOutputStream bao = new ByteArrayOutputStream();
            DEROutputStream out = new DEROutputStream((OutputStream)bao);
            out.writeObject((ASN1Encodable)protectedPart);
            res = bao.toByteArray();
        }
        catch (Exception ex) {
            logger.error(ex.getLocalizedMessage(), (Throwable)ex);
        }
        return res;
    }

    public static CertConfirmContent genCertConfirmContent(String hash, long certReqId) {
        CertStatus certStatus = new CertStatus(hash.getBytes(), new BigInteger(String.valueOf(certReqId)));
        ASN1EncodableVector v = new ASN1EncodableVector();
        v.add((ASN1Encodable)certStatus);
        CertConfirmContent certConfirmContent = CertConfirmContent.getInstance((Object)new DERSequence(v));
        return certConfirmContent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static CMPCertificate[] getCMPCert(java.security.cert.Certificate cert) throws CertificateEncodingException, IOException {
        try (ASN1InputStream ins = new ASN1InputStream(cert.getEncoded());){
            CMPCertificate[] res;
            ASN1Primitive pcert = ins.readObject();
            Certificate c = Certificate.getInstance((Object)pcert.toASN1Primitive());
            CMPCertificate[] cMPCertificateArray = res = new CMPCertificate[]{new CMPCertificate(c)};
            return cMPCertificateArray;
        }
    }

    public static ErrorMsgContent genErrorMsgContent(PKIStatus pkiStatus, String errorDetails, int errorCode) {
        PKIFreeText pkiFreeText = new PKIFreeText(errorDetails);
        PKIStatusInfo pkiStatusInfo = new PKIStatusInfo(pkiStatus);
        ErrorMsgContent errorMessage = new ErrorMsgContent(pkiStatusInfo, new ASN1Integer((long)errorCode), pkiFreeText);
        return errorMessage;
    }

    public static byte[] genRandomByHsm(int length) throws SdfSDKException {
        byte[] normalSenderNonce = new byte[16];
        SecureRandom secureRandom = new SecureRandom();
        secureRandom.nextBytes(normalSenderNonce);
        return normalSenderNonce;
    }

    public static X509Certificate convertDerCertToCert(byte[] certder) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            ByteArrayInputStream inStream = new ByteArrayInputStream(certder);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (null != x509Cert) {
            return x509Cert;
        }
        String str = new String(certder);
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        x509Cert = PKIMessageHelper.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = PKIMessageHelper.getCertFromStr16(str);
        }
        return x509Cert;
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromB64 error: " + e.toString());
            return null;
        }
    }

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = PKIMessageHelper.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", (Provider)new BouncyCastleProvider());
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            System.err.println("getCertFromFullStr error: " + e.toString());
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || str.equals("")) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    private static SignedAndEnvelopedData buildSignedAndEnvelopedData(X509Certificate signCert, EncryptedValue encryptedValue, String raSignSn) throws Exception {
        String raSignCertDN = signCert.getSubjectDN().getName();
        String caAlg = signCert.getSigAlgName();
        ASN1Integer version = new ASN1Integer(1L);
        DERSet digestAlgorithms = null;
        digestAlgorithms = "SHA-1WithRSA".equalsIgnoreCase(caAlg) || "SHA1WithRSA".equalsIgnoreCase(caAlg) || "SHA256WithRSA".equalsIgnoreCase(caAlg) ? new DERSet((ASN1Encodable)new AlgorithmIdentifier(DigestObjectIdentifiers.sha1)) : new DERSet((ASN1Encodable)new AlgorithmIdentifier(DigestObjectIdentifiers.sm3));
        RecipientIdentifier rid = new RecipientIdentifier(new IssuerAndSerialNumber(DnUtil.getRFC4519X500Name(raSignCertDN), new BigInteger(raSignSn, 16)));
        KeyTransRecipientInfo keyTransRecipientInfo = new KeyTransRecipientInfo(rid, encryptedValue.getKeyAlg(), (ASN1OctetString)new DEROctetString(encryptedValue.getEncSymmKey().getOctets()));
        DERSet recipientInfos = new DERSet((ASN1Encodable)keyTransRecipientInfo);
        EncryptedContentInfo encryptedContentInfo = new EncryptedContentInfo(SymmetryObjectIdentifiers.contentType, encryptedValue.getSymmAlg(), (ASN1OctetString)new DEROctetString((ASN1Encodable)encryptedValue.getEncValue()));
        byte[] mergeData = SdkCertUtils.byteMergerAll(version.getEncoded(), recipientInfos.getEncoded(), digestAlgorithms.getEncoded(), encryptedContentInfo.getEncoded());
        ASN1Set signerInfos = PKIMessageHelper.makeSignerInfos(raSignCertDN, new BigInteger(raSignSn, 16), mergeData);
        SignedAndEnvelopedData envelopedData = new SignedAndEnvelopedData(version, (ASN1Set)recipientInfos, (ASN1Set)digestAlgorithms, encryptedContentInfo, null, null, signerInfos);
        return envelopedData;
    }

    public static ASN1Set makeSignerInfos(String keyGeneraterCertIssuerDN, BigInteger keyGeneraterCertSN, byte[] structData) throws Exception {
        Signature signature;
        PrivateKey privateKey = SDKService.config.getPrivateKey();
        SignerIdentifier sid = new SignerIdentifier(new IssuerAndSerialNumber(DnUtil.getRFC4519X500Name(keyGeneraterCertIssuerDN), keyGeneraterCertSN));
        AlgorithmIdentifier digAlgorithm = null;
        AlgorithmIdentifier digEncryptionAlgorithm = null;
        DEROctetString encryptedDigest = null;
        if (privateKey instanceof RSAPrivateKey) {
            digAlgorithm = new AlgorithmIdentifier(DigestObjectIdentifiers.sha1);
            digEncryptionAlgorithm = new AlgorithmIdentifier(RsaObjectIdentifiers.rsaEncryption);
            signature = Signature.getInstance("SHA1WithRSAEncryption", "BC");
            signature.initSign(privateKey);
            signature.update(structData);
            encryptedDigest = new DEROctetString(signature.sign());
        } else {
            digAlgorithm = new AlgorithmIdentifier(DigestObjectIdentifiers.sm3);
            digEncryptionAlgorithm = new AlgorithmIdentifier(SM2ObjectIdentifiers.sm2256_sign);
            signature = Signature.getInstance("SM3withSM2", "BC");
            signature.initSign(privateKey);
            signature.update(structData);
            encryptedDigest = new DEROctetString(signature.sign());
        }
        ASN1OctetString encryptedDigestString = ASN1OctetString.getInstance((Object)encryptedDigest);
        ASN1Set asn1Set = null;
        SignerInfo signerInfo = new SignerInfo(sid, digAlgorithm, asn1Set, digEncryptionAlgorithm, encryptedDigestString, null);
        return new DERSet((ASN1Encodable)signerInfo);
    }
}

