/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.sdk;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.xdja.ra.asn1.NISTObjectIdentifiers;
import com.xdja.ra.asn1.RsaObjectIdentifiers;
import com.xdja.ra.asn1.SM2ObjectIdentifiers;
import com.xdja.ra.bean.BaseCMPInfo;
import com.xdja.ra.bean.DoubleCode;
import com.xdja.ra.bean.Result;
import com.xdja.ra.bean.UserCertReq;
import com.xdja.ra.constant.SdkCommonVariable;
import com.xdja.ra.constant.SdkConstants;
import com.xdja.ra.error.ErrorEnum;
import com.xdja.ra.helper.PKIMessageHelper;
import com.xdja.ra.sdk.SDKService;
import com.xdja.ra.utils.SdkApacheClientUtils;
import com.xdja.ra.utils.SdkJsonUtils;
import com.xdja.ra.utils.SdkP10Utils;
import com.xdja.ra.vo.FreeText;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.StringUtils;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.cmp.CertConfirmContent;
import org.bouncycastle.asn1.cmp.PKIMessage;
import org.bouncycastle.asn1.crmf.CertReqMessages;
import org.bouncycastle.asn1.crmf.CertRequest;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaCmpApi {
    private Logger logger = LoggerFactory.getLogger(this.getClass());

    public Result sendCertReqMessage(int applyType, String transId, String normalName, String normalSignAlgOid, String applyNo, UserCertReq userCertReq, Integer keyFormat) {
        byte[] pkiInfo;
        PKIMessage pkiMessage;
        CertReqMessages certReqMessages;
        byte[] recipNonce;
        ASN1ObjectIdentifier protectionAlg;
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u7c7b\u578b\u4e3a{}\uff0c\u7533\u8bf7\u4e8b\u52a1Id\u4e3a{}, normalName\u4e3a{}\uff0cnormalSignAlgOid\u4e3a{}, applyNo\u4e3a{} ", new Object[]{applyType, transId, normalName, normalSignAlgOid, applyNo});
        Result sdkResult = new Result();
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{transId, normalSignAlgOid, normalName, applyNo})) {
            this.logger.warn("=============== \u53c2\u6570\u4e2dtransId, normalSignAlgOid,normalName,applyNo\u5b58\u5728\u7a7a\u503c");
            return Result.failure(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        try {
            protectionAlg = this.getProtectionAlg(normalSignAlgOid);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.PROTECTION_ALG_IS_NOT_SUPPORT);
        }
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 1.\u5411RA\u83b7\u53d6\u968f\u673a\u6570");
        String genRandomUtl = "/v1/normal/ra/random";
        ConcurrentHashMap<String, String> paramMap = new ConcurrentHashMap<String, String>();
        paramMap.put("transId", transId);
        try {
            Result getResult = SdkApacheClientUtils.sendApacheClientRequest(null, paramMap, SDKService.config.getRaBaseUrl() + genRandomUtl, null, SDKService.config.getTrustCert(), SDKService.config, null, true, "get");
            if (!getResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(getResult.getErrorMsg());
                return sdkResult;
            }
            recipNonce = (byte[])getResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error("===============  \u83b7\u53d6CMP\u8bf7\u6c42\u968f\u673a\u6570\u5f02\u5e38", (Throwable)e);
            return Result.failure(ErrorEnum.GET_CMP_RANDOM_IS_EXCEPTION);
        }
        if (recipNonce == null) {
            this.logger.error("============== RA\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a");
            return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_INFO_IS_EMPTY);
        }
        long certReqId = System.nanoTime();
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 2.1\u5c01\u88c5CertRequest\u7ed3\u6784\u4f53");
        byte[] userP10Str = null;
        PublicKey publicKey = null;
        try {
            if (userCertReq.getSignP10Str() != null) {
                boolean verifyP10 = SdkP10Utils.verifyP10Info(userCertReq.getSignP10Str());
                if (!verifyP10) {
                    this.logger.info("\u975e\u6b63\u786e\u683c\u5f0f\u7684P10");
                    return Result.failure(ErrorEnum.P10_GET_PUBLIC_ERROR);
                }
                this.logger.info("\u6b63\u786e\u683c\u5f0f\u7684P10");
                publicKey = SdkP10Utils.p10ToPublicKey(userCertReq.getSignP10Str());
                userP10Str = publicKey.getEncoded();
                if ("RSA".equals(SDKService.config.getSystemCert().getPublicKey().getAlgorithm())) {
                    if (!publicKey.getAlgorithm().equals("RSA")) {
                        this.logger.info("\u7533\u8bf7\u4e66\u79d8\u94a5\u7b97\u6cd5\u548c\u7cfb\u7edf\u4e0d\u4e00\u81f4");
                        return Result.failure(ErrorEnum.P10_PUBLIC_KEY_NOT_SAME);
                    }
                } else {
                    String signAlgName = SDKService.config.getSystemCert().getSigAlgName();
                    SubjectPublicKeyInfo instance = SubjectPublicKeyInfo.getInstance((Object)userP10Str);
                    ASN1Encodable asn1Encodable = instance.getAlgorithmId().getParameters();
                    ASN1ObjectIdentifier oid = new ASN1ObjectIdentifier(asn1Encodable.toString());
                    if ("SM3WithSM2".equalsIgnoreCase(signAlgName)) {
                        if (!SM2ObjectIdentifiers.sm2256.equals((Object)oid)) {
                            this.logger.info("\u7533\u8bf7\u4e66\u79d8\u94a5\u7b97\u6cd5\u548c\u7cfb\u7edf\u4e0d\u4e00\u81f4");
                            return Result.failure(ErrorEnum.P10_PUBLIC_KEY_NOT_SAME);
                        }
                    } else if (!NISTObjectIdentifiers.nist256.equals((Object)oid)) {
                        this.logger.info("\u7533\u8bf7\u4e66\u79d8\u94a5\u7b97\u6cd5\u548c\u7cfb\u7edf\u4e0d\u4e00\u81f4");
                        return Result.failure(ErrorEnum.P10_PUBLIC_KEY_NOT_SAME);
                    }
                }
            }
        }
        catch (IllegalArgumentException e) {
            return Result.failure(ErrorEnum.P10_PUBLIC_KEY_NOT_SAME);
        }
        CertRequest[] certRequests = new CertRequest[1];
        CertRequest certRequest = null;
        try {
            certRequests[0] = certRequest = PKIMessageHelper.genCertRequest(userP10Str, protectionAlg, certReqId, SdkConstants.CERT_TYPE_SIGN_2);
        }
        catch (Exception e) {
            this.logger.error(" ===============  \u5c01\u88c5\u3010\u7b7e\u540d\u3011certRequest\u5f02\u5e38:{}", (Throwable)e);
            return Result.failure(ErrorEnum.MAKE_CERT_REQUEST_EXCEPTION);
        }
        this.logger.debug("\u7b7e\u53d1\u7533\u8bf7 ======== 3.\u5c01\u88c5CertReqMessages\u7ed3\u6784\u4f53");
        try {
            certReqMessages = PKIMessageHelper.genCertReqMessages(certRequests);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u5c01\u88c5certRequestMessage\u5f02\u5e38:{}", (Throwable)e);
            return Result.failure(ErrorEnum.MAKE_CERT_REQUEST_MESSAGE_EXCEPTION);
        }
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 4.normal\u4ea7\u751f\u5341\u516d\u5b57\u8282\u968f\u673a\u6570");
        byte[] normalSenderNonce = new byte[16];
        try {
            SecureRandom secureRandom = new SecureRandom();
            secureRandom.nextBytes(normalSenderNonce);
        }
        catch (Exception e) {
            this.logger.error(" ============== \u751f\u6210normalSenderNonce\u968f\u673a\u6570\u5f02\u5e38:{}", (Throwable)e);
            return Result.failure(ErrorEnum.GET_RANDOM_BY_SECURERANDOM_EXCEPTION);
        }
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        headerMap.put(transId, new BaseCMPInfo(normalSenderNonce, recipNonce, transId, certReqId, 0));
        Map<String, String> normalMap = SdkCommonVariable.getApplyMap();
        normalMap.put(applyNo, transId);
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 5.\u5c01\u88c5PKIMessage\u7ed3\u6784\u4f53");
        FreeText freeText = new FreeText();
        freeText.setApplyNo(applyNo);
        DoubleCode doubleCode = new DoubleCode();
        doubleCode.setAuthCode(userCertReq.getAuthCode());
        doubleCode.setRefCode(userCertReq.getRefCode());
        freeText.setSignSn(SDKService.config.getUserCertSn().toLowerCase());
        freeText.setDoubleCode(doubleCode);
        freeText.setKeyFormat(keyFormat);
        try {
            int tagNo;
            if (applyType == SdkConstants.CERT_APPLY_TYPE_ISSUE_1) {
                tagNo = 0;
            } else if (applyType == SdkConstants.CERT_APPLY_TYPE_UPDATE_2) {
                tagNo = 7;
            } else if (applyType == SdkConstants.CERT_APPLY_TYPE_RECOVERY_4) {
                tagNo = 9;
            } else {
                this.logger.error("[RaCmpApi#sendCertReqMessage] \u4e0d\u652f\u6301\u7684\u7533\u8bf7\u7c7b\u578b{}", (Object)applyType);
                throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u7533\u8bf7\u7c7b\u578b");
            }
            pkiMessage = PKIMessageHelper.genPKIMessage(SDKService.config.getPrivateKey(), normalName, tagNo, recipNonce, normalSenderNonce, transId, (ASN1Encodable)certReqMessages, protectionAlg, JSON.toJSONString((Object)freeText), SDKService.config.getSystemCert());
        }
        catch (Exception e) {
            this.logger.error(" =============== \u5c01\u88c5PKIMessage\u5f02\u5e38", (Throwable)e);
            return Result.failure(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
        }
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 6.\u53d1\u9001\u8bc1\u4e66\u7533\u8bf7 \u8bf7\u6c42");
        String genCmpNormalPkiUrl = "/v1/normal/cmp";
        try {
            Result postResult = SdkApacheClientUtils.sendApacheClientRequest(pkiMessage.getEncoded(), null, SDKService.config.getRaBaseUrl() + genCmpNormalPkiUrl, "application/pkixcmp", SDKService.config.getTrustCert(), SDKService.config, null, true, "post");
            if (!postResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(postResult.getErrorMsg());
                return sdkResult;
            }
            pkiInfo = (byte[])postResult.getInfo();
        }
        catch (Exception e) {
            this.logger.error(" ============= \u53d1\u9001\u8bc1\u4e66\u7533\u8bf7Http\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            return Result.failure(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
        }
        if (pkiInfo == null) {
            this.logger.error("============== \u63a5\u6536RA\u8fd4\u56de\u7684\u6570\u636e\u5185\u5bb9\u4e3a\u7a7a");
            return Result.failure(ErrorEnum.RA_OPEN_API_RETURN_INFO_IS_EMPTY);
        }
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 7.\u68c0\u67e5RA\u8fd4\u56de\u6d88\u606f");
        Result checkResult = PKIMessageHelper.checkCmpHeaderAndSign(pkiInfo, transId, normalSenderNonce);
        if (!checkResult.isSuccess().booleanValue()) {
            this.logger.error("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 7.1 \u89e3\u6790RA\u8fd4\u56de\u7684\u5934\u548c\u7b7e\u540d\u9519\u8bef");
            sdkResult.setErrorMsg(checkResult.getErrorMsg());
            return sdkResult;
        }
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 8.\u83b7\u53d6RA\u8fd4\u56de\u7684\u8bc1\u4e66\u4fe1\u606f");
        Result resolveResult = PKIMessageHelper.resolveVarietyRepMessage(pkiInfo, transId, keyFormat);
        if (!resolveResult.isSuccess().booleanValue()) {
            this.logger.error("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== 8.1 \u83b7\u53d6RA\u8fd4\u56de\u7684\u8bc1\u4e66\u4fe1\u606f\u9519\u8bef");
            sdkResult.setErrorMsg(resolveResult.getErrorMsg());
            return sdkResult;
        }
        this.logger.debug("\u7b7e\u53d1/\u66f4\u65b0/\u6062\u590d\u7533\u8bf7 ======== \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        return Result.success(resolveResult.getInfo());
    }

    public Result sendConfirmMessage(String normalSignAlgOid, String normalName, String applyNo) {
        ASN1ObjectIdentifier protectionAlg;
        this.logger.debug("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u7f16\u53f7\u4e3a\uff1a{} ", (Object)applyNo);
        Result sdkResult = new Result();
        this.logger.debug("\u786e\u8ba4\u6d88\u606f ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{normalSignAlgOid, normalName, applyNo})) {
            this.logger.debug("=============== \u53c2\u6570\u4e2dnormalSignAlgOid,applyNo,normalName\u5b58\u5728\u7a7a\u503c");
            return Result.failure(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        try {
            protectionAlg = this.getProtectionAlg(normalSignAlgOid);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.PROTECTION_ALG_IS_NOT_SUPPORT);
        }
        Map<String, String> normalMap = SdkCommonVariable.getApplyMap();
        this.logger.debug("=============== sendCertReqMessage.normalMap: " + SdkJsonUtils.object2Json(normalMap));
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        if (headerMap == null || normalMap == null) {
            this.logger.error(" ================== \u672c\u5730\u7f13\u5b58CMP\u6570\u636e\u4e3a\u7a7a");
            return Result.failure(ErrorEnum.LOCAL_CMP_CACHE_IS_EMPTY);
        }
        String transId = normalMap.get(applyNo);
        this.logger.debug("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ======== \u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        BaseCMPInfo baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
        this.logger.debug(" =================== sendCertConfirmContent.baseCMPInfo>> transId: " + transId + ">>" + JSONObject.toJSONString((Object)baseCMPInfo));
        if (baseCMPInfo == null) {
            this.logger.error(" ================== \u672a\u627e\u5230RA\u53d1\u9001\u7684\u8be5transId:" + transId);
            return Result.failure(ErrorEnum.CANNOT_GET_TRANS_ID_FORM_LOCAL_CACHE);
        }
        byte[] recipNonce = baseCMPInfo.getRecipientNonce();
        byte[] normalSenderNonce = baseCMPInfo.getSenderNonce();
        long certReqId = baseCMPInfo.getRequestId();
        this.logger.debug("\u786e\u8ba4\u6d88\u606f ======== 1.\u5c01\u88c5CertConfirmContent\u7ed3\u6784\u4f53");
        FreeText freeText = new FreeText();
        freeText.setApplyNo(applyNo);
        freeText.setSignSn(SDKService.config.getUserCertSn().toLowerCase());
        CertConfirmContent certConfirmContent = null;
        try {
            certConfirmContent = PKIMessageHelper.genCertConfirmContent(transId, certReqId);
        }
        catch (Exception e) {
            this.logger.error("\u5c01\u88c5CertConfirmContent\u5f02\u5e38{}", (Throwable)e);
            return Result.failure(ErrorEnum.MAKE_CERT_CONFIRM_CONTENT_EXCEPTION);
        }
        this.logger.debug("\u786e\u8ba4\u6d88\u606f ======== 2.\u5c01\u88c5PkiMessage\u7ed3\u6784\u4f53");
        PKIMessage certConfirmPKIMessage = null;
        try {
            certConfirmPKIMessage = PKIMessageHelper.genPKIMessage(SDKService.config.getPrivateKey(), normalName, 24, recipNonce, normalSenderNonce, transId, (ASN1Encodable)certConfirmContent, protectionAlg, JSON.toJSONString((Object)freeText), SDKService.config.getSystemCert());
        }
        catch (Exception e) {
            this.logger.error("\u5c01\u88c5PKIMessage\u5f02\u5e38\uff1a{}", (Throwable)e);
            return Result.failure(ErrorEnum.MAKE_PKI_MESSAGE_EXCEPTION);
        }
        this.logger.debug("\u786e\u8ba4\u6d88\u606f ======== 3.\u53d1\u9001\u8bc1\u4e66\u8bc1\u4e66\u786e\u8ba4\u6d88\u606f");
        String url = "/v1/normal/cmp";
        try {
            Result postResult = SdkApacheClientUtils.sendApacheClientRequest(certConfirmPKIMessage.getEncoded(), null, SDKService.config.getRaBaseUrl() + url, "application/pkixcmp", SDKService.config.getTrustCert(), SDKService.config, null, true, "post");
            if (!postResult.isSuccess().booleanValue()) {
                sdkResult.setErrorMsg(postResult.getErrorMsg());
                return sdkResult;
            }
        }
        catch (Exception e) {
            this.logger.error(" ============= \u53d1\u9001\u786e\u8ba4\u6d88\u606fHttp\u8bf7\u6c42\u5f02\u5e38:{}", (Throwable)e);
            return Result.failure(ErrorEnum.SEND_HTTP_MESSAGE_EXCEPTION);
        }
        this.logger.debug("sendConfirmMessage.sendCmpHttpPost.result>>>>" + SdkJsonUtils.object2Json(sdkResult));
        headerMap.remove(transId);
        normalMap.remove(applyNo);
        this.logger.debug("\u53d1\u9001\u8bc1\u4e66 \u7b7e\u53d1\u548c\u66f4\u65b0\u7684 \u786e\u8ba4\u6d88\u606f ========  \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{}", (Object)transId);
        return sdkResult;
    }

    public Result sendErrorMessage(String applyNo, String normalSignAlgOid, String normalName, String errMsg, int errorCode) {
        ASN1ObjectIdentifier protectionAlg;
        this.logger.debug("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== \u3010\u5f00\u59cb\u3011\u7533\u8bf7\u7f16\u53f7\u4e3a\uff1a{} ", (Object)applyNo);
        Result sdkResult = new Result();
        this.logger.debug("\u9519\u8bef\u6d88\u606f ======== 0.\u53c2\u4e0e\u6821\u9a8c");
        if (StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{applyNo, normalSignAlgOid, normalName})) {
            this.logger.debug("=============== applyNo,normalSignAlgOid,normalName\u5b58\u5728\u7a7a\u503c");
            return Result.failure(ErrorEnum.MISSING_REQUIRED_PARAMETERS);
        }
        try {
            protectionAlg = this.getProtectionAlg(normalSignAlgOid);
        }
        catch (Exception e) {
            return Result.failure(ErrorEnum.PROTECTION_ALG_IS_NOT_SUPPORT);
        }
        Map<String, String> normalMap = SdkCommonVariable.getApplyMap();
        Map<String, Object> headerMap = SdkCommonVariable.getHeaderMap();
        if (headerMap == null || normalMap == null) {
            this.logger.debug(" ================== \u672c\u5730\u7f13\u5b58CMP\u6570\u636e\u4e3a\u7a7a");
            return Result.failure(ErrorEnum.LOCAL_CMP_CACHE_IS_EMPTY);
        }
        String transId = normalMap.get(applyNo);
        this.logger.debug("\u53d1\u9001\u9519\u8bef\u6d88\u606f ======== \u4e8b\u52a1Id\u4e3a\uff1a{} ", (Object)transId);
        BaseCMPInfo baseCMPInfo = (BaseCMPInfo)headerMap.get(transId);
        this.logger.debug(" =================== sendCertConfirmContent.baseCMPInfo>> transId: " + transId + ">>" + JSONObject.toJSONString((Object)baseCMPInfo));
        if (baseCMPInfo == null) {
            this.logger.debug(" ================== \u672a\u627e\u5230RA\u53d1\u9001\u7684\u8be5transId:" + transId);
            return Result.failure(ErrorEnum.CANNOT_GET_TRANS_ID_FORM_LOCAL_CACHE);
        }
        byte[] recipNonce = baseCMPInfo.getRecipientNonce();
        byte[] normalSenderNonce = baseCMPInfo.getSenderNonce();
        String url = "/v1/normal/cmp";
        Result errorResult = PKIMessageHelper.genErrorPKIMsg(normalName, SDKService.config.getPrivateKey(), SDKService.config.getTrustCert(), SDKService.config.getSystemCert(), errMsg, errorCode, recipNonce, normalSenderNonce, transId, SDKService.config.getRaBaseUrl() + url, protectionAlg);
        if (!errorResult.isSuccess().booleanValue()) {
            sdkResult.setErrorMsg(errorResult.getErrorMsg());
            return sdkResult;
        }
        headerMap.remove(transId);
        normalMap.remove(applyNo);
        this.logger.debug("\u53d1\u9001\u8bc1\u4e66 \u9519\u8bef\u6d88\u606f ========  \u3010\u7ed3\u675f\u3011\u7533\u8bf7\u4e8b\u52a1Id\u4e3a\uff1a{}", (Object)transId);
        return sdkResult;
    }

    public ASN1ObjectIdentifier getProtectionAlg(String normalSignAlg) {
        ASN1ObjectIdentifier protectionAlg;
        if (SdkConstants.SIGN_ALG_NAME_SM3_WHIT_SM2.equals(normalSignAlg)) {
            protectionAlg = SM2ObjectIdentifiers.sm2SignWithSm3;
        } else if (SdkConstants.SIGN_ALG_NAME_SHA1_WHIT_RSA.equals(normalSignAlg)) {
            protectionAlg = RsaObjectIdentifiers.sha1WithRSA;
        } else if (SdkConstants.SIGN_ALG_NAME_SHA256_WHIT_RSA.equals(normalSignAlg)) {
            protectionAlg = RsaObjectIdentifiers.sha256WithRSA;
        } else if (SdkConstants.SIGN_ALG_NAME_NISTP256.equals(normalSignAlg)) {
            protectionAlg = NISTObjectIdentifiers.nistSignAlgorithm;
        } else {
            this.logger.debug("===============  pkiMessage\u4fdd\u62a4\u7b97\u6cd5\u4e0d\u652f\u6301\uff1a" + normalSignAlg);
            throw new RuntimeException("\u4e0d\u652f\u6301\u7684\u8bf7\u6c42\u65b9\u6cd5");
        }
        return protectionAlg;
    }
}

