/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.ra.utils.CertUtils;
import com.xdja.ra.utils.RFC4519StyleUpperCase;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.crmf.CertTemplate;
import org.bouncycastle.asn1.crmf.CertTemplateBuilder;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.junit.Test;

public class DnUtil {
    public static Map<String, String> DN = new HashMap<String, String>();

    public static X500Name getRFC4519X500Name(String dn) {
        return new X500Name(RFC4519StyleUpperCase.INSTANCE, dn);
    }

    public static X500Name getRFC4519X500Name(ASN1Encodable name) {
        return X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)name);
    }

    public static void main(String[] args) {
        String certDn = "DNQUALIFIER=66,SN=11,TITLE=77";
        certDn = "CN=00,DC=11,GIVENNAME=22,INITIALS=33,STREET=44,TELEPHONENUMBER=55,UID=66";
        X500Name dn4519 = DnUtil.getRFC4519X500Name(certDn);
        System.out.println("4519:" + dn4519);
        CertTemplateBuilder myCertTemplate = new CertTemplateBuilder();
        myCertTemplate.setSubject(dn4519);
        CertTemplate certTemplate = myCertTemplate.build();
        System.out.println(" cmp:" + DnUtil.getRFC4519X500Name((ASN1Encodable)certTemplate.getSubject()));
    }

    @Test
    public void certDN() {
        String s = "-----BEGIN CERTIFICATE-----\nMIIDrjCCApagAwIBAgIEEAAAsDANBgkqhkiG9w0BAQsFADAeMQswCQYDVQQGEwJD\nTjEPMA0GA1UEAwwGcm9vdENhMB4XDTIwMDQxNTEyMTkwMFoXDTIzMDQxNTEyMTkw\nMFowgZUxCzAJBgNVBAYTAkNOMQwwCgYDVQQKDANSU0ExDzANBgNVBAsMBlhESkFS\nQTESMBAGCgmSJomT8ixkAQEMAjY2MQswCQYDVQQUEwI1NTELMAkGA1UECQwCNDQx\nCzAJBgNVBCsMAjMzMQswCQYDVQQqDAIyMjESMBAGCgmSJomT8ixkARkWAjExMQsw\nCQYDVQQDDAIwMDCCASIwDQYJKoZIhvcNAQEBBQADggEPADCCAQoCggEBAKQ2gJam\naMMC/fmmU/JNIUWKXY02+dtx9HDwTs4YnbuTpazGr1Cge3N7t2pbsZ12XtVneim3\n/o2t6JuQovaPAih1C/KCJQFTp7s7JgqcIYQzEV7YxOnKwNlMPGpD5dds6QderGVu\noyMnHvwCJ/V0k9HBjqItEQTGVtFHzg+4QfHrWvcDqThIqVEID5AtIF//zaLBxcMx\nJ1wKxHZadnhBFjT/vIdVLB+jEI7M3pObCzbBBo0RfYZGZYifz50Uu/STHPGFUI/s\nfKV0SKZ4euZVSXm83AUlOH1U2ECR2NMTGWm4NRHHLnQ7nFYT8swfRhaJYSV50+JF\nvSwzzUPQNC5b9aUCAwEAAaN8MHowSQYDVR0jBEIwQIAUbkFLbD6jjC3OUB90CIXX\nIhKmS8ShIqQgMB4xCzAJBgNVBAYTAkNOMQ8wDQYDVQQDDAZyb290Q2GCBBAAAAAw\nHQYDVR0OBBYEFOTOkrqZEqgGTKA/IgGXDTD7IXK8MA4GA1UdDwEB/wQEAwID+DAN\nBgkqhkiG9w0BAQsFAAOCAQEAbpWv5Mvjq3XcMEisJB9KJcFVqZnsmM1paaHEjQx8\nfHGxfJ7Yfe0Dtp//49v50NXH3CKmMF8TPahnkAIvxADdHs95/+hb05reTwTUH3X8\nQqUSTlU6Bzt6P5BPH7iP9070ynq6xySWnwLVuw/jOk79STiUiE8hcZYM4/KVkWiH\ntz/nGcD+FjZQxjNeS9X1gVHxbjVExH8xor0h6fQ3Niym/M6R7BzOWaV/iw3Fu23n\nrlmkLOrAHPrtI0XBqHMlhCI+BOohsh6Zj8MdQK8Xl0x3odMhxP22qCtvznWyUNzc\nrEtORRwaTvb/dDIf0wny8AoLCDsyhmdmUIIkVNGKlgTpsQ==\n-----END CERTIFICATE-----\n";
        X509Certificate certificate = CertUtils.getCertFromStr(s);
        String dn2 = certificate.getSubjectX500Principal().getName();
        System.out.println("dn2 :" + dn2);
        X500Name name2 = DnUtil.getRFC4519X500Name(dn2);
        System.out.println("name2 : " + name2.toString());
    }

    static {
        DN.put("2.5.4.6", "C");
        DN.put("2.5.4.3", "CN");
        DN.put("2.5.4.7", "L");
        DN.put("2.5.4.10", "O");
        DN.put("2.5.4.11", "OU");
        DN.put("2.5.4.5", "SN");
        DN.put("2.5.4.8", "ST");
        DN.put("0.9.2342.19200300.100.1.1", "Uid");
    }
}

