/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import java.util.Hashtable;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.DERIA5String;
import org.bouncycastle.asn1.DERPrintableString;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;
import org.bouncycastle.asn1.x500.style.AbstractX500NameStyle;
import org.bouncycastle.asn1.x500.style.IETFUtils;

public class RFC4519StyleUpperCase
extends AbstractX500NameStyle {
    public static final ASN1ObjectIdentifier c = new ASN1ObjectIdentifier("2.5.4.6").intern();
    public static final ASN1ObjectIdentifier o = new ASN1ObjectIdentifier("2.5.4.10").intern();
    public static final ASN1ObjectIdentifier ou = new ASN1ObjectIdentifier("2.5.4.11").intern();
    public static final ASN1ObjectIdentifier title;
    public static final ASN1ObjectIdentifier T;
    public static final ASN1ObjectIdentifier cn;
    public static final ASN1ObjectIdentifier serialNumber;
    public static final ASN1ObjectIdentifier sn;
    public static final ASN1ObjectIdentifier street;
    public static final ASN1ObjectIdentifier l;
    public static final ASN1ObjectIdentifier st;
    public static final ASN1ObjectIdentifier givenName;
    public static final ASN1ObjectIdentifier initials;
    public static final ASN1ObjectIdentifier generationQualifier;
    public static final ASN1ObjectIdentifier x500UniqueIdentifier;
    public static final ASN1ObjectIdentifier businessCategory;
    public static final ASN1ObjectIdentifier postalCode;
    public static final ASN1ObjectIdentifier dnQualifier;
    public static final ASN1ObjectIdentifier DN;
    public static final ASN1ObjectIdentifier dc;
    public static final ASN1ObjectIdentifier uid;
    public static final ASN1ObjectIdentifier houseIdentifier;
    public static final ASN1ObjectIdentifier description;
    public static final ASN1ObjectIdentifier destinationIndicator;
    public static final ASN1ObjectIdentifier distinguishedName;
    public static final ASN1ObjectIdentifier enhancedSearchGuide;
    public static final ASN1ObjectIdentifier facsimileTelephoneNumber;
    public static final ASN1ObjectIdentifier internationalISDNNumber;
    public static final ASN1ObjectIdentifier member;
    public static final ASN1ObjectIdentifier name;
    public static final ASN1ObjectIdentifier owner;
    public static final ASN1ObjectIdentifier physicalDeliveryOfficeName;
    public static final ASN1ObjectIdentifier postalAddress;
    public static final ASN1ObjectIdentifier postOfficeBox;
    public static final ASN1ObjectIdentifier preferredDeliveryMethod;
    public static final ASN1ObjectIdentifier registeredAddress;
    public static final ASN1ObjectIdentifier roleOccupant;
    public static final ASN1ObjectIdentifier searchGuide;
    public static final ASN1ObjectIdentifier seeAlso;
    public static final ASN1ObjectIdentifier telephoneNumber;
    public static final ASN1ObjectIdentifier teletexTerminalIdentifier;
    public static final ASN1ObjectIdentifier telexNumber;
    public static final ASN1ObjectIdentifier uniqueMember;
    public static final ASN1ObjectIdentifier userPassword;
    public static final ASN1ObjectIdentifier x121Address;
    private static final Hashtable DefaultSymbols;
    private static final Hashtable DefaultLookUp;
    public static final X500NameStyle INSTANCE;
    protected final Hashtable defaultLookUp;
    protected final Hashtable defaultSymbols = RFC4519StyleUpperCase.copyHashTable((Hashtable)DefaultSymbols);

    protected RFC4519StyleUpperCase() {
        this.defaultLookUp = RFC4519StyleUpperCase.copyHashTable((Hashtable)DefaultLookUp);
    }

    protected ASN1Encodable encodeStringValue(ASN1ObjectIdentifier oid, String value) {
        if (oid.equals((Object)dc)) {
            return new DERIA5String(value);
        }
        if (oid.equals((Object)c) || oid.equals((Object)serialNumber) || oid.equals((Object)dnQualifier) || oid.equals((Object)telephoneNumber)) {
            return new DERPrintableString(value);
        }
        return super.encodeStringValue(oid, value);
    }

    public String oidToDisplayName(ASN1ObjectIdentifier oid) {
        return (String)DefaultSymbols.get(oid);
    }

    public String[] oidToAttrNames(ASN1ObjectIdentifier oid) {
        return IETFUtils.findAttrNamesForOID((ASN1ObjectIdentifier)oid, (Hashtable)this.defaultLookUp);
    }

    public ASN1ObjectIdentifier attrNameToOID(String attrName) {
        return IETFUtils.decodeAttrName((String)attrName, (Hashtable)this.defaultLookUp);
    }

    public RDN[] fromString(String dirName) {
        RDN[] tmp = IETFUtils.rDNsFromString((String)dirName, (X500NameStyle)this);
        RDN[] res = new RDN[tmp.length];
        for (int i = 0; i != tmp.length; ++i) {
            res[res.length - i - 1] = tmp[i];
        }
        return res;
    }

    public String toString(X500Name name) {
        StringBuffer buf = new StringBuffer();
        boolean first = true;
        RDN[] rdns = name.getRDNs();
        for (int i = rdns.length - 1; i >= 0; --i) {
            if (first) {
                first = false;
            } else {
                buf.append(',');
            }
            IETFUtils.appendRDN((StringBuffer)buf, (RDN)rdns[i], (Hashtable)this.defaultSymbols);
        }
        return buf.toString();
    }

    static {
        T = title = new ASN1ObjectIdentifier("2.5.4.12").intern();
        cn = new ASN1ObjectIdentifier("2.5.4.3").intern();
        serialNumber = new ASN1ObjectIdentifier("2.5.4.5").intern();
        sn = new ASN1ObjectIdentifier("2.5.4.4").intern();
        street = new ASN1ObjectIdentifier("2.5.4.9").intern();
        l = new ASN1ObjectIdentifier("2.5.4.7").intern();
        st = new ASN1ObjectIdentifier("2.5.4.8").intern();
        givenName = new ASN1ObjectIdentifier("2.5.4.42").intern();
        initials = new ASN1ObjectIdentifier("2.5.4.43").intern();
        generationQualifier = new ASN1ObjectIdentifier("2.5.4.44").intern();
        x500UniqueIdentifier = new ASN1ObjectIdentifier("2.5.4.45").intern();
        businessCategory = new ASN1ObjectIdentifier("2.5.4.15").intern();
        postalCode = new ASN1ObjectIdentifier("2.5.4.17").intern();
        DN = dnQualifier = new ASN1ObjectIdentifier("2.5.4.46").intern();
        dc = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.25").intern();
        uid = new ASN1ObjectIdentifier("0.9.2342.19200300.100.1.1").intern();
        houseIdentifier = new ASN1ObjectIdentifier("2.5.4.51").intern();
        description = new ASN1ObjectIdentifier("2.5.4.13").intern();
        destinationIndicator = new ASN1ObjectIdentifier("2.5.4.27").intern();
        distinguishedName = new ASN1ObjectIdentifier("2.5.4.49").intern();
        enhancedSearchGuide = new ASN1ObjectIdentifier("2.5.4.47").intern();
        facsimileTelephoneNumber = new ASN1ObjectIdentifier("2.5.4.23").intern();
        internationalISDNNumber = new ASN1ObjectIdentifier("2.5.4.25").intern();
        member = new ASN1ObjectIdentifier("2.5.4.31").intern();
        name = new ASN1ObjectIdentifier("2.5.4.41").intern();
        owner = new ASN1ObjectIdentifier("2.5.4.32").intern();
        physicalDeliveryOfficeName = new ASN1ObjectIdentifier("2.5.4.19").intern();
        postalAddress = new ASN1ObjectIdentifier("2.5.4.16").intern();
        postOfficeBox = new ASN1ObjectIdentifier("2.5.4.18").intern();
        preferredDeliveryMethod = new ASN1ObjectIdentifier("2.5.4.28").intern();
        registeredAddress = new ASN1ObjectIdentifier("2.5.4.26").intern();
        roleOccupant = new ASN1ObjectIdentifier("2.5.4.33").intern();
        searchGuide = new ASN1ObjectIdentifier("2.5.4.14").intern();
        seeAlso = new ASN1ObjectIdentifier("2.5.4.34").intern();
        telephoneNumber = new ASN1ObjectIdentifier("2.5.4.20").intern();
        teletexTerminalIdentifier = new ASN1ObjectIdentifier("2.5.4.22").intern();
        telexNumber = new ASN1ObjectIdentifier("2.5.4.21").intern();
        uniqueMember = new ASN1ObjectIdentifier("2.5.4.50").intern();
        userPassword = new ASN1ObjectIdentifier("2.5.4.35").intern();
        x121Address = new ASN1ObjectIdentifier("2.5.4.24").intern();
        DefaultSymbols = new Hashtable();
        DefaultLookUp = new Hashtable();
        DefaultSymbols.put(businessCategory, "businessCategory".toUpperCase());
        DefaultSymbols.put(c, "c".toUpperCase());
        DefaultSymbols.put(cn, "CN");
        DefaultSymbols.put(dc, "dc".toUpperCase());
        DefaultSymbols.put(description, "description".toUpperCase());
        DefaultSymbols.put(destinationIndicator, "destinationIndicator".toUpperCase());
        DefaultSymbols.put(distinguishedName, "distinguishedName".toUpperCase());
        DefaultSymbols.put(dnQualifier, "dnQualifier".toUpperCase());
        DefaultSymbols.put(enhancedSearchGuide, "enhancedSearchGuide".toUpperCase());
        DefaultSymbols.put(facsimileTelephoneNumber, "facsimileTelephoneNumber".toUpperCase());
        DefaultSymbols.put(generationQualifier, "generationQualifier".toUpperCase());
        DefaultSymbols.put(givenName, "givenName".toUpperCase());
        DefaultSymbols.put(houseIdentifier, "houseIdentifier".toUpperCase());
        DefaultSymbols.put(initials, "initials".toUpperCase());
        DefaultSymbols.put(internationalISDNNumber, "internationalISDNNumber".toUpperCase());
        DefaultSymbols.put(l, "l".toUpperCase());
        DefaultSymbols.put(member, "member".toUpperCase());
        DefaultSymbols.put(name, "name".toUpperCase());
        DefaultSymbols.put(o, "o".toUpperCase());
        DefaultSymbols.put(ou, "ou".toUpperCase());
        DefaultSymbols.put(owner, "owner".toUpperCase());
        DefaultSymbols.put(physicalDeliveryOfficeName, "physicalDeliveryOfficeName".toUpperCase());
        DefaultSymbols.put(postalAddress, "postalAddress".toUpperCase());
        DefaultSymbols.put(postalCode, "postalCode".toUpperCase());
        DefaultSymbols.put(postOfficeBox, "postOfficeBox".toUpperCase());
        DefaultSymbols.put(preferredDeliveryMethod, "preferredDeliveryMethod".toUpperCase());
        DefaultSymbols.put(registeredAddress, "registeredAddress".toUpperCase());
        DefaultSymbols.put(roleOccupant, "roleOccupant".toUpperCase());
        DefaultSymbols.put(searchGuide, "searchGuide".toUpperCase());
        DefaultSymbols.put(seeAlso, "seeAlso".toUpperCase());
        DefaultSymbols.put(serialNumber, "serialNumber".toUpperCase());
        DefaultSymbols.put(sn, "sn".toUpperCase());
        DefaultSymbols.put(st, "st".toUpperCase());
        DefaultSymbols.put(street, "street".toUpperCase());
        DefaultSymbols.put(telephoneNumber, "telephoneNumber".toUpperCase());
        DefaultSymbols.put(teletexTerminalIdentifier, "teletexTerminalIdentifier".toUpperCase());
        DefaultSymbols.put(telexNumber, "telexNumber".toUpperCase());
        DefaultSymbols.put(title, "title".toUpperCase());
        DefaultSymbols.put(uid, "uid".toUpperCase());
        DefaultSymbols.put(uniqueMember, "uniqueMember".toUpperCase());
        DefaultSymbols.put(userPassword, "userPassword".toUpperCase());
        DefaultSymbols.put(x121Address, "x121Address".toUpperCase());
        DefaultSymbols.put(x500UniqueIdentifier, "x500UniqueIdentifier".toUpperCase());
        DefaultLookUp.put("businesscategory", businessCategory);
        DefaultLookUp.put("c", c);
        DefaultLookUp.put("cn", cn);
        DefaultLookUp.put("dc", dc);
        DefaultLookUp.put("description", description);
        DefaultLookUp.put("destinationindicator", destinationIndicator);
        DefaultLookUp.put("distinguishedname", distinguishedName);
        DefaultLookUp.put("dnqualifier", dnQualifier);
        DefaultLookUp.put("enhancedsearchguide", enhancedSearchGuide);
        DefaultLookUp.put("facsimiletelephonenumber", facsimileTelephoneNumber);
        DefaultLookUp.put("generationqualifier", generationQualifier);
        DefaultLookUp.put("givenname", givenName);
        DefaultLookUp.put("houseidentifier", houseIdentifier);
        DefaultLookUp.put("initials", initials);
        DefaultLookUp.put("internationalisdnnumber", internationalISDNNumber);
        DefaultLookUp.put("l", l);
        DefaultLookUp.put("member", member);
        DefaultLookUp.put("name", name);
        DefaultLookUp.put("o", o);
        DefaultLookUp.put("ou", ou);
        DefaultLookUp.put("owner", owner);
        DefaultLookUp.put("physicaldeliveryofficename", physicalDeliveryOfficeName);
        DefaultLookUp.put("postaladdress", postalAddress);
        DefaultLookUp.put("postalcode", postalCode);
        DefaultLookUp.put("postofficebox", postOfficeBox);
        DefaultLookUp.put("preferreddeliverymethod", preferredDeliveryMethod);
        DefaultLookUp.put("registeredaddress", registeredAddress);
        DefaultLookUp.put("roleoccupant", roleOccupant);
        DefaultLookUp.put("searchguide", searchGuide);
        DefaultLookUp.put("seealso", seeAlso);
        DefaultLookUp.put("serialnumber", serialNumber);
        DefaultLookUp.put("sn", sn);
        DefaultLookUp.put("st", st);
        DefaultLookUp.put("street", street);
        DefaultLookUp.put("telephonenumber", telephoneNumber);
        DefaultLookUp.put("teletexterminalidentifier", teletexTerminalIdentifier);
        DefaultLookUp.put("telexnumber", telexNumber);
        DefaultLookUp.put("title", title);
        DefaultLookUp.put("uid", uid);
        DefaultLookUp.put("uniquemember", uniqueMember);
        DefaultLookUp.put("userpassword", userPassword);
        DefaultLookUp.put("x121address", x121Address);
        DefaultLookUp.put("x500uniqueidentifier", x500UniqueIdentifier);
        INSTANCE = new RFC4519StyleUpperCase();
    }
}

