/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.ra.utils.RFC4519StyleUpperCase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.naming.NamingException;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.X500NameStyle;

public class DnUtil {
    private static final Map<String, String> DN = new HashMap<String, String>();
    private static final List<String> DefaultLookUp = new ArrayList<String>();

    public static X500Name getRFC4519X500Name(String dn) throws NamingException {
        dn = DnUtil.encodeDn(dn);
        return new X500Name(RFC4519StyleUpperCase.INSTANCE, dn);
    }

    public static X500Name getRFC4519X500Name(ASN1Encodable name) {
        return X500Name.getInstance((X500NameStyle)RFC4519StyleUpperCase.INSTANCE, (Object)name);
    }

    public static RDN[] reverseRdns(RDN[] array) {
        RDN[] newArray = new RDN[array.length];
        for (int i = 0; i < newArray.length; ++i) {
            newArray[i] = array[array.length - i - 1];
        }
        return newArray;
    }

    public static String encodeDn(String dnName) throws NamingException {
        String[] strs = dnName.split(",");
        StringBuffer dnBuffer = new StringBuffer();
        boolean flag = true;
        for (int i = 0; i < strs.length; ++i) {
            boolean valueFlag = true;
            String dnSelf = strs[i];
            for (int n = 0; n < DefaultLookUp.size(); ++n) {
                String dnKey = DefaultLookUp.get(n);
                String convertDn = dnSelf.toLowerCase().trim().replaceAll("\\s+", "");
                if (!convertDn.startsWith(dnKey.toLowerCase())) continue;
                String[] convertDns = convertDn.split("=");
                if (convertDns.length >= 3) {
                    throw new NamingException("DN\u4e2d\u540c\u4e00\u4e2a\u5173\u952e\u5b57\u4e2d\u542b\u6709\u591a\u4e2a\u7b49\u53f7:" + dnSelf);
                }
                if (flag) {
                    flag = false;
                } else {
                    dnBuffer.append(",");
                }
                dnBuffer.append(dnSelf);
                valueFlag = false;
                break;
            }
            if (!valueFlag) continue;
            if (dnSelf.contains("=")) {
                throw new NamingException("DN\u4e2d\u5173\u952e\u5b57\u5bf9\u5e94\u7684\u503c\u4e2d\u4e0d\u80fd\u542b\u6709\u7b49\u53f7:" + dnSelf);
            }
            dnBuffer.append("\\,").append(dnSelf);
        }
        return dnBuffer.toString();
    }

    static {
        DN.put("2.5.4.6", "C");
        DN.put("2.5.4.3", "CN");
        DN.put("2.5.4.7", "L");
        DN.put("2.5.4.10", "O");
        DN.put("2.5.4.11", "OU");
        DN.put("2.5.4.8", "ST");
        DN.put("0.9.2342.19200300.100.1.25", "DC");
        DN.put("2.5.4.46", "dnQualifier");
        DN.put("2.5.4.42", "givenName");
        DN.put("2.5.4.43", "initials");
        DN.put("2.5.4.4", "SN");
        DN.put("2.5.4.9", "street");
        DN.put("2.5.4.12", "title");
        DN.put("2.5.4.20", "telephoneNumber");
        DN.put("0.9.2342.19200300.100.1.1", "UID");
        DN.put(PKCSObjectIdentifiers.pkcs_9_at_emailAddress.getId(), "E");
        DefaultLookUp.add(PKCSObjectIdentifiers.pkcs_9_at_emailAddress.getId() + "=");
        DefaultLookUp.add("businesscategory=");
        DefaultLookUp.add("c=");
        DefaultLookUp.add("cn=");
        DefaultLookUp.add("dc=");
        DefaultLookUp.add("description=");
        DefaultLookUp.add("destinationindicator=");
        DefaultLookUp.add("distinguishedname=");
        DefaultLookUp.add("dnqualifier=");
        DefaultLookUp.add("enhancedsearchguide=");
        DefaultLookUp.add("facsimiletelephonenumber=");
        DefaultLookUp.add("generationqualifier=");
        DefaultLookUp.add("givenname=");
        DefaultLookUp.add("houseidentifier=");
        DefaultLookUp.add("initials=");
        DefaultLookUp.add("internationalisdnnumber=");
        DefaultLookUp.add("l=");
        DefaultLookUp.add("member=");
        DefaultLookUp.add("name=");
        DefaultLookUp.add("o=");
        DefaultLookUp.add("ou=");
        DefaultLookUp.add("owner=");
        DefaultLookUp.add("physicaldeliveryofficename=");
        DefaultLookUp.add("postaladdress=");
        DefaultLookUp.add("postalcode=");
        DefaultLookUp.add("postofficebox=");
        DefaultLookUp.add("preferreddeliverymethod=");
        DefaultLookUp.add("registeredaddress=");
        DefaultLookUp.add("roleoccupant=");
        DefaultLookUp.add("searchguide=");
        DefaultLookUp.add("seealso=");
        DefaultLookUp.add("serialnumber=");
        DefaultLookUp.add("sn=");
        DefaultLookUp.add("st=");
        DefaultLookUp.add("street=");
        DefaultLookUp.add("telephonenumber=");
        DefaultLookUp.add("teletexterminalidentifier=");
        DefaultLookUp.add("telexnumber=");
        DefaultLookUp.add("title=");
        DefaultLookUp.add("uid=");
        DefaultLookUp.add("uniquemember=");
        DefaultLookUp.add("userpassword=");
        DefaultLookUp.add("x121address=");
        DefaultLookUp.add("x500uniqueidentifier=");
        DefaultLookUp.add("emailaddress=");
        DefaultLookUp.add("e=");
    }
}

