/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.xdja.ra.utils.JsonNavigator;
import com.xdja.ra.utils.SdkJsonException;
import java.lang.reflect.Type;

public class SdkJsonUtils {
    private static Feature[] features = new Feature[0];

    public static <T> T json2Object(String json, Class<T> clazz) {
        try {
            return (T)JSON.parseObject((String)json, clazz, (Feature[])features);
        }
        catch (Exception e) {
            throw new SdkJsonException("\u89e3\u6790json\u9519\u8bef: class: " + clazz.getName() + ", json: " + json, e);
        }
    }

    public static <T> T json2Object(String json, TypeReference<T> tr) {
        try {
            return (T)JSON.parseObject((String)json, (Type)tr.getType(), (Feature[])features);
        }
        catch (Exception e) {
            throw new SdkJsonException("\u89e3\u6790json\u9519\u8bef: type: " + tr.getType().getTypeName() + ", json: " + json, e);
        }
    }

    public static JsonNavigator json2Object(String json) {
        try {
            return new JsonNavigator(JSON.parseObject((String)json, (Feature[])features));
        }
        catch (Exception e) {
            throw new SdkJsonException("\u89e3\u6790json\u9519\u8bef, json: " + json, e);
        }
    }

    public static <T> String object2Json(T entity) {
        try {
            return JSON.toJSONString(entity, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteDateUseDateFormat});
        }
        catch (Exception e) {
            throw new SdkJsonException("\u8f6c\u6362json\u9519\u8bef");
        }
    }

    static {
        JSON.DEFFAULT_DATE_FORMAT = "yyyy-MM-dd HH:mm:ss";
    }
}

