/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileUtils {
    protected static final transient Logger logger = LoggerFactory.getLogger(FileUtils.class.getClass());

    public static String read(String path) throws Exception {
        StringBuilder content = new StringBuilder();
        BufferedReader reader = null;
        try {
            File file = new File(path);
        }
        catch (Exception e) {
            logger.error("\u521b\u5efa\u6587\u4ef6", (Throwable)e);
        }
        try {
            String temp;
            reader = new BufferedReader(new FileReader(new File(path)));
            while (null != (temp = reader.readLine())) {
                content.append(temp);
            }
            String string = content.toString();
            return string;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            if (null != reader) {
                try {
                    reader.close();
                }
                catch (IOException e) {
                    logger.error("\u8bfb\u53d6\u6587\u4ef6\u65f6\u6d41\u5173\u95ed\u5f02\u5e38", (Throwable)e);
                }
            }
        }
    }

    public static String readByBytes(String path) {
        String content = null;
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(path);
            StringBuffer sb = new StringBuffer();
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                sb.append(new String(bytes, 0, c, "utf-8"));
            }
            content = sb.toString();
        }
        catch (Exception e) {
            logger.error("\u4ee5\u5b57\u8282\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Throwable)e);
            throw new RuntimeException("\u4ee5\u5b57\u8282\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return content;
    }

    public static String readByLines(String path) {
        String content = null;
        BufferedReader bufferedReader = null;
        try {
            File file = new File(path);
            if (!file.exists() && !file.createNewFile()) {
                logger.error("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38", (Throwable)new Exception("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38"));
            }
            bufferedReader = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(path), "utf-8"));
            StringBuffer sb = new StringBuffer();
            String temp = null;
            while ((temp = bufferedReader.readLine()) != null) {
                sb.append(temp);
            }
            content = sb.toString();
        }
        catch (Exception e) {
            logger.error("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Throwable)e);
            throw new RuntimeException("\u4ee5\u884c\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != bufferedReader) {
                    bufferedReader.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return content;
    }

    public static String readByChars(String path) {
        String content = null;
        Reader reader = null;
        try {
            reader = new InputStreamReader((InputStream)new FileInputStream(path), "utf-8");
            StringBuffer sb = new StringBuffer();
            char[] tempchars = new char[1024];
            while (reader.read(tempchars) != -1) {
                sb.append(tempchars);
            }
            content = sb.toString();
        }
        catch (Exception e) {
            logger.error("\u4ee5\u5b57\u7b26\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6", (Throwable)e);
            throw new RuntimeException(" \u4ee5\u5b57\u7b26\u4e3a\u5355\u4f4d\u8bfb\u53d6\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != reader) {
                    reader.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        return content;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean saveAs(String content, String path) {
        OutputStreamWriter fw = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                File file = new File(path);
                if (file.exists() && !file.delete()) {
                    logger.error("\u5220\u9664\u6587\u4ef6\u5f02\u5e38", (Throwable)new Exception("\u5220\u9664\u6587\u4ef6\u5f02\u5e38"));
                }
                if (!file.createNewFile()) {
                    logger.error("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38", (Throwable)new Exception("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38"));
                }
                fw = new FileWriter(file, false);
                if (content != null) {
                    fw.write(content);
                }
                fw.flush();
                // ** MonitorExit[var3_3] (shouldn't be in output)
                boolean bl = true;
                return bl;
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != fw) {
                    fw.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(String content, String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        OutputStreamWriter fw = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                fw = new FileWriter(new File(path), false);
                if (content != null) {
                    fw.write(content);
                }
                fw.flush();
                // ** MonitorExit[var4_5] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException e) {
                    logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Throwable)e);
                }
            }
        }
        {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void saveFile(byte[] content, String path) {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdirs())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        OutputStream out = null;
        InputStream is = null;
        try {
            Class<FileUtils> clazz = FileUtils.class;
            synchronized (FileUtils.class) {
                out = new FileOutputStream(new File(path), false);
                is = new ByteArrayInputStream(content);
                byte[] buff = new byte[1024];
                int len = 0;
                while ((len = is.read(buff)) != -1) {
                    out.write(buff, 0, len);
                }
                // ** MonitorExit[var5_6] (shouldn't be in output)
            }
        }
        catch (IOException e) {
            logger.error("\u5199\u5165\u914d\u7f6e\u6587\u4ef6\u5f02\u5e38", (Throwable)e);
        }
        finally {
            try {
                if (null != is) {
                    is.close();
                }
                if (null != out) {
                    out.close();
                }
            }
            catch (IOException e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u5199\u5165\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
        {
            return;
        }
    }

    public static byte[] readByBinary(String path) {
        FileInputStream inputStream = null;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            inputStream = new FileInputStream(path);
            int c = 0;
            byte[] bytes = new byte[1024];
            while ((c = ((InputStream)inputStream).read(bytes)) != -1) {
                baos.write(bytes, 0, c);
            }
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u8bfb\u53d6\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != inputStream) {
                    ((InputStream)inputStream).close();
                }
                baos.close();
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static void writeByBinary(String path, byte[] datas) throws IOException {
        boolean mkdir;
        File file = new File(path);
        if (!file.getParentFile().exists() && !(mkdir = file.getParentFile().mkdir())) {
            throw new RuntimeException("\u521b\u5efa\u76ee\u6807\u6587\u4ef6\u6240\u5728\u76ee\u5f55\u5931\u8d25\uff01");
        }
        if (!file.exists() && !file.createNewFile()) {
            logger.error("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38", (Throwable)new Exception("\u521b\u5efa\u6587\u4ef6\u5f02\u5e38"));
        }
        FileOutputStream os = null;
        try {
            os = new FileOutputStream(path);
            ((OutputStream)os).write(datas);
        }
        catch (Exception e) {
            logger.error("\u5199\u5165\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u5199\u5165\u6587\u4ef6\u4e8c\u8fdb\u5236\u5185\u5bb9\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != os) {
                    ((OutputStream)os).close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void write(OutputStream out, File file) throws Exception {
        FileInputStream in = null;
        try {
            in = new FileInputStream(file);
            byte[] data = new byte[1024];
            int size = 0;
            while ((size = ((InputStream)in).read(data)) != -1) {
                out.write(data, 0, size);
            }
        }
        finally {
            try {
                if (null != in) {
                    ((InputStream)in).close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }
}

