/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLBCSignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLRSASignUtils;
import com.xdja.pki.gmssl.crypto.utils.GMSSLSM2SignUtils;
import com.xdja.pki.gmssl.x509.utils.bean.GMSSLSignatureAlgorithm;
import com.xdja.ra.asn1.RsaObjectIdentifiers;
import com.xdja.ra.asn1.SM2ObjectIdentifiers;
import java.security.PublicKey;
import java.security.cert.X509Certificate;

public class SdkBCUtils {
    public static boolean verifyCertByBC(String protectionAlgId, PublicKey publicKey, byte[] sourceData, byte[] signData) throws Exception {
        boolean verifyResult = false;
        verifyResult = SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(protectionAlgId) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData) : GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])sourceData, (byte[])signData)));
        return verifyResult;
    }

    public static boolean verifyCertByBC(X509Certificate cert, PublicKey publicKey) throws Exception {
        String sigAlgOID = cert.getSigAlgOID();
        boolean verifyResult = false;
        verifyResult = SM2ObjectIdentifiers.sm2SignWithSm3.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLSM2SignUtils.verifyByBC((PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : (RsaObjectIdentifiers.sha1WithRSA.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA1_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : (RsaObjectIdentifiers.sha256WithRSA.getId().equalsIgnoreCase(sigAlgOID) ? GMSSLRSASignUtils.verifyByBC((String)GMSSLSignatureAlgorithm.SHA256_WITH_RSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature()) : GMSSLBCSignUtils.verifySignature((String)GMSSLSignatureAlgorithm.SHA256_WITH_ECDSA.getSigAlgName(), (PublicKey)publicKey, (byte[])cert.getTBSCertificate(), (byte[])cert.getSignature())));
        return verifyResult;
    }
}

