/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.pki.gmssl.core.utils.GMSSLX509Utils;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jcajce.provider.asymmetric.ec.BCECPublicKey;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPublicKeySpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.util.BigIntegers;
import org.bouncycastle.util.encoders.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkCertUtils {
    private static Logger logger = LoggerFactory.getLogger(SdkCertUtils.class);
    public static final String CERT_HEAD = "-----BEGIN CERTIFICATE-----";
    public static final String CERT_TAIL = "-----END CERTIFICATE-----";
    public static final String PKCS7_HEAD = "-----BEGIN PKCS7-----";
    public static final String PKCS7_TAIL = "-----END PKCS7-----";
    public static final String PUBLIC_KEY_HEAD = "-----BEGIN PUBLIC KEY-----";
    public static final String PUBLIC_KEY_TAIL = "-----END PUBLIC KEY-----";

    public static X509Certificate getCertFromStr16(String str) {
        byte[] bs = SdkCertUtils.hex2byte(str);
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(bs);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromFullStr com.xdja.ra.error: ", (Throwable)e);
            return null;
        }
    }

    public static byte[] hex2byte(String str) {
        if (null == str || "".equals(str)) {
            return null;
        }
        StringBuffer sb = new StringBuffer(str = str.trim());
        int len = sb.length();
        if (len == 0 || len % 2 == 1) {
            return null;
        }
        byte[] b = new byte[len / 2];
        try {
            for (int i = 0; i < len; i += 2) {
                b[i / 2] = (byte)Integer.decode("0x" + sb.substring(i, i + 2)).intValue();
            }
            return b;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static X509Certificate getCertFromStr(String str) {
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        X509Certificate x509Cert = SdkCertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = SdkCertUtils.getCertFromFullStr(str);
        }
        if (x509Cert == null) {
            x509Cert = SdkCertUtils.getCertFromStr16(str);
        }
        return x509Cert;
    }

    public static X509Certificate getCertFromFullStr(String str) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(str.getBytes());
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromFullStr com.xdja.ra.error: ", (Throwable)e);
            return null;
        }
    }

    public static synchronized X509Certificate getCertFromB64(String b64) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            X509Certificate x509Cert = (X509Certificate)cf.generateCertificate(inStream);
            return x509Cert;
        }
        catch (Exception e) {
            logger.error("getCertFromB64 com.xdja.ra.error: ", (Throwable)e);
            return null;
        }
    }

    public static String getSn(X509Certificate cert) {
        return cert.getSerialNumber().toString(16).toLowerCase();
    }

    public static String getSnFillZero(X509Certificate cert) {
        String sn = cert.getSerialNumber().toString(16).toLowerCase();
        int length = sn.length();
        if (length % 2 != 0) {
            sn = "0" + sn;
        }
        return sn;
    }

    public static String certToFullB64(Certificate cert) {
        if (cert == null) {
            return null;
        }
        String certb64 = "";
        try {
            certb64 = SdkCertUtils.bytesToFullB64(cert.getEncoded());
        }
        catch (Exception e) {
            logger.error("certToFullB64 com.xdja.ra.error:", (Throwable)e);
        }
        return certb64;
    }

    public static String bytesToFullB64(byte[] certder) {
        try {
            String certb64 = new String(Base64.encode((byte[])certder));
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n" + CERT_TAIL + "\n";
            return certb64;
        }
        catch (Exception e) {
            logger.error("certDerToFullB64 com.xdja.ra.error:", (Throwable)e);
            return null;
        }
    }

    public static String bytesToFullB642(byte[] certder) {
        try {
            String certb64 = new String(Base64.encode((byte[])certder));
            certb64 = "-----BEGIN CERTIFICATE-----\n" + certb64 + "\n" + CERT_TAIL + "\n";
            return certb64;
        }
        catch (Exception e) {
            logger.error("certDerToFullB64 com.xdja.ra.error:", (Throwable)e);
            return null;
        }
    }

    public static X509Certificate convertDerCertToCert(byte[] certder) {
        CertificateFactory cf = null;
        X509Certificate x509Cert = null;
        try {
            cf = CertificateFactory.getInstance("X.509", "BC");
            ByteArrayInputStream inStream = new ByteArrayInputStream(certder);
            x509Cert = (X509Certificate)cf.generateCertificate(inStream);
        }
        catch (Exception e) {
            logger.error("\u8bc1\u4e66\u8f6c\u6362\u5f02\u5e38", (Throwable)e);
        }
        if (null != x509Cert) {
            return x509Cert;
        }
        String str = new String(certder);
        str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
        str = str.replace("\r", "").replace("\n", "");
        x509Cert = SdkCertUtils.getCertFromB64(str = str.replace("\\r", "").replace("\\n", ""));
        if (x509Cert == null) {
            x509Cert = SdkCertUtils.getCertFromStr16(str);
        }
        return x509Cert;
    }

    public static final String convertHexStr2Base64(String hexStr) {
        byte[] data = SdkCertUtils.hexStr2Bytes(hexStr);
        return new String(Base64.encode((byte[])data));
    }

    private static final byte[] hexStr2Bytes(String hexStr) {
        hexStr = hexStr.toUpperCase();
        int length = hexStr.length() / 2;
        char[] hexChars = hexStr.toCharArray();
        byte[] data = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            data[i] = (byte)(SdkCertUtils.charToByte(hexChars[pos]) << 4 | SdkCertUtils.charToByte(hexChars[pos + 1]) & 0xFF);
        }
        return data;
    }

    private static final byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }

    public static final boolean isSignCert(String cert) {
        X509Certificate x509 = SdkCertUtils.getCertFromB64(cert);
        if (null == x509) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u8f6c\u6362\u975e\u6cd5");
        }
        return SdkCertUtils.isSignCert(x509);
    }

    public static final boolean isSignCert(X509Certificate cert) {
        boolean[] keyUsages = cert.getKeyUsage();
        return keyUsages[0] || keyUsages[1];
    }

    public static final boolean isEncCert(String cert) {
        X509Certificate x509 = SdkCertUtils.getCertFromB64(cert);
        if (null == x509) {
            throw new IllegalArgumentException("\u8bc1\u4e66\u8f6c\u6362\u975e\u6cd5");
        }
        return SdkCertUtils.isEncCert(x509);
    }

    public static final boolean isEncCert(X509Certificate cert) {
        boolean[] keyUsages = cert.getKeyUsage();
        return keyUsages[2] || keyUsages[3] || keyUsages[7] || keyUsages[8];
    }

    public static List<X509Certificate> getCertListFromB64(byte[] info) {
        if (null == info) {
            return null;
        }
        CertificateFactory cf = null;
        List certificates = null;
        ByteArrayInputStream inStream = null;
        try {
            inStream = new ByteArrayInputStream(info);
            cf = CertificateFactory.getInstance("X.509", "BC");
            certificates = (List)cf.generateCertificates(inStream);
            if (null != certificates && certificates.size() != 0) {
                List list = certificates = SdkCertUtils.sortCerts(certificates);
                return list;
            }
            String str = new String(info);
            str = str.replace(CERT_HEAD, "").replace(CERT_TAIL, "");
            str = str.replace("\r", "").replace("\n", "");
            byte[] certByte = Base64.decode((String)(str = str.replace("\\r", "").replace("\\n", "")));
            if (certByte == null || certByte.length == 0) {
                certByte = SdkCertUtils.hex2byte(str);
            }
            if (null != (certificates = (List)cf.generateCertificates(inStream = new ByteArrayInputStream(certByte)))) {
                List list = certificates = SdkCertUtils.sortCerts(certificates);
                return list;
            }
            List list = certificates;
            return list;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            throw new RuntimeException("\u83b7\u53d6\u8bc1\u4e66\u94fe\u5f02\u5e38");
        }
        finally {
            try {
                if (null != inStream) {
                    ((InputStream)inStream).close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static List<Certificate> getSortCertListFromB64(String b64P7b) {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            byte[] bsCert = Base64.decode((String)b64P7b);
            ByteArrayInputStream inStream = new ByteArrayInputStream(bsCert);
            List certificates = (List)cf.generateCertificates(inStream);
            Iterator it = certificates.iterator();
            ArrayList<Certificate> list = new ArrayList();
            while (it.hasNext()) {
                Certificate elem = (Certificate)it.next();
                list.add(elem);
            }
            list = SdkCertUtils.sortCerts(list);
            return list;
        }
        catch (Exception e) {
            logger.error("\u83b7\u53d6\u8bc1\u4e66\u94fe\u5f02\u5e38", (Throwable)e);
            return null;
        }
    }

    public static List sortCerts(List certs) {
        int i;
        if (certs.size() < 2) {
            return certs;
        }
        X500Principal issuer = ((X509Certificate)certs.get(0)).getIssuerX500Principal();
        boolean okay = true;
        for (int i2 = 1; i2 != certs.size(); ++i2) {
            X509Certificate cert = (X509Certificate)certs.get(i2);
            if (!issuer.equals(cert.getSubjectX500Principal())) {
                okay = false;
                break;
            }
            issuer = ((X509Certificate)certs.get(i2)).getIssuerX500Principal();
        }
        if (okay) {
            return certs;
        }
        ArrayList<X509Certificate> retList = new ArrayList<X509Certificate>(certs.size());
        ArrayList orig = new ArrayList(certs);
        for (i = 0; i < certs.size(); ++i) {
            X509Certificate cert = (X509Certificate)certs.get(i);
            boolean found = false;
            X500Principal subject = cert.getSubjectX500Principal();
            for (int j = 0; j != certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!c.getIssuerX500Principal().equals(subject)) continue;
                found = true;
                break;
            }
            if (found) continue;
            retList.add(cert);
            certs.remove(i);
        }
        block3: for (i = 0; i != retList.size(); ++i) {
            issuer = ((X509Certificate)retList.get(i)).getIssuerX500Principal();
            for (int j = 0; j < certs.size(); ++j) {
                X509Certificate c = (X509Certificate)certs.get(j);
                if (!issuer.equals(c.getSubjectX500Principal())) continue;
                retList.add(c);
                certs.remove(j);
                continue block3;
            }
        }
        if (certs.size() > 0) {
            return orig;
        }
        return retList;
    }

    public static Date[] computeNotBeforeAndAfter(int validity, X509Certificate caCert) {
        if (validity < 1 || validity > 10950) {
            validity = 10950;
        }
        Date notBeforeDate = new Date();
        Date notAfteDate = null;
        long notAfter = notBeforeDate.getTime() + 86400000L * (long)validity;
        if (notAfter > caCert.getNotAfter().getTime()) {
            notAfter = caCert.getNotAfter().getTime();
        }
        if (notBeforeDate.getTime() > notAfter) {
            return null;
        }
        notAfteDate = new Date(notAfter);
        return new Date[]{notBeforeDate, notAfteDate};
    }

    public static PublicKey convertSM2PublicKey(String base64) throws Exception {
        base64 = base64.replace(PUBLIC_KEY_HEAD, "").replace(PUBLIC_KEY_TAIL, "");
        base64 = base64.replace("\r", "").replace("\n", "");
        base64 = base64.replace("\\r", "").replace("\\n", "");
        int digestLen = 32;
        byte[] b = Base64.decode((String)base64);
        byte[] x = new byte[digestLen];
        System.arraycopy(b, 1, x, 0, digestLen);
        byte[] y = new byte[digestLen];
        System.arraycopy(b, digestLen + 1, y, 0, digestLen);
        return SdkCertUtils.convertSM2PublicKey(x, y);
    }

    public static PublicKey convertSM2PublicKey(byte[] x, byte[] y) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)GMSSLX509Utils.ECC_SM2_NAME);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curve.createPoint(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y)), (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(GMSSLX509Utils.ECC_SM2_NAME, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PublicKey convertECPublicKey(String base64, String algName) throws Exception {
        int digestLen = 32;
        byte[] b = Base64.decode((String)base64);
        byte[] x = new byte[digestLen];
        System.arraycopy(b, 1, x, 0, digestLen);
        byte[] y = new byte[digestLen];
        System.arraycopy(b, digestLen + 1, y, 0, digestLen);
        return SdkCertUtils.convertECPublicKey(x, y, algName);
    }

    public static PublicKey convertECPublicKey(byte[] x, byte[] y, String algName) throws Exception {
        ECNamedCurveParameterSpec ecParameterSpec = ECNamedCurveTable.getParameterSpec((String)algName);
        ECCurve curve = ecParameterSpec.getCurve();
        ECPublicKeySpec ecPublicKeySpec = new ECPublicKeySpec(curve.createPoint(BigIntegers.fromUnsignedByteArray((byte[])x), BigIntegers.fromUnsignedByteArray((byte[])y)), (ECParameterSpec)ecParameterSpec);
        return new BCECPublicKey(algName, ecPublicKeySpec, BouncyCastleProvider.CONFIGURATION);
    }

    public static PublicKey getPublicKeyFromSubjectPublicKey(SubjectPublicKeyInfo subjectPKInfo, String provider) throws Exception {
        if (subjectPKInfo.getPublicKeyData().equals((Object)DERNull.INSTANCE)) {
            return null;
        }
        try {
            X509EncodedKeySpec xspec = new X509EncodedKeySpec(new DERBitString((ASN1Encodable)subjectPKInfo).getBytes());
            AlgorithmIdentifier keyAlg = subjectPKInfo.getAlgorithm();
            return KeyFactory.getInstance(keyAlg.getAlgorithm().getId(), provider).generatePublic(xspec);
        }
        catch (Exception e) {
            InvalidKeyException newe = new InvalidKeyException("Error decoding public key.");
            newe.initCause(e);
            throw newe;
        }
    }

    public static byte[] byteMergerAll(byte[] ... values) {
        int length_byte = 0;
        for (int i = 0; i < values.length; ++i) {
            length_byte += values[i].length;
        }
        byte[] all_byte = new byte[length_byte];
        int countLength = 0;
        for (int i = 0; i < values.length; ++i) {
            byte[] b = values[i];
            System.arraycopy(b, 0, all_byte, countLength, b.length);
            countLength += b.length;
        }
        return all_byte;
    }

    static {
        if (Security.getProvider("BC") == null) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }
}

