/*
 * Decompiled with CFR 0.152.
 */
package com.xdja.ra.utils;

import com.xdja.ra.utils.CertUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.bouncycastle.asn1.cms.ContentInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.jcajce.JcaCertStore;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.cms.CMSProcessableByteArray;
import org.bouncycastle.cms.CMSSignedData;
import org.bouncycastle.cms.CMSSignedDataGenerator;
import org.bouncycastle.cms.CMSTypedData;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.util.Store;
import org.bouncycastle.util.encoders.Base64;
import org.bouncycastle.util.io.pem.PemObject;
import org.bouncycastle.util.io.pem.PemObjectGenerator;
import org.bouncycastle.util.io.pem.PemReader;
import org.bouncycastle.util.io.pem.PemWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SignedDataUtils {
    public static final String PKCS7_TYPE = "PKCS7";
    private static Logger logger = LoggerFactory.getLogger(SignedDataUtils.class);

    public static String writeP7bPem(CMSSignedData cmsSignedData) throws Exception {
        PemWriter pemWriter = null;
        try {
            PemObject pemObject = new PemObject(PKCS7_TYPE, cmsSignedData.toASN1Structure().getEncoded("DER"));
            StringWriter stringWriter = new StringWriter();
            pemWriter = new PemWriter((Writer)stringWriter);
            pemWriter.writeObject((PemObjectGenerator)pemObject);
            pemWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new Exception("\u5c06p7b\u5bf9\u8c61\u8f6c\u6362\u4e3aPem\u683c\u5f0f\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != pemWriter) {
                    pemWriter.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static String writeP7bPem(ContentInfo contentInfo) throws Exception {
        PemWriter pemWriter = null;
        try {
            PemObject pemObject = new PemObject(PKCS7_TYPE, contentInfo.getEncoded("DER"));
            StringWriter stringWriter = new StringWriter();
            pemWriter = new PemWriter((Writer)stringWriter);
            pemWriter.writeObject((PemObjectGenerator)pemObject);
            pemWriter.flush();
            String string = stringWriter.toString();
            return string;
        }
        catch (Exception e) {
            throw new Exception("\u5c06p7b\u5bf9\u8c61\u8f6c\u6362\u4e3aPem\u683c\u5f0f\u5f02\u5e38", e);
        }
        finally {
            try {
                if (null != pemWriter) {
                    pemWriter.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    public static String createCertChainByCerts(List<X509Certificate> certificateList) throws Exception {
        CMSSignedDataGenerator gen = new CMSSignedDataGenerator();
        try {
            CMSProcessableByteArray msg = new CMSProcessableByteArray("".getBytes());
            JcaCertStore jcaCertStore = new JcaCertStore(certificateList);
            gen.addCertificates((Store)jcaCertStore);
            CMSSignedData cmsSignedData = gen.generate((CMSTypedData)msg);
            return SignedDataUtils.writeP7bPem(cmsSignedData.toASN1Structure());
        }
        catch (Exception e) {
            throw new Exception("\u521b\u5efa\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static List<X509Certificate> resolveCertChain(byte[] signedData) throws Exception {
        List<Object> x509Certificates = new ArrayList();
        try {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(signedData);
            x509Certificates = SignedDataUtils.resolvePemCertChain(inputStream);
        }
        catch (Exception e) {
            ByteArrayInputStream inputStream = new ByteArrayInputStream(signedData);
            try {
                x509Certificates = SignedDataUtils.resolveBase64CertChain(inputStream);
            }
            catch (Exception e1) {
                x509Certificates = SignedDataUtils.resolveByteCertChain(signedData);
            }
        }
        return CertUtils.sortCerts(x509Certificates);
    }

    public static byte[] convertBytesFromStream(FileInputStream in) throws Exception {
        try {
            int count = in.available();
            byte[] b = new byte[count];
            in.read(b, 0, count);
            return b;
        }
        catch (Exception e) {
            logger.error("\u6d41\u8bfb\u53d6\u5f02\u5e38 ", (Throwable)e);
            throw new Exception("\u6d41\u8bfb\u53d6\u5f02\u5e38", e);
        }
    }

    public static List<X509Certificate> resolvePemCertChain(InputStream in) throws Exception {
        try {
            InputStreamReader reader = new InputStreamReader(in);
            PemReader pemReader = new PemReader((Reader)reader);
            PemObject pemObject = pemReader.readPemObject();
            CMSSignedData cmsSignedDataResolve = new CMSSignedData(pemObject.getContent());
            return SignedDataUtils.getX509CertificateListFromSignedData(cmsSignedDataResolve);
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u6362pem\u683c\u5f0f\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static List<X509Certificate> resolveBase64CertChain(InputStream in) throws Exception {
        try {
            String p7b = SignedDataUtils.readBase64FromFile(in);
            p7b = p7b.replaceFirst("-----BEGIN PKCS7-----", "");
            p7b = p7b.replaceFirst("-----END PKCS7-----", "");
            CMSSignedData cmsSignedData = new CMSSignedData(Base64.decode((String)p7b));
            return SignedDataUtils.getX509CertificateListFromSignedData(cmsSignedData);
        }
        catch (Exception e) {
            throw new Exception("\u8f6c\u6362base64\u683c\u5f0f\u7684\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static List<X509Certificate> resolveByteCertChain(byte[] in) throws Exception {
        CMSSignedData cmsSignedData = null;
        try {
            cmsSignedData = new CMSSignedData(in);
        }
        catch (Exception e) {
            cmsSignedData = new CMSSignedData(Base64.decode((byte[])in));
        }
        return SignedDataUtils.getX509CertificateListFromSignedData(cmsSignedData);
    }

    public static List<X509Certificate> getX509CertificateListFromSignedData(CMSSignedData cmsSignedData) throws Exception {
        ArrayList<X509Certificate> certificateList = new ArrayList<X509Certificate>();
        try {
            Store store = cmsSignedData.getCertificates();
            Collection collection = store.getMatches(null);
            for (X509CertificateHolder x509CertificateHolder : collection) {
                X509Certificate x509Certificate = new JcaX509CertificateConverter().setProvider("BC").getCertificate(x509CertificateHolder);
                certificateList.add(x509Certificate);
            }
            return certificateList;
        }
        catch (Exception e) {
            throw new Exception("\u4ececmsSignedData\u4e2d\u83b7\u53d6\u8bc1\u4e66\u94fe\u5f02\u5e38", e);
        }
    }

    public static String readBase64FromFile(InputStream in) throws Exception {
        StringBuffer stringBuffer = new StringBuffer();
        try {
            BufferedReader br = null;
            String pemStr = "";
            br = new BufferedReader(new InputStreamReader(in));
            while ((pemStr = br.readLine()) != null) {
                stringBuffer.append(pemStr);
            }
            String string = stringBuffer.toString();
            return string;
        }
        catch (Exception e) {
            throw new Exception("\u4ece\u6587\u4ef6\u4e2d\u89e3\u6790base64\u5b57\u7b26\u4e32", e);
        }
        finally {
            try {
                if (null != in) {
                    in.close();
                }
            }
            catch (Exception e) {
                logger.error("\u5173\u95ed\u6587\u4ef6\u6d41\u5f02\u5e38", (Throwable)e);
            }
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

